; -------------------------------------------------------------------------------------------------------------- ;
; Beach Head - LOCODE.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; -------------------------------------------------------------------------------------------------------------- ;
; $0000 - $00ff:  Zero Page Values
; $0100 - $01ff:  Processor Stack
; $0200 - $02ff:  Work Values and C64 system
; $0300 - $03ff:  Work Values and C64 system
; $0400 - $07ff:  Screen: Status
; $0550 - $07a8:  Scores: Top Ten
; $0800 - $1dff:  Code:   Basic Program
; $1e00 - $3fff:  Code:   LOcode
; $4000 - $43ff:  Screen: 1st
; $4400 - $47ff:  Screen: 2nd - for scrolling tanks on the beach
; $4800 - $4fff:  Data:   Char sets
; $5000 - $6577:  Data:   Sprites
; $6850 - $bfff:  Code:   HIcode
; $c000 - $cfff:  <unused>
; $f000 - $feff:  <unused>
; $ff00 - $ffff:  Copy:   Kernel
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ BH_MemCodeHi          ; Beach Head - HICODE.prg
; -------------------------------------------------------------------------------------------------------------- ;
; ShowStartScreen       Does    : Called from BASIC
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowStartScreen         lda #BLACK                  ; .hbu013.
                        sta TabBackGroundColor      ; .hbu013.
                        
                        jsr ClearGfxScreen          ; .hbu013. - BASIC 210
                        jsr ClearChapterColor       ; .hbu013.
                        jsr TabSpritesWaitsInits    ; .hbu001.
                        jsr C64Init                 ; 
                        
                        lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        ora #VIC_Cols40             ; ....#... - 40 columns
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #$01                    ; screen A
                        sta TabTankActiveScreen     ; 
                        
                        ldx #BH_ChapterIntro        ; .hbu013.
                        jsr LoadChapterData         ; .hbu013.
                        
                        lda #YELLOW                 ; 
                        sta TabBackGroundColorStat  ; 
                        
.ShowTime               lda #$05                    ; 
                        sta TabWaitTimeTOD_Sec      ; 
                        jsr WaitTOD1_Sec            ; 
                        
                        lda #$00                    ; 
                        sta TabBackGroundColorStat  ; BLACK
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
                        sta TO2HRS                  ; CIA2($DD0B) Time of Day Clock Hours
                        
                        jsr C64Reset                ; 
ShowStartScreenX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter_BayAreaMap    Does    : Display the bay area map - Main Loop
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_BayAreaMap      subroutine                  ; 
                        jsr BayAreaMapInit          ; 
                        
.BayAreaMap_Loop        jsr MapMyFleetGetMoves      ; get joystick directions
                        jsr MapMyFleetSetMoves      ; try to move fleet
                        jsr MapHitCaveEntrance      ; to --> Chapter 1  : Cave Crossing
                        jsr MapCloseBayAndChase     ; 
                        jsr MapHitSeaShootOuts      ; to --> Chapter 2+3: Sea  Shootouts
                        jsr MapHitBeachTankHill     ; to --> Chapter 4+5: Tank Shootouts
                        jsr MapBlinkTargetsPing     ; 
                        jsr CheckGamePause          ; with C= commodore key
                        jsr ScreenStatusShowScore   ; 
                        jsr MapChkFinished          ; Quit/Idle time/Death - 1 level return to BASIC via GameStart
                        jsr ScreenStatusShowShips   ; 
                        jsr CheckGameIdleTime       ; 
                        jsr MapDemo                 ; 
                        
Chapter_BayAreaMapX     jmp .BayAreaMap_Loop        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BayAreaMapInit        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BayAreaMapInit          subroutine                  ; 
                        lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$01                    ; screen A
                        sta TabTankActiveScreen     ; 
                        
                        lda SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        ora #$08                    ; ....#... - 40 columns
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        jsr MapInitBayArea          ; 
                        
                        lda #$03                    ; ......##
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #TabBayMapSeaChaptersYes; bay shootouts first
                        sta TabBayMapSeaChapters    ; 
                        
BayAreaMapInitX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapInitBayAreaToBeach Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapInitBayAreaToBeach   subroutine                  ; 
                        lda #TabBayMapSeaChaptersNo ; 
                        sta TabBayMapSeaChapters    ; 
                        jsr MapInitBayArea          ; 
                        
.SetMyFleet             lda TabMyFleetPosX          ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda TabMyFleetMsbPosX       ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda TabMyFleetPosY          ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$00                    ; 
.Clear                  jsr SpritesAcToTabActive    ; 
                        
                        lda #$01                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
MapInitBayAreaToBeachX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitChapterSfx        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitChapterSfx          subroutine                  ; 
                        jsr ResetSid                ; 
                        
                        lda #$f7                    ; 
                        sta RESON                   ; SID($D417) Filter Resonance Ctrl
                        
                        lda TabSetFilterCutHi,x     ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        
                        lda TabSetFilterCutHi_5a    ; 
                        sta TabFilterCutHi          ; 
                        
InitChapterSfxX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapInitBayArea        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapInitBayArea          subroutine                  ; 
                        jsr ClearStatusScreen       ; 
                        
                        ldx #BH_ChapterBayAreaMap   ; .hbu013.
                        jsr LoadChapterData         ; .hbu013.
                        
                        jsr SpritesReset            ; 
                        
                        lda #$01                    ; .......#
                        sta TabSfxToPlay            ; 
                        
                        jsr ResetSid                ; 
                        lda #$50                    ; 
                        sta SUREL2                  ; SID($D40D) Oscillator 2 Sustain/Release
                        lda #$81                    ; 
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        
                        lda #$06                    ; 
                        sta TabWaitTimeBayLeRiSav   ; my fleet
                        sta TabWaitTimeBayUpDoSav   ; 
                        
                        lda #$05                    ; 
                        sta TabWaitTimeBayLeRiSavE  ; enemy fleet - moves a bit quicker than my fleet
                        sta TabWaitTimeBayUpDoSavE  ; 
                        
                        lda #$20                    ; 
                        sta TabWaitTimeBayBlinkSav  ; 
                        
                        lda #$00                    ; 
                        sta TabMoveSpriteLeRiTime   ; 
                        sta TabMoveSpriteUpDoTime   ; 
                        
                        lda #BH_BayFleetMyStartPosX ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_BayFleetMyStartPosX_Msb ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        lda #BH_BayFleetMyStartPosY ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_Map_03          ; fleet 4 ships
                        sta BH_SpritePointer00_A    ; 
                        
                        lda #BH_BayFleetEnemyStartPosX ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_BayFleetEnemyStartPosY ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_Map_08          ; fleet 5 ships
                        sta BH_SpritePointer01_A    ; 
                        
                        lda #BH_SprtColorFleetMy    ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #BH_SprtColorFleetEnemy ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
MapInitBayAreaX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetGetMoves    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetGetMoves      subroutine                  ; 
                        lda TabWaitFlagMoveUpDo     ; TabWaitFlag_Yes
                        bne .StickReset             ; 
                        
.PrepMyFleetMove        inc TabWaitFlagMoveUpDo     ; TabWaitFlag_Yes
                        
.ChkLeft                lda #CIA_Joy_Le             ; .....#..
                        bit TabJoysticAction        ; 
                        beq .ChkRight               ; 
                        
.WasLeft                jsr MapMyFleetMoveSetLeft   ; 
                        jmp .ChkUp                  ; 
                        
.ChkRight               lda #CIA_Joy_Ri             ; ....#...
                        bit TabJoysticAction        ; 
                        beq .ChkUp                  ; 
                        
.WasRight               jsr MapMyFleetMoveSetRight  ; 
                        
.ChkUp                  lda #CIA_Joy_Up             ; .......#
                        bit TabJoysticAction        ; 
                        beq .ChkDown                ; 
                        
.WasUp                  jsr MapMyFleetMoveSetUp     ; 
                        jmp .StickReset             ; 
                        
.ChkDown                lda #CIA_Joy_Do             ; ......#.
                        bit TabJoysticAction        ; 
                        beq .StickReset             ; 
                        
.WasDown                jsr MapMyFleetMoveSetDown   ; 
                        
.StickReset             lda #$00                    ; 
                        sta TabJoysticAction        ; 
                        
                        lda TabWaitFlagMoveLeRi     ; 
                        beq .MoveMyFleet            ; TabWaitFlag_No
                        
                        rts                         ; 
                        
.MoveMyFleet            inc TabWaitFlagMoveLeRi     ; TabWaitFlag_Yes
                        
                        lda TabMoveSpriteLeRiTime   ; 
.ChkMoveLeft            cmp #$ff                    ; 
                        bne .ChkMoveRight           ; 
                        
                        jsr MapMyFleetMoveLeft      ; 
                        jmp .ChkMoveDown            ; 
                        
.ChkMoveRight           cmp #$01                    ; 
                        bne .ChkMoveDown            ; 
                        
                        jsr MapMyFleetMoveRight     ; 
                        
.ChkMoveDown            lda TabMoveSpriteUpDoTime   ; 
                        cmp #$ff                    ; 
                        bne .ChkMoveUp              ; 
                        
                        jsr MapMyFleetMoveDown      ; 
                        jmp MapMyFleetGetMovesX     ; 
                        
.ChkMoveUp              cmp #$01                    ; 
                        bne MapMyFleetGetMovesX     ; 
                        
                        jsr MapMyFleetMoveUp        ; 
                        
MapMyFleetGetMovesX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveUp      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveUp        subroutine                  ; 
                        lda #$2e                    ; 
                        cmp SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq MapMyFleetMoveUpX       ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta TabMyFleetPosY          ; 
                        
                        dec SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapMyFleetMoveUpX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveDown    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveDown      subroutine                  ; 
                        lda #$b9                    ; 
                        cmp SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq MapMyFleetMoveDownX     ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta TabMyFleetPosY          ; 
                        
                        inc SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapMyFleetMoveDownX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveLeft    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveLeft      subroutine                  ; 
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .GetPosX                ; 
                        
                        lda #$14                    ; 
                        cmp SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .Exit                   ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabMyFleetPosX          ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabMyFleetMsbPosX       ; 
                        
                        dec SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
.Exit                   rts                         ; 
                        
.GetPosX                lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabMyFleetPosX          ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabMyFleetMsbPosX       ; 
                        
                        dec SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bpl .Exit                   ; 
                        
                        lda #$fe                    ; #######.
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
MapMyFleetMoveLeftX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveRight   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveRight     subroutine                  ; 
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .GetPosX                ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabMyFleetPosX          ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabMyFleetMsbPosX       ; 
                        
                        inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne .Exit                   ; 
                        
                        lda #$01                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.Exit                   rts                         ; 
                        
.GetPosX                lda #$44                    ; 
                        cmp SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .Exit                   ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabMyFleetPosX          ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabMyFleetMsbPosX       ; 
                        
                        inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
MapMyFleetMoveRightX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetSetMoves    Does  : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetSetMoves      subroutine                  ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        and #$01                    ; .......#
                        bne .GetFleetPosX           ; 
                        
                        rts                         ; hit an obstacle so don't move
                        
.GetFleetPosX           lda TabMyFleetPosX          ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda TabMyFleetMsbPosX       ; 
                        and #$01                    ; 
                        beq .GetFleetMsbPosX        ; 
                        
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .SetFleetMsbPosX        ; 
                        
.GetFleetMsbPosX        lda #$fe                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.SetFleetMsbPosX        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda TabMyFleetPosY          ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapMyFleetSetMovesX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveSetLeft Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveSetLeft   subroutine                  ; 
                        lda TabMoveSpriteLeRiTime   ; 
                        bmi MapMyFleetMoveSetLeftX  ; 
                        
                        dec TabMoveSpriteLeRiTime   ; 
                        
MapMyFleetMoveSetLeftX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveSetRight Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveSetRight  subroutine                  ; 
                        lda TabMoveSpriteLeRiTime   ; 
                        cmp #$01                    ; 
                        beq MapMyFleetMoveSetRightX ; 
                        
                        inc TabMoveSpriteLeRiTime   ; 
                        
MapMyFleetMoveSetRightX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveSetUp   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveSetUp     subroutine                  ; 
                        lda TabMoveSpriteUpDoTime   ; 
                        cmp #$01                    ; 
                        beq MapMyFleetMoveSetUpX    ; 
                        
                        inc TabMoveSpriteUpDoTime   ; 
                        
MapMyFleetMoveSetUpX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapMyFleetMoveSetDown Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapMyFleetMoveSetDown   subroutine                  ; 
                        lda TabMoveSpriteUpDoTime   ; 
                        bmi MapMyFleetMoveSetDownX  ; 
                        
                        dec TabMoveSpriteUpDoTime   ; 
                        
MapMyFleetMoveSetDownX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapBlinkTargetsPing   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapBlinkTargetsPing     subroutine                  ; 
                        lda TabWaitFlagAutoAction   ; 
                        beq .SetBlinkWait           ; TabWaitFlag_No
                        
                        rts                         ; 
                        
.SetBlinkWait           inc TabWaitFlagAutoAction   ; TabWaitFlag_Yes
                        
                        lda BGCOL1                  ; VIC($D022) Background Color 1
                        and #$0f                    ; ....####
                        bne .GetBlinkBlack          ; 
                        
.GetBlinkYellow         lda #YELLOW                 ; 
                        sta BGCOL1                  ; VIC($D022) Background Color 1
                        
                        lda #LT_RED                 ; .hbu015.
                        sta COLORAM + BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_Box + $00 ; .hbu015.
                        sta COLORAM + BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_Box + $01 ; .hbu015.
                        
                        rts                         ; 
                        
.GetBlinkBlack          lda #BLACK                  ; 
                        sta BGCOL1                  ; VIC($D022) Background Color 1
                        
                        lda #LT_GREEN               ; .hbu015.
                        sta COLORAM + BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_Box + $00 ; .hbu015.
                        sta COLORAM + BH_Scrn_Stat_Row_05 + BH_Scrn_Stat_Box + $01 ; .hbu015.
                        
                        lda #$01                    ; .......#
                        bit TabSfxToPlay            ; 
                        bne .MapPing                ; 
                        
.Exit                   rts                         ; 
                        
.MapPing                lda TabWaitFlagPing         ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagPing         ; TabWaitFlag_Yes
                        
                        lda #$bb                    ; 
                        sta TabWaitTimeBells        ; 
                        
                        lda #$00                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        lda #$0c                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$20                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        lda #$60                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$15                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
.CheckFleetPos          lda TabMoveSpriteLeRiTime   ; 
                        ora TabMoveSpriteUpDoTime   ; 
                        beq .PingOff                ; match - no pings
                        
                        lda #$f0                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        
                        rts                         ; 
                        
.PingOff                lda #$00                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        
MapBlinkTargetsPingX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapCloseBayAndChase   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapCloseBayAndChase     subroutine                  ; 
                        lda TabBayMapSeaChapters    ; 
                        bne .ChkCavePassed          ; TabBayMapSeaChaptersYes
                        
.Exit                   rts                         ; 
                        
.ChkCavePassed          lda TabPlayerCavePassed     ; 
                        bne .ChkCavePassedGame      ; 
                        
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .GetMyFleetPos          ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #BH_BayFleetChaseGoPosY ; 
                        beq .SetBayEnterDirect      ; 
                        
                        rts                         ; 
                        
.GetMyFleetPos          lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        ldx SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cpx #BH_BayPassageLeftPosX  ; 
                        bcc .ChkAdjustPosY          ; lower
                        
                        sec                         ; 
                        sbc #BH_BayRightAdjustPosY  ; posY adjustment
                        
.ChkAdjustPosY          cmp #BH_BayFleetChaseGoPosY - BH_BayRightAdjustPosY - $01 ; 
                        bcc .Exit                   ; lower
                        
.SetBayEnterDirect      lda #TabCavePassedNo        ; 
                        sta TabPlayerCavePassed     ; 
                        
.CloseBay               lda #$52                    ; after passing the entrance/leaving cave
                        sta Screen_BayMap_Barrier1 + $00 ; .hbu013.
                        sta Screen_BayMap_Barrier2 + $00 ; .hbu013.
                        sta Screen_BayMap_Barrier3 + $00 ; .hbu013.
                        
                        lda #$53                    ; 
                        sta Screen_BayMap_Barrier1 + $01 ; .hbu013.
                        sta Screen_BayMap_Barrier2 + $01 ; .hbu013.
                        sta Screen_BayMap_Barrier3 + $01 ; .hbu013.
                        jmp .ChkMoveFleetEnemy      ; 
                        
.ChkCavePassedGame      cmp #TabCavePassedYesGame   ; 
                        bne .ChkMoveFleetEnemy      ; 
                        
.ChkChasePosX           lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #BH_BayFleetChaseGoPosX ; 
                        bcc .ChkChasePosY           ; 
                        
.SetBayEnterViaCave     lda #TabCavePassedYesChase  ; 
                        sta TabPlayerCavePassed     ; 
                        jmp .CloseBay               ; 
                        
.ChkChasePosY           lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #BH_BayFleetChaseGoPosY ; 
                        bne .Exit                   ; 
                        
                        jmp .SetBayEnterViaCave     ; 
                        
.ChkMoveFleetEnemy      lda TabWaitFlagMoveEnemy    ; 
                        beq .MoveFleetEnemy         ; 
                        
                        rts                         ; 
                        
.MoveFleetEnemy         lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveEnemy    ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .ChkFleetsHitPosY       ; 
                        bcs .IncFleetEnemyPosX      ; greater
                        
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .IncFleetEnemyPosX      ; 
                        
.DecFleetEnemyPosX      lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$01                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .ChkFleetsHitPosY       ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$fd                    ; ######.#
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .ChkFleetsHitPosY       ; 
                        
.IncFleetEnemyPosX      inc SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne .ChkFleetsHitPosY       ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        ora #$02                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.ChkFleetsHitPosY       lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        beq MapCloseBayAndChaseX    ; 
                        bcs .IncFleetEnemyPosY      ; 
                        
.DecFleetEnemyPosY      dec SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        rts                         ; 
                        
.IncFleetEnemyPosY      inc SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
MapCloseBayAndChaseX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapChkFinished        Does    : Returns to start screen if idle too long or dead or move left on JoyStick 1
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapChkFinished          subroutine                  ; 
                        lda TabGameMode             ; max idle time reached
                        bmi .NoScores               ; TabGameModeExit
                        
                        lda CIAPRB                  ; CIA1($DC01) Data Port Register B
                        eor #$ff                    ; 
                        and #CIA_KeySelRow_06       ; .hbu003 . - "Q"-uit
                        bne .NoScores               ; 
                        
                        rts                         ; 
                        
.NoScores               lda #TabShowScoresDemo      ; no HiScore entry
                        sta TabPlayerShowScores     ; 
                        lda #TabGameModeGame        ; end demo mode
                        sta TabGameMode             ; 
                        
MapChkFinishedX         jmp GameOver_Rts_One        ; Game over - back to BASIC via GameStart
; -------------------------------------------------------------------------------------------------------------- ;
; MapDemo               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapDemo                 subroutine                  ; 
                        lda TabGameMode             ; 
                        bne .ChkModeMove2Cave       ; TabGameModeDemo or TabGameModeExit
                        
                        rts                         ; 
                        
.ChkModeMove2Cave       cmp #TabGameModeDemoToCave  ; move fleet to cave
                        bne .ChkModeIsInBay         ; 
                        
.MovFleet2Cave          lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #BH_DemoTimeMap         ; 
                        bcs .IniResetTOD2_Cave      ; move myFleet for 5secs only
                        
                        lda #CIA_Joy_Le             ; move fleet left
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
.IniResetTOD2_Cave      jsr ResetTOD2               ; 
                        
.SetMyFleet2Cave        lda #$fe                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #BH_BayFleetHitCavePosX ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_BayFleetHitCavePosY ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        rts                         ; 
                        
.ChkModeIsInBay         cmp #TabGameModeDemoInBay   ; fleet encounters enemy fleet
                        bne .MovMyFleet2Beach       ; TabGameModeDemoToBeach
                        
.SetMyFleetCavePassed   lda #BH_BayFleetChaseGoPosX ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_BayFleetChaseGoPosY ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        rts                         ; 
                        
.MovMyFleet2Beach       lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #BH_DemoTimeBay         ; move myFleet for some secs only
                        bcs .SetMyFleet2Beach       ; 
                        
                        lda #[CIA_Joy_Do + CIA_Joy_Le] ; move fleet down left
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
.SetMyFleet2Beach       jsr ResetTOD2               ; 
                        
                        lda #BH_BayFleetHitBeachPosX; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_BayFleetHitBeachPosY; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
MapDemoX                rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapHitCaveEntrance    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapHitCaveEntrance      subroutine                  ; 
                        lda TabPlayerCavePassed     ; 
                        beq .ChkCaveMapPos          ; 
                        
.NoCaveEntrance         rts                         ; 
                        
.ChkCaveMapPos          lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; 
                        bne .NoCaveEntrance         ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$80                    ; 
                        bcc .NoCaveEntrance         ; 
                        
                        cmp #$88                    ; 
                        bcs .NoCaveEntrance         ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$4a                    ; 
                        bcc .NoCaveEntrance         ; 
                        
                        cmp #$5a                    ; 
                        bcs .NoCaveEntrance         ; 
                        
                        jsr ChapterStartBell        ; 
MapHitCaveEntranceX     jmp Chapter_CaveCrossings   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter_CaveCrossings Does    : Chapter: Mine and torpedo cave
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_CaveCrossings   subroutine                  ; 
                        jsr ScreenStatusGetReady    ; .hbu013.
                        jsr CaveCrossingsInit       ; 
                                                
.CaveCrossings_Loop     jsr CaveMoveShip            ; 
                        jsr SpritesGetSprtCollReg   ; sprite/sprite collision
                        jsr CaveChkHits             ; by torpedoes or background
                        jsr CaveChkExitShip         ; 
                        jsr CaveChkExitTorpedo      ; 
                        jsr ScreenStatusShowShips   ; 
                        jsr CaveSfxShipEngine       ; 
                        jsr CheckGamePause          ; on C= commodore key
                        jsr ScreenStatusShowScore   ; 
                        jsr CheckGameFinished       ; Quit/Idle time/Death - 2 level return to BASIC via GameStart
                        jsr CheckGameIdleTime       ; 
                        jsr CaveDemo                ; 
                        
Chapter_CaveCrossingsX  jmp .CaveCrossings_Loop     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveCrossingsInit     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveCrossingsInit       subroutine                  ; 
                        ldx #BH_ChapterCaveCrossings; .hbu013.
                        jsr LoadChapterData         ; .hbu013.
                        
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr CaveInitTorpedoes       ; 
                        jsr CaveSfxTorpedoShot      ; 
                        jsr CaveInitShip            ; 
                        
CaveCrossingsInitX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveInitTorpedoes     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveInitTorpedoes       subroutine                  ; 
                        lda #SP_Ptr_Cave_03         ; torpedo nee
                        sta BH_SpritePointer01_A    ; 
                        lda #SP_Ptr_Cave_03         ; torpedo nee
                        sta BH_SpritePointer02_A    ; 
                        lda #SP_Ptr_Cave_03         ; torpedo nee
                        sta BH_SpritePointer03_A    ; 
                        lda #SP_Ptr_Cave_04         ; torpedo e
                        sta BH_SpritePointer04_A    ; 
                        lda #SP_Ptr_Cave_04        ; torpedo e
                        sta BH_SpritePointer05_A    ; 
                        lda #SP_Ptr_Cave_04         ; torpedo e
                        sta BH_SpritePointer06_A    ; 
                        lda #SP_Ptr_Cave_04         ; torpedo e
                        sta BH_SpritePointer07_A    ; 
                        
                        lda #BH_SprtColorCaveTorp_1 ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        sta SP6COL                  ; VIC($D02D) Color Sprite 6
                        
                        lda #BH_SprtColorCaveTorp_2 ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        
                        lda #BH_SprtColorCaveTorp_3 ; 
                        sta SP3COL                  ; .hbu008. - VIC($D02A) Color Sprite 3
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        
                        lda #BH_SprtColorCaveTorp_4 ; .hbu008. - follower torpedo #4
                        sta SP4COL                  ; .hbu008. - VIC($D02B) Color Sprite 4
                        
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$fe                    ; #######.
                        sta SPBGPR                  ; VIC($D01B) Sprite to Foreground Display Priority
                        
__CaveSkillTorpLeRi_01  equ * + $01                 ; skill level adaptations
                        lda #$9e                    ; 
                        sta TabMoveSpriteLeRi_01    ; 
__CaveSkillTorpUpDo_01  equ * + $01                 ;                         
                        lda #$8f                    ; 
                        sta TabMoveSpriteUpDo_01    ; 
__CaveSkillTorpLeRi_02  equ * + $01                 ;                         
                        lda #$18                    ; 
                        sta TabMoveSpriteLeRi_02    ; 
__CaveSkillTorpUpDo_02  equ * + $01                 ;                         
                        lda #$0c                    ; 
                        sta TabMoveSpriteUpDo_02    ; 
__CaveSkillTorpLeRi_03  equ * + $01                 ;                         
                        lda #$98                    ; 
                        sta TabMoveSpriteLeRi_03    ; 
__CaveSkillTorpUpDo_03  equ * + $01                 ;                         
                        lda #$8c                    ; 
                        sta TabMoveSpriteUpDo_03    ; 
__CaveSkillTorpLeRi_04  equ * + $01                 ;                         
                        lda #$1e                    ; 
                        sta TabMoveSpriteLeRi_04    ; 
__CaveSkillTorpLeRi_05  equ * + $01                 ;                         
                        lda #$14                    ; 
                        sta TabMoveSpriteLeRi_05    ; 
__CaveSkillTorpLeRi_06  equ * + $01                 ;                         
                        lda #$a0                    ; 
                        sta TabMoveSpriteLeRi_06    ; 
__CaveSkillTorpLeRi_07  equ * + $01                 ;                         
                        lda #$1e                    ; 
                        sta TabMoveSpriteLeRi_07    ; 
                        
                        lda #$00                    ; 
                        sta TabMoveSpriteUpDo_04    ; 
                        sta TabMoveSpriteUpDo_05    ; 
                        sta TabMoveSpriteUpDo_06    ; 
                        sta TabMoveSpriteUpDo_07    ; 
                        
                        lda #$05                    ; 
                        sta TabWaitTimeTOD_10th     ; 
                        
                        ldx #$07                    ; 
.IniTorpedoPos          jsr CaveInitTorpedoPos      ; 
                        
                        lda #$01                    ; 
                        sta TabSpriteActive,x       ; 
                        
                        dex                         ; 
                        bne .IniTorpedoPos          ; 
                        
                        lda #$fe                    ; #######.
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
CaveInitTorpedoesX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveInitTorpedoPos    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveInitTorpedoPos      subroutine                  ; 
.ChkSprite_01           cpx #$01                    ; 
                        bne .ChkSprite_02           ; 
                        
.SetSpritePos_01        lda #$df                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$27                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #$fd                    ; ######.#
                        
.ClrMsbX                and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        jsr SpritesEnableNoFromXr   ; .hbu008.  - enable torpedo again
                        rts                         ; 
                        
.ChkSprite_02           cpx #$02                    ; 
                        bne .ChkSprite_03           ; 
                        
.SetSpritePos_02        lda #$26                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$b7                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
                        lda #$fb                    ; #####.##
                        jmp .ClrMsbX                ; 
                        
.ChkSprite_03           cpx #$03                    ; 
                        bne .ChkSprite_04           ; 
                        
.SetSpritePos_03        lda #$3f                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$5f                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #$08                    ; ....#...
                        jmp .SetMsbX                ; 
                        
.ChkSprite_04           cpx #$04                    ; 
                        bne .ChkSprite_05           ; 
                        
.SetSpritePos_04        lda #$0c                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$50                    ; 
                        bcs .SetSpritePosY_04       ; 
                        
                        lda #$a1                    ; 
                        
.SetSpritePosY_04       sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #$ef                    ; ###.####
                        jmp .ClrMsbX                ; 
                        
.SetMsbX                ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        jsr SpritesEnableNoFromXr   ; .hbu008. - enable torpedo again
                        rts                         ; 
                        
.ChkSprite_05           cpx #$05                    ; 
                        bne .ChkSprite_06           ; 
                        
.SetSpritePos_05        lda #$0c                    ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$7f                    ; 
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        
                        lda #$df                    ; ##.#####
                        jmp .ClrMsbX                ; 
                        
.ChkSprite_06           cpx #$06                    ; 
                        bne .SetSpritePos_07        ; 
                        
.SetSpritePos_06        lda #$5f                    ; 
                        sta SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$5f                    ; 
                        sta SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        
                        lda #$40                    ; .#......
                        jmp .SetMsbX                ; 
                        
.SetSpritePos_07        lda #$0c                    ; 
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #$43                    ; 
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        lda #$7f                    ; .#######
CaveInitTorpedoPosX     jmp .ClrMsbX                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveInitShip          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveInitShip            subroutine                  ; 
                        lda #SP_Ptr_Cave_09         ; ship nww
                        sta BH_SpritePointer00_A    ; 
                        
                        jsr ResetVoc3               ; 
                        lda #$00                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$00                    ; 
                        sta PWLO3                   ; SID($D410) Oscillator 3 Pulse Waveform Width (low byte)
                        lda #$08                    ; 
                        sta PWHI3                   ; SID($D411) Oscillator 3 Pulse Waveform Width (high nybble)
                        lda #$80                    ; 
                        sta SUREL3                  ; SID($D414) Oscillator 3 Sustain/Release
                        lda #$41                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        
                        lda #TabCaveShipDirInit     ; 
                        sta TabCaveShipDir          ; 
                        
                        lda #$10                    ; 
                        sta TabPlaySfxVoc2_00       ; 
                        sta TabPlaySfxVoc1_00       ; 
                        
                        lda #$08                    ; 
                        sta TabPlaySfxVoc2_01       ; 
                        sta TabPlaySfxVoc1_01       ; 
                        
                        lda #TabCaveShipSpeedInit   ; 
                        sta TabCaveShipSpeed        ; 
                        
                        lda #BH_SprtColorShip       ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #$20                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$01                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$a2                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$01                    ; 
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #TabCaveShipExitsNo     ; 
                        sta TabCaveShipExits        ; 
                        jsr SpritesGetSprtCollReg   ; sprite/sprite collision
                        
                        lda #$00                    ; 
                        sta TabSprtSprtCollReg      ; 
                        
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        
CaveInitShipX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveMoveShip          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveMoveShip            subroutine                  ; 
                        lda TabWaitFlagLeRi         ; 
                        bne .ClrJoyLeRi             ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagLeRi         ; TabWaitFlag_Yes
                        
.ChkLeft                lda #CIA_Joy_Le             ; .....#..
                        bit TabJoysticAction        ; 
                        beq .ChkRight               ; 
                        
.WasLeft                jsr ClearDirInJoyAction     ; 
                        
                        lda TabCaveShipDir          ; 
                        beq .ClrJoyLeRi             ; TabCaveShipDirMin
                        
                        dec TabCaveShipDir          ; 
                        
                        jmp .ClrJoyLeRi             ; 
                        
.ChkRight               lda #CIA_Joy_Ri             ; ....#...
                        bit TabJoysticAction        ; 
                        beq .ClrJoyLeRi             ; 
                        
.WasRight               jsr ClearDirInJoyAction     ; 
                        
                        lda TabCaveShipDir          ; 
                        cmp #TabCaveShipDirMax      ; 
                        beq .ClrJoyLeRi             ; 
                        
                        inc TabCaveShipDir          ; 
                        
.ClrJoyLeRi             lda #[CIA_Joy_Le + CIA_Joy_Ri] ; ....##..
                        jsr ClearDirInJoyAction     ; 
                        
                        lda TabCaveShipDir          ; 
                        clc                         ; 
                        adc #SP_Ptr_Cave_08         ; ship w
                        sta BH_SpritePointer00_A    ; 
                        
                        lda TabWaitFlagUpDo         ; 
                        bne .SetShipMoves           ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagUpDo         ; TabWaitFlag_Yes
                        
.ChkUp                  lda #CIA_Joy_Up             ; .......#
                        bit TabJoysticAction        ; 
                        beq .ChkDown                ; 
                        
                        jsr ClearDirInJoyAction     ; 
                        
                        lda TabCaveShipSpeed        ; 
                        cmp #TabCaveShipSpeedMax    ; 
                        beq .SetShipMoves           ; 
                        
                        inc TabCaveShipSpeed        ; 
                        
                        jmp .SetShipMoves           ; 
                        
.ChkDown                lda #CIA_Joy_Do             ; ......#.
                        bit TabJoysticAction        ; 
                        beq .SetShipMoves           ; 
                        
                        jsr ClearDirInJoyAction     ; 
                        
                        lda TabCaveShipSpeed        ; 
                        beq .SetShipMoves           ; 
                        
                        dec TabCaveShipSpeed        ; 
                        
.SetShipMoves           lda #TabCaveShipDirMax      ; 
                        sec                         ; 
                        sbc TabCaveShipDir          ; 
                        jsr CaveGetMoveValue        ; 
                        
                        ora #TabMoveSprite_Le       ; #....... - left
                        sta TabMoveSpriteLeRi       ; 
                        
                        lda TabCaveShipDir          ; 
                        jsr CaveGetMoveValue        ; 
                        
                        sta TabMoveSpriteUpDo       ; 
                        
                        lda #$01                    ; 
                        sta TabSpriteActive         ; 
                        
CaveMoveShipX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveGetMoveValue      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveGetMoveValue        subroutine                  ; 
                        sta TabTempStore            ; $00-$04
                        
                        ldx TabCaveShipSpeed        ; $00-$07
                        bne .DecSpeed               ; 
                        
                        lda #$00                    ; 
                        rts                         ; 
                        
.DecSpeed               dex                         ; 
                        beq CaveGetMoveValueX       ; 
                        
                        clc                         ; 
.AddNext                adc TabTempStore            ; 
                        
                        dex                         ; 
                        bne .AddNext                ; 
                        
                        sta TabTempStore            ; 
                        
CaveGetMoveValueX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveChkHits           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveChkHits             subroutine                  ; 
                        lda TabCaveShipExits        ; 
                        beq .GetSprtSprtColl        ; TabCaveShipExitsNo
                        
                        rts                         ; 
                        
.GetSprtSprtColl        lda TabSprtSprtCollReg      ; 
                        ora SPBGCL                  ; VIC($D01F) Sprite-Background Collision - Cleared on read
                        and #$01                    ; .......#
                        bne .Hit                    ; 
                        
                        rts                         ; 
                        
.Hit                    lda #$00                    ; 
                        sta TabSpriteActive         ; 
                        
                        jsr ResetVoc3               ; 
                        lda #$09                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$2c                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        ldy #$80                    ; 
                        sty VCREG3                  ; SID($D412) Oscillator 3 Control
                        iny                         ; 
                        sty VCREG3                  ; SID($D412) Oscillator 3 Control
                        
.FlashInit              lda #WHITE                  ; 
                        sta TabBackGroundColor      ; 
                        
.Flash                  lda BGCOL0                  ; VIC($D021) Background Color 0
                        and #$0f                    ; ....####
                        beq .Flash                  ; still BLACK
                        
.FlashEnd               lda #BLACK                  ; 
                        sta TabBackGroundColor      ; 
                        
                        lda #$02                    ; 
                        sta TabWaitTimeTOD_10th     ; 
                        
                        lda #BH_SprtColorShipExplode; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda TabSprtSprtCollReg      ; .hbu008.
                        and #$fe                    ; .hbu008. - clear ship
                        beq .ShipExplode            ; .hbu008. - background collision
                        
.ClrTorpedo             eor #$ff                    ; .hbu008. - disable deadly torpedo but keep it moving
                        and SPENA                   ; .hbu008. - do not disturb the torpedo launch rhythm
                        sta SPENA                   ; .hbu008. - VIC($D015) Sprite Enable Register
                        
.ShipExplode            lda #SP_Ptr_Cave_0d         ; explosion phase 1
                        sta BH_SpritePointer00_A    ; 
                        
                        jsr WaitTOD1_10th           ; 
                        
                        lda #SP_Ptr_Cave_0e         ; explosion phase 2
                        sta BH_SpritePointer00_A    ; 
                        
                        jsr WaitTOD1_10th           ; 
                        
                        lda #SP_Ptr_Cave_0f         ; explosion phase 3
                        sta BH_SpritePointer00_A    ; 
                        
                        jsr WaitTOD1_10th           ; 
                        
                        ldx #$00                    ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
                        lda #$09                    ; 
                        sta TabWaitTimeTOD_10th     ; 
                        jsr WaitTOD1_10th           ; 
                        
                        dec TabPlayerLives          ; 
                        bne .GetLives               ; 
                        
                        jsr ScreenStatusGameOver    ; 
                        
                        lda #TabShowScoresNo        ; 
                        sta TabPlayerShowScores     ; 
                        
                        ldx TabPlayerActive         ; 
                        sta TabPlayerShowScore,x    ; 
                        
                        jsr SwitchPlayerAndValues   ; 
                        beq .DecPlayers             ; player #1
                        
                        dec TabPlayerInGame         ; player #2
                        
                        pla                         ; 
                        pla                         ; 
                        jmp Chapter_CaveCrossings   ; 
                        
.DecPlayers             dec TabPlayerInGame         ; 
                        beq .GameOver               ; 
                        
.EndCaveChapter         pla                         ; 
                        pla                         ; 
                        jmp CaveInitBay             ; 
                        
.GameOver               jmp GameOver_Rts_Two        ; Game over - back to BASIC via GameStart
                        
.GetLives               lda TabPlayerLives          ; 
                        cmp TabPlayerShips          ; 
                        beq CaveChkHitsX            ; 
                        
                        lda TabGameMode             ; 
                        bne .IsDemo                 ; TabGameModeDemo or TabGameModeExit
                        
                        ldx #$04                    ; 
                        jsr CaveInitTorpedoPos      ; 
                        jsr CaveInitShip            ; 
                        rts                         ; 
                        
.IsDemo                 lda #TabGameModeDemoInBay   ; fleet encounters enemy fleet
                        sta TabGameMode             ; 
                        jsr ResetTOD2               ; 
                        
CaveChkHitsX            jmp CaveTryNextPlayer       ; 
; -------------------------------------------------------------------------------------------------------------- ;
CaveTryNextPlayer       subroutine                  ; 
                        jsr SpritesReset            ; common enty point
                        
                        lda #$00                    ; 
.Clear                  jsr SpritesAcToTabActive    ; 
                        
                        lda #TabCavePassedYesGame   ; 
                        sta TabPlayerCavePassed     ; 
                        
                        jsr SwitchPlayerAndValues   ; set next player
                        beq .EndCaveChapter         ; player #1 - only one player in game
                        
.SetCaveChapter         pla                         ; player #2 - restart
                        pla                         ; 
                        jmp Chapter_CaveCrossings   ; 
                        
.EndCaveChapter         pla                         ; level 1
                        pla                         ; 
CaveTryNextPlayerX      jmp CaveInitBay             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveInitBay           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveInitBay             subroutine                  ; 
                        lda #TabCavePassedYesGame   ; common enty point
                        sta TabPlayerCavePassed     ; 
                        
                        jsr MapInitBayArea          ; 
                        
                        lda #$70                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$00                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabMyFleetMsbPosX       ; 
                        
                        lda #$78                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$00                    ; 
                        sta TabMoveSpriteLeRiTime   ; 
                        sta TabMoveSpriteUpDoTime   ; 
                        
                        jsr SpritesReset            ; 
                        
                        lda #SP_Ptr_Cave_03         ; torpedo nee
                        sta BH_SpritePointer00_A    ; 
                        
                        lda #$03                    ; ......##
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
CaveInitBayX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveChkExitShip       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveChkExitShip         subroutine                  ; 
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$38                    ; 
                        bcc .ChkMaxPosY             ; lower
                        
.Exit                   rts                         ; 
                        
.ChkMaxPosY             lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$3e                    ; 
                        bcc .SetExitFlag            ; lower
                        
                        rts                         ; 
                        
.SetExitFlag            lda #$01                    ; 
                        sta TabCaveShipExits        ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq .Score                  ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .Score                  ; 
                        
                        rts                         ; 
                        
.Score                  jsr AddScore_2000           ; 
                        jsr AddScore_1000           ; 
                        
                        ldx TabPlayerShips          ; 
                        inx                         ; 
                        stx TabPlayerShips          ; 
                        cpx TabPlayerLives          ; 
                        bne .InitNextShip           ; 
                        
                        jmp CaveTryNextPlayer       ; all available ships made it through the cave
                        
.InitNextShip           jsr CaveInitShip            ; 
                        
                        ldx #$04                    ; 
                        jsr CaveInitTorpedoPos      ; 
CaveChkExitShipX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveChkExitTorpedo    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveChkExitTorpedo      subroutine                  ; 
                        ldx #$07                    ; 
.GetNextPosY            lda TabMoveSpriteUpDo,x     ; 
                        bmi .ChkMaxPosY             ; TabMoveSprite_Do
                        
.ChkMinPosY             jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq .NextTorpedoShot        ; 
                        
                        jmp .GetNextPosX            ; 
                        
.ChkMaxPosY             jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$b8                    ; 
                        bcs .NextTorpedoShot        ; greater/equal
                        
.GetNextPosX            lda TabMoveSpriteLeRi,x     ; 
                        bpl .ChkMaxPosX             ; TabMoveSprite_Ri
                        
                        jsr SetAcToXrTimesMult2     ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .SetNextTorpedo         ; 
                        
.ChkMinPosX             jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .NextTorpedoShot        ; 
                        
                        jmp .SetNextTorpedo         ; 
                        
.ChkMaxPosX             jsr SetAcToXrTimesMult2     ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .SetNextTorpedo         ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$50                    ; 
                        bcs .NextTorpedoShot        ; greater/equal
                        
.SetNextTorpedo         dex                         ; 
                        bne .GetNextPosY            ; 
                        
.Exit                   rts                         ; 
                        
.NextTorpedoShot        jsr CaveInitTorpedoPos      ; 
                        jsr CaveSfxTorpedoShot      ; 
CaveChkExitTorpedoX     jmp .SetNextTorpedo         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveSfxShipEngine     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveSfxShipEngine       subroutine                  ; 
                        lda TabCaveShipSpeed        ; 
                        asl a                       ; 
                        asl a                       ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #$30                    ; 
                        sta FRELO3                  ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        lda #$00                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        
CaveSfxShipEngineX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveSfxTorpedoShot    Does : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveSfxTorpedoShot      subroutine                  ; 
                        lda #$15                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$8a                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$00                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        ldy #$80                    ; 
                        sty VCREG1                  ; SID($D404) Oscillator 1 Control
                        iny                         ; 
                        sty VCREG1                  ; SID($D404) Oscillator 1 Control
                        
CaveSfxTorpedoShotX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CaveDemo              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CaveDemo                subroutine                  ; 
                        lda TabGameMode             ; 
                        bne .DemoMoveShip           ; TabGameModeDemo or TabGameModeExit
                        
                        rts                         ; 
                        
.DemoMoveShip           lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #BH_DemoTimeCave        ; 
                        bcc .ChkMoveUp              ; 
                        
                        jsr ResetTOD2               ; 
                        
                        lda #TabGameModeDemoInBay   ; fleet encounters enemy fleet
                        sta TabGameMode             ; 
                        
                        pla                         ; 
                        pla                         ; 
                        rts                         ; 
                        
.ChkMoveUp              cmp #$06                    ; 
                        bne .ChkMoveRight           ; 
                        
                        lda #CIA_Joy_Up             ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
.ChkMoveRight           cmp #$09                    ; 
                        bne CaveDemoX               ; 
                        
                        lda #CIA_Joy_Ri             ; 
                        sta TabJoysticAction        ; 
                        
CaveDemoX               rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapHitSeaShootOuts    Does    : Prepare Sea ShootOut Chapters
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapHitSeaShootOuts      subroutine                  ; 
                        lda TabBayMapSeaChapters    ; 
                        bne .TstMyFleetPosX         ; TabBayMapSeaChaptersYes
                        
.Exit                   rts                         ; 
                        
.TstMyFleetPosX         lda #$01                    ; .......#
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .TstEnemyFleetPosX      ; 
                        
.ChkHitFleet            lda SPSPCL                  ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                        and #$03                    ; ......##
                        bne .StartPlaneShootOut     ; 
                        
                        rts                         ; 
                        
.TstEnemyFleetPosX      lda #$02                    ; ......#.
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .ChkHitFleet            ; 
                        
.OverlayFleetSprites    sec                         ; 
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sbc SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .ChkOverlayPosX         ; 
                        
                        eor #$ff                    ; 
                        adc #$01                    ; 
                        
.ChkOverlayPosX         cmp #BH_FleetOverlayPosX    ; 
                        bcs .Exit                   ; 
                        
                        sec                         ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sbc SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        bcs .ChkOverlayPosY         ; 
                        
                        eor #$ff                    ; 
                        adc #$01                    ; 
                        
.ChkOverlayPosY         cmp #BH_FleetOverlayPosY    ; 
                        bcs .Exit                   ; 
                        
.StartPlaneShootOut     lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabMyFleetPosX          ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabMyFleetMsbPosX       ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta TabMyFleetPosY          ; 
                        
                        jsr ChapterStartBell        ; 
MapHitSeaShootOutsX     jmp Chapter_PlaneShootOut   ; Start Chapter 02 - Plane shootout
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter_PlaneShootOut Does    : Chapter: Plane shootout
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_PlaneShootOut   subroutine                  ; 
                        jsr ScreenStatusGetReady    ; .hbu013.
                        jsr PlaneShootOutInit       ; 
                        
.PlaneShootOut_Loop     jsr SeaPlaneFlyPhases       ; 
                        jsr SeaPlaneFlyToPlayer     ; 
                        jsr SeaPlaneStartNext       ; 
                        jsr SeaPlaneTranspChkMax    ; 
                        jsr SeaPlaneTranspChkHit    ; 
                        jsr SeaPlaneTranspChkExpl   ; 
                        jsr CannonPlayerMove        ; 
                        jsr CannonPlayerShootInit   ; 
                        jsr SpritesGetSprtCollReg   ; sprite/sprite collision
                        jsr CannonPlayerShoot       ; 
                        jsr PlayerAmmoInc           ; 
                        jsr SeaPlaneChkHit          ; 
                        jsr SeaPlaneExplodeOff      ; 
                        
.ChkFinish              lda TabPlanes2Start         ; 
                        ora TabSpriteActive_05      ; .hbu018.
                        ora TabSpriteActive_06      ; .hbu018.
                        ora TabSpriteActive_07      ; .hbu018.
                        bne .PlaneShootOut_Cont     ; 
                        
                        dec TabWrkXtraLoops         ; .hbu018. - loop a little longer
                        bne .PlaneShootOut_Cont     ; .hbu018.
                        
                        jsr SwitchPlayerAndValues   ; 
                        beq .GoShipShootOut         ; player #1 - next chapter
                        
.PlaneShootOut_Next     jmp Chapter_PlaneShootOut   ; player #2 - restart chapter
                        
.GoShipShootOut         jmp Chapter_ShipShootOut    ; --> SeaLevels - Start next chapter
                        
.PlaneShootOut_Cont     jsr SeaPlaneShootInit       ; 
                        jsr SeaPlaneShoot           ; 
                        jsr SeaPlaneDamageOut       ; switch players & restart / check for game over - exit to BASIC then
                        jsr SeaPlaneSoundTurn       ; 
                        jsr SeaPlaneSoundShoot      ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr ScreenStatusShowAmmo    ; 
                        jsr ScreenStatusShowShips   ; 
                        jsr CheckGamePause          ; on C= commodore key
                        jsr CheckGameFinished       ; Quit/Idle time/Death - 2 level return to BASIC via GameStart
                        jsr ScreenStatusDestroy     ; 
                        jsr CheckGameIdleTime       ; 
                        jsr SeaPlaneDemo            ; 
                        
Chapter_PlaneShootOutX  jmp .PlaneShootOut_Loop     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; PlaneShootOutInit     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
PlaneShootOutInit       subroutine                  ; 
                        ldx #BH_ChapterPlaneShootOut; .hbu013.
                        jsr LoadChapterData         ; .hbu013.
                        
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
.Clear                  jsr SpritesAcToTabActive    ; ac=$00
                        jsr ShootSpritesInit        ; 
                        
__SeaPlaneSkillToHit    equ * + $01                 ; skill level adaptations
.GetSkill               lda #$1e                    ; 
.SetSkill               sta TabPlanes2Start         ; 
                        jsr CannonSpritePosInit     ; 
                        
                        lda #$b5                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$00                    ; 
                        sta TabSpriteStatus_05      ; 
                        
                        lda #$05                    ; 
                        sta TabPlaneFreeSprite      ; 
                        
                        lda #$06                    ; 
                        sta TabPlaneTranspWait      ; 
                        
                        lda #$00                    ; .hbu018.
                        sta TabWrkXtraLoops         ; .hbu018.
                        
                        lda #TabPlaneTranspStatusFree ; 
                        sta TabPlaneTranspStatus    ; 
                        
                        jsr ResetVoc2               ; 
                        jsr InitVoc3                ; 
                        
                        lda #$01                    ; .......#
                        sta TabSfxToPlay            ; 
                        
PlaneShootOutInitX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShootSpritesInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShootSpritesInit        subroutine                  ; 
                        jsr TabSpritesWaitsInits    ; 
                        
                        lda #BH_SprtColorShipCannon ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #BH_SprtColorShipBullet ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        
                        lda #$0b                    ; 
                        sta TabVoc2AttDec           ; 
                        lda #$1c                    ; 
                        sta TabVoc2FreqHi           ; 
                        
                        lda #$00                    ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta TabPlayerShoots         ; TabPlayerShootsNo
                        sta TabBulletDamage         ; 
                        sta TabTargetHit            ; TabTargetHitNo
                        sta BH_SpritePointer04_A    ; 
                        sta TabBulletActive         ; TabBulletActiveNo
                        sta TabSeaShipMsgDestroy    ; TabSeaShipMsgDestroyNo
                        jsr SpritesReset            ; 
                        
                        lda #$0a                    ; 
                        sta TabPlayerAmmo           ; 
                        
                        lda #$01                    ; 
                        sta TabPlayerShootSpriteNo  ; 
                        
                        lda #SP_Ptr_SeaShip_24      ; water splash phase 1 - min
                        sta TabPlrShootSprtBasePtr1 ; 
                        
                        lda #SP_Ptr_SeaShip_30      ; enemy water splash phase 10
                        sta TabPlrShootSprtBasePtr2 ; 
                        
                        lda #TabSpriteStatusExpl    ; 
                        sta TabSpriteStatus_05      ; 
                        sta TabSpriteStatus_06      ; 
                        sta TabSpriteStatus_07      ; 
                        
ShootSpritesInitX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipEneBulletSfxIni Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipEneBulletSfxIni  subroutine                  ; 
                        lda TabBulletActive         ; 
                        cmp #TabBulletActiveYes     ; 
                        beq .ChkSfxBeep             ; 
                        
.Exit                   rts                         ; 
                        
.ChkSfxBeep             lda #$20                    ; ..#.....
                        bit TabSfxToPlay            ; 
                        bne .Exit                   ; 
                        
                        lda TabPlaneDistance        ; 
                        cmp #$02                    ; 
                        bne .Exit                   ; not the correct distance
                        
.SetBeep                lda #$20                    ; ..#.....
                        ora TabSfxToPlay            ; 
                        sta TabSfxToPlay            ; 
                        
                        lda #$01                    ; 
                        sta TabPlaySfxVoc1_05       ; 
                        lda #$02                    ; 
                        sta TabPlaySfxVoc2_05       ; 
                        
                        inc TabWaitFlagSfx          ; TabWaitFlag_Yes
                        
                        jsr ResetVoc3               ; 
                        
                        lda #$f0                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$ff                    ; 
                        sta TabVoc3FreqHi           ; 
                        lda #$11                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        
SeaShipEneBulletSfxIniX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipEneBulletSfxMod Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipEneBulletSfxMod  subroutine                  ; 
                        lda #$20                    ; ..#.....
                        bit TabSfxToPlay            ; 
                        bne .ChkWait                ; 
                        
.Exit                   rts                         ; 
                        
.ChkWait                lda TabWaitFlagSfx          ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagSfx          ; TabWaitFlag_Yes
                        
.LowerTone              lda TabVoc3FreqHi           ; 
                        sec                         ; 
                        sbc #$01                    ; 
                        sta TabVoc3FreqHi           ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        
SeaShipEneBulletSfxModX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlyPhases     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlyPhases       subroutine                  ; 
                        ldx #$07                    ; 
.GetNextSprite          lda TabSpriteStatus,x       ; 
                        bne .ChkActive              ; TabSpriteStatusUsed and TabSpriteStatusExpl
                        
.ChkStartPlanes         lda TabPlanes2Start         ; .hbu018.
                        beq .ChkActive              ; .hbu018. ac=$00
                        
                        dec TabPlanes2Start         ; .hbu018.
                        jsr SeaPlaneSpriteInit      ; returns  ac=$00
                        
.ChkActive              cmp #TabSpriteActiveYes     ; 
                        beq .Active                 ; 
                        
.InActive               jmp .SetNextSprite          ; 
                        
.Active                 lda TabPlaneDistance,x      ; 
                        bne .ChkDist_01             ; 
                        
                        jsr SeaPlaneFlySetPhase00   ; 
                        
.ChkDist_01             lda TabPlaneDistance,x      ; 
                        cmp #$01                    ; 
                        bne .ChkDist_02             ; 
                        
                        jsr SeaPlaneFlySetPhase01   ; 
                        
.ChkDist_02             lda TabPlaneDistance,x      ; 
                        cmp #$02                    ; 
                        bne .ChkDist_03             ; 
                        
                        jsr SeaPlaneFlySetPhase02   ; 
                        
.ChkDist_03             lda TabPlaneDistance,x      ; 
                        cmp #$03                    ; 
                        bne .ChkDist_04             ; 
                        
                        jsr SeaPlaneFlySetPhase03   ; 
                        
.ChkDist_04             lda TabPlaneDistance,x      ; 
                        cmp #$04                    ; 
                        bne .ChkDist_05             ; 
                        
                        jsr SeaPlaneFlySetPhase04   ; 
                        
.ChkDist_05             lda TabPlaneDistance,x      ; 
                        cmp #$05                    ; 
                        bne .SetNextSprite          ; 
                        
                        jsr SeaPlaneFlySetPhase05   ; 
                        
.SetNextSprite          dex                         ; 
                        cpx #$04                    ; 
                        bne .GetNextSprite          ; 
                        
SeaPlaneFlyPhasesX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneSpriteInit    Does    : Start from carrier - Fly left
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneSpriteInit      subroutine                  ; 
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda #BH_SprtStartPlanePosX  ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
.ClrPlanePosX_MSB       jsr SetAcToXrTimesMult2     ; 
                        eor #$ff                    ; ########
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda #BH_SprtStartPlanePosY  ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #BH_SprtColorPlane      ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        
                        lda YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        and #$0f                    ; ....####
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        lda XXPAND                  ; VIC($D01D) Sprite Double Height
                        and #$0f                    ; ....####
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #SP_Ptr_SeaPlane_00     ; plane single sprite phase 1
                        sta BH_SpritePointers_A,x   ; 
                        
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #TabSpriteActiveYes     ; 
                        sta TabSpriteStatus,x       ; 
                        
                        lda #TabSpriteActiveYes     ; 
                        sta TabSpriteActive,x       ; 
                        
                        lda #TabMoveSprite_Le + $10 ; #..#.... - flag: move left + value
                        sta TabMoveSpriteLeRi,x     ; 
                        
                        lda #TabPlaneDirReLiCont    ; 
                        sta TabPlaneDirReLi,x       ; 
                        
                        lda #TabMoveSprite_Up + $02 ; ......#. - flag: move up + value
                        sta TabMoveSpriteUpDo,x     ; 
                        
                        lda #TabPlaneDirUpDo_1      ; 
                        sta TabPlaneDirUpDo,x       ; 
                        
                        lda #$00                    ; 
                        sta TabPlaneFlies,x         ; 
                        sta TabPlaneSpeedAppr,x     ; TabPlaneSpeedApprNone
                        
                        lda #$00                    ; 
                        sta TabSpriteStepCount,x    ; 
                        
                        lda #$06                    ; 
                        sta TabWaitTimePlaneFlyLe,x ; 
                        
                        lda #TabPlaneDist_Ini       ; 
                        sta TabPlaneDistance,x      ; 
                        
SeaPlaneSpriteInitX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlySetPhase00 Does    : Check Turn Point
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlySetPhase00   subroutine                  ; 
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #BH_SprtTurnPlanePosX   ; 
                        bcs SeaPlaneFlySetPhase00X  ; greater/equal - not reached
                        
.StopAndTurn            lda #$00                    ; 
                        sta TabMoveSpriteLeRiTime,x ; 
                        
                        lda #TabPlaneDirReLi_3      ; 
                        sta TabPlaneDirReLi,x       ; 
                        
                        lda #TabPlaneSpeedApprSlow  ; 
                        sta TabPlaneSpeedAppr,x     ; 
                        
                        lda #TabPlaneFliesYes       ; 
                        sta TabPlaneFlies,x         ; 
                        
.SetNextPhase           lda #$01                    ; 
                        sta TabPlaneDistance,x      ; 
                        
SeaPlaneFlySetPhase00X  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlySetPhase01 Does    : Climb and continue flying left
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlySetPhase01   subroutine                  ; 
                        lda TabMoveSpriteLeRi,x     ; 
                        and #$7f                    ; .####### - ignore move left flag
.ChkValue               beq .Climb                  ; 
                        
                        rts                         ; 
                        
.Climb                  lda #TabPlaneDirReLi_4      ; 
                        sta TabPlaneDirReLi,x       ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        jsr GetRND                  ; 
                        
                        cmp #$28                    ; 
                        bcs .SubPosX                ; greater/equal
                        
                        adc #$38                    ; lower
                        
.SubPosX                sec                         ; 
                        sbc SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .Div4                   ; no underflow
                        
                        tay                         ; save
                        
                        lda #TabPlaneDirReLi_2      ; 
                        sta TabPlaneDirReLi,x       ; 
                        
                        tya                         ; restore and make positive
                        eor #$ff                    ; ########
                        adc #$01                    ; 
                        lsr a                       ; div 8
                        
.Div4                   lsr a                       ; 
                        lsr a                       ; 
                        sta TabMoveSpriteLeRiTime,x ; 
                        
                        lda #$01                    ; .......#
                        bit TabSfxToPlay            ; 
                        beq .RndRestore             ; 
                        
                        jsr GetRND                  ; 
                        sta __SeaPlaneSoundPase05   ; 
                        
.RndRestore             jsr GetRND_4a_93            ; 
                        sta TabWrkRnd               ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc TabWrkRnd               ; 
                        bcs .Div_8                  ; no underflow
                        
                        lda #TabMoveSprite_Up + $70 ; .###.... - flag: move up + value * 8
                        
.Div_8                  lsr a                       ; ..###....
                        lsr a                       ; ...###...
                        lsr a                       ; ....###..
                        sta TabMoveSpriteUpDo,x     ; 
                        
                        lda #TabPlaneSpeedApprFast  ; 
                        sta TabPlaneSpeedAppr,x     ; 
                        
.SetNextPhase           lda #$02                    ; 
                        sta TabPlaneDistance,x      ; 
                        
SeaPlaneFlySetPhase01X  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlySetPhase02 Does    : Approach player as single sprite
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlySetPhase02   subroutine                  ; 
                        lda TabSpriteStepCount,x    ; 
                        cmp #$05                    ; 
                        bcs .SetTime                ; greater/equal
                        
                        rts                         ; 
                        
.SetTime                lda #$0c                    ; 
                        sta TabMoveSpriteUpDoTime,x ; 
                        
                        lda #$1e                    ; 
                        sta TabWaitTimePlaneFlySav,x; 
                        
                        lda #TabPlaneDirUpDo_2      ; 
                        sta TabPlaneDirUpDo,x       ; 
                        
.SetNextPhase           lda #$03                    ; 
                        sta TabPlaneDistance,x      ; 
                        
                        lda #SP_Ptr_SeaPlane_01     ; plane single sprite phase 2
                        sta BH_SpritePointers_A,x   ; 
                        
SeaPlaneFlySetPhase02X  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlySetPhase03 Does    : Init/Move Second Plane Sprite as Sprite Number 04
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlySetPhase03   subroutine                  ; 
                        lda TabSpriteStepCount,x    ; 
                        cmp #$0b                    ; $3c+$0B=$47
                        beq .IniSprt_04             ; 
                        
                        clc                         ; 
                        adc #SP_Ptr_SeaPlane_07 - $0b ; plane single sprite phase 3-7
                        sta BH_SpritePointers_A,x   ; 
                        
                        rts                         ; 
                        
.IniSprt_04             jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
.AddPosX_2ndHalf        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$0c                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc .ClrMSB                 ; 
                        
.SetMSB                 lda #$10                    ; ...#....
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .AddPosX_1stHalf        ; 
                        
.ClrMSB                 lda #$ef                    ; ###.####
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.AddPosX_1stHalf        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .GetSprtPtr             ; 
                        
                        jsr SetAcToXrTimesMult2     ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.GetSprtPtr             lda #SP_Ptr_SeaPlane_07     ; plane double sprite phase 1 left
                        sta BH_SpritePointers_A,x   ; 
                        
                        lda #SP_Ptr_SeaPlane_08     ; plane double sprite phase 1 right
                        sta BH_SpritePointer04_A    ; 
                        
                        lda TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi + $04 ; 
                        
                        lda TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo + $04 ; 
                        
                        lda TabPlaneSpeedAppr,x     ; 
                        sta TabPlaneSpeedAppr + $04 ; 
                        
                        lda TabPlaneDirReLi,x       ; 
                        sta TabPlaneDirReLi + $04   ; 
                        
                        lda TabPlaneDirUpDo,x       ; 
                        sta TabPlaneDirUpDo + $04   ; 
                        
                        lda TabPlaneFlies,x         ; 
                        sta TabPlaneFlies + $04     ; 
                        
                        lda TabMoveSpriteLeRiTime,x ; 
                        sta TabMoveSpriteLeRiTime + $04 ; 
                        
                        lda TabMoveSpriteUpDoTime,x ; 
                        sta TabMoveSpriteUpDoTime + $04 ; 
                        
.SetNextPhase           lda #$04                    ; 
                        sta TabPlaneDistance,x      ; 
                        
                        lda #$10                    ; ...#....
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jsr SeaPlaneMov2ndSprite    ; 
                        
                        lda #BH_SprtColorPlane      ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
SeaPlaneFlySetPhase03X  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlySetPhase04 Does    : Continue Flight / Fire / Start Break Off
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlySetPhase04   subroutine                  ; 
                        lda TabSpriteStepCount,x    ; 
                        cmp #$10                    ; 
                        beq .BreakOffPlane          ; 
                        
                        asl a                       ; $20
                        clc                         ; 
                        adc #SP_Ptr_SeaPlane_11 - $20 ; 
                        sta BH_SpritePointers_A,x   ; plane double sprite phase 2 left/right-phase 6 left/right
                        
                        adc #$01                    ; $21
                        sta BH_SpritePointer04_A    ; 
                        
                        jsr SeaPlaneMov2ndSprite    ; 
                        
.ChkShootDistance       lda TabSpriteStepCount,x    ; 
                        cmp #$0d                    ; 
                        bne .Exit                   ; 
                        
.IniShoot               lda #$fe                    ; #######.
                        and TabSfxToPlay            ; 
                        ora #$08                    ; ....#...
                        sta TabSfxToPlay            ; 
                        
                        lda #$06                    ; 
                        sta TabPlaySfxVoc2_06       ; 
                        sta TabPlaySfxVoc1_06       ; 
                        
                        inc TabWaitFlagSfxShot      ; TabWaitFlag_Yes
                        
                        lda #$40                    ; 
                        sta TabPlaySfxVoc1_04       ; 
                        sta TabWaitFlagSfxShotPlane ; TabWaitFlag_Yes + extra
                        
.Exit                   rts                         ; 
                        
.BreakOffPlane          jsr SeaPlaneSoundPase05     ; 
                        
.ChkTurnPointRight      lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$c0                    ; 
                        bcc .ChkTurnPointLeft       ; lower
                        
.TurnUpRight            lda #TabPlaneTurnUpRi       ; 
                        sta TabPlaneTurn            ; 
                        
                        lda #TabMoveSprite_Ri + $1e ; flag: move right + value
                        sta TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi + $04 ; 
                        
                        lda #TabMoveSprite_Up + $1e ; flag: move up + value
                        sta TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo + $04 ; 
                        
                        lda #TabPlaneDirReLiCont    ; 
                        sta TabPlaneDirReLi,x       ; 
                        sta TabPlaneDirReLi + $04   ; 
                        
                        lda #TabPlaneDirUpDo_1      ; 
                        sta TabPlaneDirUpDo,x       ; 
                        sta TabPlaneDirUpDo + $04   ; 
                        
                        lda #SP_Ptr_SeaPlane_1d     ; plane turn away right phase 1 left
                        sta BH_SpritePointers_A,x   ; 
                        
                        lda #SP_Ptr_SeaPlane_1e     ; plane turn away right phase 1 right
                        sta BH_SpritePointer04_A    ; 
                        jmp .SetNextPhase           ; 
                        
.ChkTurnPointLeft       lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$80                    ; 
                        bcc .TurnUpLeft             ; lower
                        
.TurnUp                 lda #TabPlaneTurnUp         ; 
                        sta TabPlaneTurn            ; 
                        
                        lda #TabMoveSprite_Up + $1e ; flag: move up + value
                        sta TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo + $04 ; 
                        
                        lda #TabPlaneDirUpDo_1      ; 
                        sta TabPlaneDirUpDo,x       ; 
                        sta TabPlaneDirUpDo + $04   ; 
                        
                        lda #SP_Ptr_SeaPlane_11     ; 
                        sta BH_SpritePointers_A,x   ; 
                        
                        lda #SP_Ptr_SeaPlane_12     ; 
                        sta BH_SpritePointer04_A    ; 
                        jmp .SetNextPhase           ; 
                        
.TurnUpLeft             lda #TabPlaneTurnUpLe       ; 
                        sta TabPlaneTurn            ; 

                        lda #TabMoveSprite_Le + $30 ; #.##....
                        sta TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi + $04 ; 
                        
                        lda #TabMoveSprite_Up + $1e ; flag: move up + value
                        sta TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo + $04 ; 
                        
                        sta TabPlaneDirReLi,x       ; 
                        sta TabPlaneDirReLi + $04   ; 
                        sta TabPlaneDirUpDo,x       ; 
                        sta TabPlaneDirUpDo + $04   ; 
                        
                        lda #SP_Ptr_SeaPlane_17     ; plane turn away left phase 1 left
                        sta BH_SpritePointers_A,x   ; 
                        
                        lda #SP_Ptr_SeaPlane_18     ; plane turn away left phase 1 right
                        sta BH_SpritePointer04_A    ; 
                        
.SetNextPhase           lda #$05                    ; 
                        sta TabPlaneDistance,x      ; 
                        
SeaPlaneFlySetPhase04X  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlySetPhase05 Does    : Finish Break Off
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlySetPhase05   subroutine                  ; 
                        lda TabMoveSpriteLeRi,x     ; 
                        bpl .UpRightChkMSB          ; TabMoveSprite_Ri
                        
.UpLeft                 jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
.ChkMinPosX             cmp #$02                    ; 
                        bcc .SpriteOff              ; lower
                        bcs .ChkMinPosY             ; higher/equal
                        
.UpRightChkMSB          jsr SetAcToXrTimesMult2     ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .ChkMinPosY             ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$70                    ; 
                        bcs .SpriteOff              ; higher/equal
                        bcc .ChkMinPosY             ; lower
                        
.Chk1stSpritePtrUp      cmp #TabPlaneTurnUp         ; 
                        bne .Set1stSpritePtrUpLe    ; 
                        
.Set1stSpritePtrUp      lda TabSpriteStepCount,x    ; $10
                        asl a                       ; *2
                        clc                         ; 
                        adc #SP_Ptr_SeaPlane_11 - $20 ; plane turn away mid phase 1-3
                        sta BH_SpritePointers_A,x   ; 
                        jmp .Set2ndSpritePointer    ; 
                        
.Set1stSpritePtrUpLe    lda TabSpriteStepCount,x    ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #SP_Ptr_SeaPlane_17 - $20 ; plane turn away left phase 1-3
                        sta BH_SpritePointers_A,x   ; 
                        
.Set2ndSpritePointer    clc                         ; 
                        adc #$01                    ; 
                        sta BH_SpritePointer04_A    ; 
                        
.GoMove2ndSprite        jsr SeaPlaneMov2ndSprite    ; 
.ExitMove2ndSprite      rts                         ; 
                        
.SpriteOff              jsr SpritesDisableNoFromXr  ; 
                        
                        lda #TabSpriteStatusExpl    ; 
                        sta TabSpriteStatus,x       ; 
                        sta TabPlaneDistance,x      ; 
                        
                        lda #TabPlaneDirReLiStop    ; 
                        sta TabPlaneDirReLi,x       ; 
                        sta TabPlaneDirUpDo,x       ; 
                        sta TabPlaneDirReLi_04      ; 
                        sta TabPlaneDirUpDo_04      ; 
                        
                        lda #TabSpriteActiveNo      ; 
                        sta TabSpriteActive,x       ; 
                        
                        lda #$ef                    ; ###.####
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
.ExitOff                rts                         ; 
                        
.ChkMinPosY             jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$28                    ; 
                        bcc .SpriteOff              ; lower
                        
                        lda TabSpriteStepCount,x    ; 
                        cmp #$13                    ; 
                        bcs .GoMove2ndSprite        ; higher/equal
                        
                        lda TabPlaneTurn            ; 
                        cmp #TabPlaneTurnUpRi       ; 
                        bne .Chk1stSpritePtrUp      ; 
                        
.Set1stSpritePtrUpRi    lda TabSpriteStepCount,x    ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #SP_Ptr_SeaPlane_1d - $20 ; plane turn away right phase 1-3
                        sta BH_SpritePointers_A,x   ; 
                        
SeaPlaneFlySetPhase05X  jmp .Set2ndSpritePointer    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneSoundPase05   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneSoundPase05     subroutine                  ; 
                        jsr ResetVoc1               ; 
                        
                        lda #$04                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$01                    ; 
                        sta PWHI1                   ; SID($D403) Oscillator 1 Pulse Waveform Width (high nybble)
                        lda #$bc                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$41                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        lda #$04                    ; .....#..
                        ora TabSfxToPlay            ; 
                        sta TabSfxToPlay            ; 
                        
__SeaPlaneSoundPase05   equ * + $01                 ; 
                        lda #$82                    ; 
                        sta TabVoc1FreqLo           ; 
                        
                        lda #$05                    ; 
                        sta TabVoc3FreqHi           ; 
                        
                        lda #$01                    ; 
                        sta TabPlaySfxVoc2_05       ; 
                        
SeaPlaneSoundPase05X    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneMov2ndSprite  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneMov2ndSprite    subroutine                  ; 
                        jsr SetAcToXrTimesMult2     ; 
                        
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .ClrBit4                ; 
                        
.SetBit4                lda #$10                    ; ...#....
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .SetMSB                 ; 
                        
.ClrBit4                lda #$ef                    ; ###.####
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.SetMSB                 sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
.OffsetRightSide        adc #$18                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc .CpyPosX                ; 
                        
                        lda #$10                    ; ...#....
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.CpyPosX                lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
SeaPlaneMov2ndSpriteX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneFlyToPlayer   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneFlyToPlayer     subroutine                  ; 
                        ldx #$07                    ; 
.GetNextSpriteDirReLi   lda TabPlaneDirReLi,x       ; 
                        bne .ChkReLi_Cont           ; 
                        
                        lda #$00                    ; TabPlaneDirReLiStop
                        sta TabMoveSpriteLeRi,x     ; 
                        jmp .ChkUpDo_96b8_1         ; 
                        
.ChkReLi_Cont           cmp #TabPlaneDirReLiCont    ; 
                        bne .ChkReLi_02             ; 
                        
                        jmp .ChkUpDo_96b8_1         ; 
                        
.ChkReLi_02             cmp #TabPlaneDirReLi_2      ; 
                        bne .ChkReLi_03             ; 
                        
                        lda #TabMoveSprite_Le       ; #....... - flag: move left
                        ora TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi,x     ; 
                        
.ChkReLi_96b8_1         lda TabWaitFlags_Block02,x  ; 
                        bne .ChkUpDo_96b8_1         ; 
                        
                        lda TabMoveSpriteLeRi,x     ; 
                        and #$7f                    ; .#######
                        cmp TabMoveSpriteLeRiTime,x ; 
                        bcs .ChkUpDo_96b8_1         ; greater/equal
                        
                        inc TabMoveSpriteLeRi,x     ; lower
                        jmp .ChkUpDo_96b8_1         ; 
                        
.ChkReLi_03             cmp #TabPlaneDirReLi_3      ; 
                        bne .ChkReLi_04             ; 
                        
                        lda #TabMoveSprite_Le       ; #....... - flag: move left
                        ora TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi,x     ; 
                        
.ChkReLi_96b8_2         lda TabWaitFlags_Block02,x  ; 
                        bne .ChkUpDo_96b8_1         ; 
                        
                        lda TabMoveSpriteLeRi,x     ; 
                        and #$7f                    ; .#######
                        cmp #$00                    ; 
                        beq .ChkUpDo_96b8_1         ; equal
                        bcc .ChkUpDo_96b8_1         ; lower
                        
                        dec TabMoveSpriteLeRi,x     ; 
                        jmp .ChkUpDo_96b8_1         ; 
                        
.ChkReLi_04             cmp #TabPlaneDirReLi_4      ; 
                        bne .ChkReLi_05             ; 
                        
                        lda #$7f                    ; .#######
                        and TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi,x     ; 
                        jmp .ChkReLi_96b8_1         ; 
                        
.ChkReLi_05             cmp #TabPlaneDirReLi_5      ; 
                        bne .GetNextSpriteDirUpDo   ; 
                        
                        lda #$7f                    ; .#######
                        and TabMoveSpriteLeRi,x     ; 
                        sta TabMoveSpriteLeRi,x     ; 
                        jmp .ChkReLi_96b8_2         ; 
                        
.ChkUpDo_96b8_1         lda TabWaitFlags_Block02,x  ; 
                        bne .GetNextSpriteDirUpDo   ; 
                        
                        lda #$01                    ; 
                        sta TabWaitFlags_Block02,x  ; 
                        
.GetNextSpriteDirUpDo   lda TabPlaneDirUpDo,x       ; 
                        bne .ChkUpDo_01             ; 
                        
                        lda #$00                    ; TabMoveSpriteUpDo_None = no value
                        sta TabMoveSpriteUpDo,x     ; 
                        jmp .Get_96c8               ; 
                        
.ChkUpDo_01             cmp #$01                    ; 
                        bne .ChkUpDo_02             ; 
                        
                        jmp .Get_96c8               ; 
                        
.ChkUpDo_02             cmp #$02                    ; 
                        bne .ChkUpDo_03             ; 
                        
                        lda #$7f                    ; 
                        and TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo,x     ; 
                        
.ChkUpDo_96c8_1         lda TabWaitFlags_Block04,x  ; 
                        bne .Get_96c8               ; 
                        
                        lda TabMoveSpriteUpDo,x     ; 
                        and #$7f                    ; 
                        cmp TabMoveSpriteUpDoTime,x ; 
                        bcs .Get_96c8               ; greater/equal
                        
                        inc TabMoveSpriteUpDo,x     ; 
                        jmp .Get_96c8               ; 
                        
.ChkUpDo_03             cmp #$03                    ; 
                        bne .ChkUpDo_04             ; 
                        
                        lda #$7f                    ; .#######
                        and TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo,x     ; 
                        
.ChkUpDo_96c8_2         lda TabWaitFlags_Block04,x  ; 
                        bne .Get_96c8               ; 
                        
                        lda TabMoveSpriteUpDo,x     ; 
                        and #$7f                    ; .#######
                        cmp #$00                    ; 
                        beq .Get_96c8               ; equal
                        bcc .Get_96c8               ; lower
                        
                        dec TabMoveSpriteUpDo,x     ; 
                        jmp .Get_96c8               ; 
                        
.ChkUpDo_04             cmp #$04                    ; 
                        bne .ChkUpDo_05             ; 
                        
                        lda #TabMoveSprite_Do       ; #....... - flag: move down
                        ora TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo,x     ; 
                        jmp .ChkUpDo_96c8_1         ; 
                        
.ChkUpDo_05             cmp #$05                    ; 
                        bne .Get_9668               ; 
                        
                        lda #TabMoveSprite_Do       ; #....... - flag: move down
                        ora TabMoveSpriteUpDo,x     ; 
                        sta TabMoveSpriteUpDo,x     ; 
                        jmp .ChkUpDo_96c8_2         ; 
                        
.Get_96c8               lda TabWaitFlags_Block04,x  ; 
                        bne .Get_9668               ; 
                        
                        lda #$01                    ; 
                        sta TabWaitFlags_Block04,x  ; 
                        
.Get_9668               lda TabPlaneFlies,x         ; 
                        bne .SetNextSprite          ; TabPlaneFliesYes
                        
                        lda #TabPlaneSpeedApprNone  ; 
                        sta TabPlaneSpeedAppr,x     ; 
                        
.SetNextSprite          dex                         ; 
                        cpx #$04                    ; 
                        beq SeaPlaneFlyToPlayerX    ; 
                        
                        jmp .GetNextSpriteDirReLi   ; 
                        
SeaPlaneFlyToPlayerX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneStartNext     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneStartNext       subroutine                  ; 
                        ldx TabPlaneFreeSprite      ; 
                        lda TabSpriteStepCount,x    ; 
                        cmp #$05                    ; wait time between starts
                        bcs .StartPlanes            ; greater/equal
;                        bcs .ChkStartPlanes         ; greater/equal
                        
.Exit                   rts                         ; 
                        
;.ChkStartPlanes         lda TabPlanes2Start         ; .hbu018.
;                        beq .Exit                   ; .hbu018.
;                        
;                        dec TabPlanes2Start         ; .hbu018.
;                        
.StartPlanes            txa                         ; 
                        tay                         ; yr=xr
                        ldx #$05                    ; 
.FindFreeSprite         lda TabSpriteStatus,x       ; 
                        cmp #TabSpriteStatusExpl    ; 
                        beq .FoundFreeSprite        ; 
                        
.SetNextSprite          inx                         ; 
                        cpx #$08                    ; 
                        bne .FindFreeSprite         ; 
                        
                        rts                         ; 
                        
.FoundFreeSprite        stx TabPlaneFreeSprite      ; 
                        
                        lda TabPlaneTranspWait      ; 
                        beq .ChkTransport           ; 
                        
                        dec TabPlaneTranspWait      ; 
                        jmp .IniPlane               ; 
                        
.ChkTransport           cpx #$05                    ; 
                        bne .IniPlane               ; 
                        
.IniTransp              lda #$06                    ; 
                        sta TabPlaneTranspWait      ; 
                        sty TabPlaneFreeSprite      ; 
                        
                        lda #$00                    ; 
                        sta TabSpriteStepCount,x    ; 
                        jsr SeaPlaneInitTransp      ; 
                        
                        rts                         ; 
                        
.IniPlane               lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus,x       ; 
                        
SeaPlaneStartNextX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneInitTransp    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneInitTransp      subroutine                  ; 
                        lda #TabPlaneTranspStatusUsed ; 
                        sta TabPlaneTranspStatus    ; 
                        
.ChooseHight            jsr GetRND_4a_93            ; 
                        sec                         ; .hbu002. 
                        sbc #$20                    ; .hbu002. - adjustment hight - $93 far too deep
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        
.ChooseDir              lsr a                       ; 
                        bcs .FlyFromLeftToRight     ; 
                        
.FlyFromRightToLeft     lda #$20                    ; ..#..... - set MSB_5
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$58                    ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #SP_Ptr_SeaPlane_4b     ; transporter fly left
                        sta BH_SpritePointer05_A    ; 
                        
                        lda #$28                    ; 
                        ora #TabMoveSprite_Le       ; #....... - flag: move left
                        
.Finish                 sta TabMoveTranspLeRi       ; 
                        
                        lda #$ff                    ; 
                        sta TabPlaneDirReLi + $05   ; 
                        
                        lda #TabSpriteActiveYes     ; 
                        sta TabTranspActive         ; 
                        
                        lda #BH_SprtColorTransp     ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        
                        ldx #$05                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$02                    ; 
                        sta TabSpriteStatus_05      ; 
                        
.Exit                   rts                         ; 
                        
.FlyFromLeftToRight     lda #$df                    ; ##.#####
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$00                    ; 
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #SP_Ptr_SeaPlane_4c     ; transporter fly right
                        sta BH_SpritePointer05_A    ; 
                        
                        lda #TabMoveSprite_Ri + $28 ; #....... - flag: move right
SeaPlaneInitTranspX     jmp .Finish                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneTranspChkMax  Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneTranspChkMax    subroutine                  ; 
                        lda TabPlaneTranspStatus    ; 
                        bne .ChkDirTransport        ; TabPlaneTranspStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkDirTransport        lda TabMoveTranspLeRi       ; 
                        bmi .ChkMinPosX             ; TabMoveSprite_Le
                        
.ChkMaxPosX             lda #$20                    ; ..#.....
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .Exit                   ; 
                        
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$58                    ; 
                        bcc .Exit                   ; lower
                        
.DisableTransp          lda #TabSpriteActiveNo      ; 
                        sta TabTranspActive         ; 
                        
                        ldx #$05                    ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
                        lda #TabSpriteStatusExpl    ; 
                        sta TabSpriteStatus_05      ; 
                        
                        lda #TabPlaneTranspStatusFree ; 
                        sta TabPlaneTranspStatus    ; 
                        
                        rts                         ; 
                        
.ChkMinPosX             lda #$20                    ; ......#.
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .Exit                   ; 
                        
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$04                    ; 
                        bcc .DisableTransp          ; 
                        
SeaPlaneTranspChkMaxX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneTranspChkHit  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneTranspChkHit    subroutine                  ; 
                        lda TabPlaneTranspStatus    ; 
                        bne .ChkCollision           ; TabPlaneTranspStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkCollision           lda #$20                    ; ..#.....
                        bit TabSprtSprtCollReg      ; 
                        bne .ChkCollisionShotIni    ; 
                        
                        rts                         ; 
                        
.ChkCollisionShotIni    ldx #$02                    ; 
.ChkCollisionShot       jsr SetAcToXrTimesMult2     ; 
                        bit TabSprtSprtCollReg      ; ......#. and .......#
                        bne .ChkWaitTime            ; 
                        
.SetNextShot            dex                         ; 
                        bne .ChkCollisionShot       ; 
                        
                        rts                         ; 
                        
.ChkWaitTime            lda TabSpriteStepCount,x    ; 
                        cmp #$10                    ; 
                        bcc .SetNextShot            ; 
                        
                        jsr SpritesGetVicOffFromXr  ; 
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        bcs .ChkDirektHit           ; greater/equal
                        
                        eor #$ff                    ; make positve
                        adc #$01                    ; 
                        
.ChkDirektHit           cmp #$0a                    ; 
                        bcs .SetNextShot            ; greater/equal
                        
.Explode                jsr SpritesDisableNoFromXr  ; 
                        
                        lda #$00                    ; 
                        sta TabTranspActive         ; TabSpriteActiveNo
                        sta TabSpriteStatus,x       ; TabSpriteStatusFree
                        sta TabPlaneTranspStatus    ; .hbu006. - score only once - TabPlaneTranspStatusFree
                        
                        lda #$20                    ; ..#.....
                        ora SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #BH_SprtColorTranspExpl_MC0 ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        
                        lda #BH_SprtColorTranspExpl_MC1 ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        
                        lda #BH_SprtColorTranspExplode ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        
                        lda #SP_Ptr_SeaPlane_48     ; explode transporter
                        sta BH_SpritePointer05_A    ; 
                        
                        lda #$14                    ; 
                        sta TabWaitTimeBells        ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagPing         ; 
                        
                        lda #TabPlaneTranspWasHitYes; 
                        sta TabPlaneTranspWasHit    ; 
                        
                        jsr InitVoc1                ; 
                        jsr AddScore_2000           ; 
SeaPlaneTranspChkHitX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneTranspChkExpl Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneTranspChkExpl   subroutine                  ; 
                        lda TabPlaneTranspWasHit    ; 
                        bne .ChkWaitTime            ; TabPlaneTranspWasHitYes
                        
.Exit                   rts                         ; 
                        
.ChkWaitTime            lda TabWaitFlagPing         ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        ldx #$05                    ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
                        lda #$df                    ; ##.#####
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #BH_SprtColorTranspExpl_Off ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        
                        lda #TabPlaneTranspWasHitNo ; 
                        sta TabPlaneTranspWasHit    ; 
                        
                        lda #TabSpriteStatusExpl    ; 
                        sta TabSpriteStatus_05      ; 
                        
SeaPlaneTranspChkExplX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneSoundTurn     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneSoundTurn       subroutine                  ; 
                        lda #$04                    ; .....#..
                        bit TabSfxToPlay            ; 
                        bne .ChkSfxActive           ; 
                        
.Exit                   rts                         ; 
                        
.ChkSfxActive           lda TabWaitFlagSfx          ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagSfx          ; TabWaitFlag_Yes
                        
                        lda TabVoc1FreqLo           ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        sta TabVoc1FreqLo           ; 
                        bcs .ChkFreq                ; greater/equal
                        
                        dec TabVoc3FreqHi           ; 
                        
.ChkFreq                lda TabVoc3FreqHi           ; 
                        cmp #$04                    ; 
                        bcs .SfxMod                 ; greater/equal
                        
.SfxOff                 lda #$fb                    ; #####.##
                        and TabSfxToPlay            ; 
                        sta TabSfxToPlay            ; 
                        
                        rts                         ; 
                        
.SfxMod                 sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        sec                         ; 
                        sbc #$04                    ; 
                        
                        clc                         ; 
                        ror a                       ; 
                        
                        lda TabVoc1FreqLo           ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        
                        ror a                       ; 
                        sta PWLO1                   ; SID($D402) Oscillator 1 Pulse Waveform Width (low byte)
                        
SeaPlaneSoundTurnX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneSoundShoot    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneSoundShoot      subroutine                  ; 
                        lda #$08                    ; ....#...
                        bit TabSfxToPlay            ; 
                        bne .ChkActive              ; 
                        
.Exit                   rts                         ; 
                        
.ChkActive              lda TabWaitFlagSfxShot      ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagSfxShot      ; TabWaitFlag_Yes
                        
                        lda TabWaitFlagSfxShotPlane ; 
                        beq .SfxOff                 ; TabWaitFlag_No
                        
.Shoot                  jsr ResetVoc3               ; 
                        
                        lda #$20                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$09                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        
                        rts                         ; 
                        
.SfxOff                 lda #$f7                    ; ####.###
                        and TabSfxToPlay            ; 
                        ora #$01                    ; 
                        sta TabSfxToPlay            ; 
                        
                        jsr InitVoc3                ; 
SeaPlaneSoundShootX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipReduceCount    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipReduceCount      subroutine                  ; 
                        lda TabPlayerLives          ; 
                        cmp #$05                    ; max possible for tank chapter
                        bcs .Reduce                 ; greater/equal
                        
                        rts                         ; 
                        
.Reduce                 dec TabPlayerLives          ; 
                        jsr ScreenStatusShowShips   ; 
                        
                        lda #$14                    ; 
                        sta TabTempStore            ; 
                        
.GoResetTOD1            jsr ResetTOD1               ; 
                        
.GetTOD1_10th           lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp #$01                    ; 
                        bcc .GetTOD1_10th           ; lower
                        
                        jsr AddScore_100            ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr ResetVoc1               ; 
                        jsr ResetVoc2               ; 
                        jsr ResetVoc3               ; 
                        
                        lda #$ff                    ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        lda #$3a                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$07                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        dec TabTempStore            ; 
                        
                        lda TabTempStore            ; 
                        bne .GoResetTOD1            ; 
                        
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
SeaShipReduceCountX     jmp SeaShipReduceCount      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneChkHit        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneChkHit          subroutine                  ; 
                        ldx #$05                    ; 
.ChkHitTarget           lda TabTargetHit            ; 
                        beq .GetPlaneDistance       ; TabTargetHitNo
                        
                        rts                         ; 
                        
.GetPlaneDistance       lda TabPlaneDistance,x      ; 
.ChkPlaneDistanceMin    cmp #$04                    ; 
                        bcs .ChkPlaneDistanceMax    ; greater/equal
                        
.SetNextPlaneHi         inx                         ; lower
                        cpx #$08                    ; 
                        bne .ChkHitTarget           ; 
                        
                        rts                         ; 
                        
.ChkPlaneDistanceMax    cmp #$06                    ; 
                        bcs .SetNextPlaneHi         ; greater/equal
                        
                        jsr SetAcToXrTimesMult2     ; lower
                        bit TabSprtSprtCollReg      ; 
                        bne .PlaneHit               ; 
                        
                        lda #$10                    ; ...#....
                        bit TabSprtSprtCollReg      ; 
                        bne .PlaneHit               ; 
                        
.Exit                   rts                         ; 
                        
.PlaneHit               stx TabPlaneNoToExplode     ; save plane sprite number
                        
                        ldx #$01                    ; 
.GetNextPlaneLo         jsr SetAcToXrTimesMult2     ; 
                        bit TabSprtSprtCollReg      ; 
                        bne .ChkStep                ; 
                        
.SetNextPlaneLo         inx                         ; 
                        cpx #$03                    ; 
                        bne .GetNextPlaneLo         ; 
                        
                        rts                         ; 
                        
.ChkStep                lda TabSpriteStepCount,x    ; 
                        cmp #$12                    ; 
                        bcc .SetNextPlaneLo         ; lower
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        bcs .ChkCenter              ; 
                        
                        eor #$ff                    ; make positve
                        clc                         ; 
                        adc #$01                    ; 
                        
.ChkCenter              cmp #$08                    ; 
                        bcs .SetNextPlaneLo         ; 
                        
                        lda #$00                    ; 
                        sta TabSpriteStatus,x       ; TabSpriteStatusFree
                        sta TabPlayerShoots         ; TabPlayerShootsNo
                        jsr SpritesDisableNoFromXr  ; 
                        jsr PlaneExplode            ; 
                        
.Score                  jsr AddScore_400            ; 
                        
SeaPlaneChkHitX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; PlaneExplode          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
PlaneExplode            subroutine                  ; 
                        ldx TabPlaneNoToExplode     ; 
                        
                        lda #$00                    ; 
                        sta TabSpriteActive,x       ; TabSpriteActiveNo
                        sta TabPlaneDirReLi,x       ; TabPlaneDirReLiStop
                        sta TabPlaneDirUpDo,x       ; 
                        sta TabPlaneDirReLi_04      ; 
                        sta TabPlaneDirUpDo_04      ; 
                        sta TabSpriteActive_04      ; 
                        
                        lda #TabPlaneDist_Explode   ; 
                        sta TabPlaneDistance,x      ; 
                        sta TabPlaneDistance + $04  ; 
                        
                        jsr SetAcToXrTimesMult2     ; 
                        ora #$10                    ; ...#....
                        ora SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #BH_SprtColorPlaneExpl_MC0 ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        
                        lda #BH_SprtColorPlaneExpl_MC1 ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        
                        lda #BH_SprtColorPlaneExplode ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
                        lda #SP_Ptr_SeaPlane_49     ; explode plane left
                        sta BH_SpritePointers_A,x   ; 
                        
                        lda #SP_Ptr_SeaPlane_4a     ; explode plane right
                        sta BH_SpritePointer04_A    ; 
                        
                        lda #$10                    ; 
                        sta TabPlaySfxVoc1_03       ; 
                        
                        lda #$01                    ; 
                        sta TabWaitFlagExplode      ; TabWaitFlag_Yes
                        sta TabTargetHit            ; TabTargetHitYes
                        
                        jsr InitVoc1                ; 
                        
                        lda #$f7                    ; ####.###
                        and TabSfxToPlay            ; 
                        ora #$01                    ; .......#
                        sta TabSfxToPlay            ; 
                        
                        jsr InitVoc3                ; 
PlaneExplodeX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneExplodeOff    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneExplodeOff      subroutine                  ; 
                        lda TabTargetHit            ; 
                        bne .ChkExplode             ; TabTargetHitYes
                        
.Exit                   rts                         ; 
                        
.ChkExplode             lda TabWaitFlagExplode      ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        ldx #$04                    ; TabWaitFlag_No
                        jsr SpritesDisableNoFromXr  ; 
                        
                        ldx TabPlaneNoToExplode     ; 
                        jsr SpritesDisableNoFromXr  ; 
                        jsr SetAcToXrTimesMult2     ; 
                        
                        ora #$10                    ; ...#....
                        eor #$ff                    ; ########
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$00                    ; 
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta TabTargetHit            ; TabTargetHitNo
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
                        lda #$ff                    ; 
                        sta TabSpriteStatus,x       ; TabSpriteStatusExpl
                        sta TabSpriteStatus_04      ; 
                        
SeaPlaneExplodeOffX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneShootInit     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneShootInit       subroutine                  ; 
                        lda TabBulletActive         ; 
                        beq .ChkSprtPtr04           ; TabBulletActiveNo
                        
.Exit                   rts                         ; 
                        
.ChkSprtPtr04           lda BH_SpritePointer04_A    ; 
                        cmp #SP_Ptr_SeaPlane_10     ; plane double sprite phase 5 right - last before turn away
                        bne .Exit                   ; 
                        
                        cmp #SP_Ptr_SeaPlane_11     ; plane turn away mid phase 1 left
                        bcs .Exit                   ; greater/equal
                        
                        lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .ChkBit4                ; 
                        
.ClrPosXMSB_03          lda #$f7                    ; ####.###
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .IncSprt4PosY           ; 
                        
.ChkBit4                lda #$10                    ; ...#....
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .ClrPosXMSB_03          ; 
                        
.SetPosXMSB_03          lda #$08                    ; ....#...
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.IncSprt4PosY           lda SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        clc                         ; 
                        adc #$0b                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #TabSpriteStatusUsed    ; 
                        sta TabSpriteStatus_03      ; 
                        
                        ldx #$03                    ; ......##
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$01                    ; 
                        sta TabWaitFlagBulletFly    ; TabWaitFlag_Yes
                        sta TabWaitBulletFlySav     ; 
                        sta TabWaitBulletFly        ; 
                        sta TabBulletActive         ; TabBulletActiveYes
                        
                        lda #SP_Ptr_SeaPlane_2b     ; bullet phase  7
                        sta BH_SpritePointer03_A    ; 
                        
                        lda #$00                    ; 
                        sta TabBulletStepCount      ; 
                        
                        lda #BH_SprtColorPlaneBullet; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        
SeaPlaneShootInitX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneShoot         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneShoot           subroutine                  ; 
                        lda TabBulletActive         ; 
                        cmp #TabBulletActiveYes     ; 
                        beq .FlyBullet              ; 
                        
.Exit                   rts                         ; 
                        
.FlyBullet              lda TabWaitFlagBulletFly    ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagBulletFly    ; TabWaitFlag_Yes
                        
.ChkBulletPosX          lda SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        cmp #$b4                    ; 
                        bcs .Hit                    ; greater/equal
                        
                        clc                         ; 
                        adc #$04                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        inc TabBulletStepCount      ; 
                        lda TabBulletStepCount      ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        eor #$ff                    ; 
                        sec                         ; 
                        adc #$6b                    ; 
                        cmp #SP_Ptr_SeaPlane_24     ; bullet phase  1 - max
                        bcc .Exit_2                 ; lower
                        
                        sta BH_SpritePointer03_A    ; 
                        
.Exit_2                 rts                         ; 
                        
.Hit                    dec TabBulletActive         ; TabBulletActiveNo
                        
                        lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus_03      ; 
                        
.DisapleBullet          ldx #$03                    ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
                        inc TabBulletDamage         ; 
                        jsr SubScores               ; .hbu020. - subtract 100 for each hit
SeaPlaneShootX          rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneDamageOut     Does    : Count damage and check for max
;                               : Switch players & restart / Check for game over
;                               : Exit to BASIC then
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneDamageOut       subroutine                  ; 
                        lda TabSeaShipMsgDestroy    ; 
                        beq .GetDamageCount         ; TabSeaShipMsgDestroyNo
                        
                        rts                         ; 
                        
.GetDamageCount         lda TabBulletDamage         ; 
                        jsr MakeDecimal             ; xr=100 yr=10_1
                        
                        tya                         ; 
                        jsr MakeDigit               ; xr=left nibble yr=right nibble
                        sty BH_Scrn_Stat + BH_Scrn_Stat_Row_01 + BH_Scrn_Stat_RiVal + $01 ; 
                        stx BH_Scrn_Stat + BH_Scrn_Stat_Row_01 + BH_Scrn_Stat_RiVal + $00 ; 
                        
                        lda TabBulletDamage         ; 
__SeaPlaneSkillDmge     equ * + $01                 ; skill level adaptations
.ChkSkill               cmp #$14                    ; 
                        beq .Destroyed              ; maximum reached
                        
                        rts                         ; 
                        
.Destroyed              jsr ResetTOD1               ; 
                        
                        lda #TabSeaShipMsgDestroyYes; 
                        sta TabSeaShipMsgDestroy    ; 
                        
                        dec TabPlayerLives          ; 
.ChkGameOver            lda TabPlayerLives          ; 
                        bne .InitDamageCount        ; 
                        
                        jsr ScreenStatusGameOver    ; 
                        
                        lda #TabShowScoresNo        ; 
                        sta TabPlayerShowScores     ; 
                        
                        ldx TabPlayerActive         ; 
                        sta TabPlayerShowScore,x    ; 
                        jsr SwitchPlayerAndValues   ; 
                        beq .ContWithPlayer_01      ; player #1
                        
.ContWithPlayer_02      dec TabPlayerInGame         ; player #2
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp Chapter_PlaneShootOut   ; restart chapter
                        
.ContWithPlayer_01      dec TabPlayerInGame         ; 
                        beq .AllPlayerGone          ; Game over - 3 level return
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
.GoShipShootOut         jmp Chapter_ShipShootOut    ; --> SeaLevels - Start next chapter
                        
.AllPlayerGone          jmp GameOver_Rts_Two        ; Game over - back to BASIC via GameStart
                        
.InitDamageCount        lda #$00                    ; 
                        sta TabBulletDamage         ; 
                        
SeaPlaneDamageOutX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaPlaneDemo          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaPlaneDemo            subroutine                  ; 
                        lda TabGameMode             ; 
                        bne .ChkDemoTime            ; TabGameModeDemo or TabGameModeExit
                        
                        rts                         ; 
                        
.ChkDemoTime            lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #BH_DemoTimeSeaPlane    ; 
                        bcc .IniPlaneDistance       ; 
                        
.DemoFinished           jsr ResetTOD2               ; 
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
.GoShipShootOut         jmp Chapter_ShipShootOut    ; --> SeaLevels - Start next chapter
                        
.IniPlaneDistance       ldx #$05                    ; 
.ChkPlaneDistance       lda TabPlaneDistance,x      ; 
                        cmp #$04                    ; near enough
                        bcs .GetSpriteOff           ; yes - greater/equal
                        
                        inx                         ; 
                        cpx #$08                    ; 
                        bne .ChkPlaneDistance       ; 
                        
.Exit                   rts                         ; no planes in the near
                        
.GetSpriteOff           jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        
                        lda TabCannonShotDegree     ; 
                        cmp SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        beq .ChkPosX_MSB            ; equal
                        bcc .GetJoyUp               ; lower
                        
.GetJoyDo               lda #CIA_Joy_Do             ; greater
                        sta TabJoysticAction        ; 
                        
                        jmp .ChkPosX_MSB            ; 
                        
.GetJoyUp               lda #CIA_Joy_Up             ; 
                        sta TabJoysticAction        ; 
                        
.ChkPosX_MSB            lda #$10                    ; ...#....
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .SetPosX_MSB            ; 
                        
                        lda #$01                    ; .......#
                        
.SetPosX_MSB            sta TabDemoPlanePosX_MSB    ; 
                        
                        lda #$01                    ; .......#
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta TabDemoPlaneMyPosX_MSB  ; 
                        
                        lda SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabDemoPlanePosX        ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta TabDemoPlaneMyPosX      ; 
                        
                        ldy #$03                    ; 
.ChkPlanePosX           dey                         ; 
                        beq .GetJoyFi               ; 
                        
                        lda [TabDemoPlanePosX   - $01],y ; 
                        cmp [TabDemoPlaneMyPosX - $01],y ; 
                        beq .ChkPlanePosX           ; equal
                        bcs .GetJoyRi               ; greater
                        
.GetJoyLe               lda #CIA_Joy_Le             ; lower
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
                        jmp .GetJoyFi               ; 
                        
.GetJoyRi               lda #CIA_Joy_Ri             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
.GetJoyFi               lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
SeaPlaneDemoX           rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter_ShipShootOut  Does    : Chapter: Ship shootout
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_ShipShootOut    subroutine                  ; 
                        jsr ScreenStatusGetReady    ; .hbu013.
                        jsr ShipShootOutInit        ; 
                        
.ShipShootOut_Loop      jsr SeaShipEnemyBulletInit  ; 
                        jsr SeaShipEnemyGetCollSpBg ; 
                        jsr SeaShipEnemyBullet      ; 
                        jsr CannonPlayerMove        ; 
                        jsr CannonPlayerShootInit   ; 
                        
                        lda #$01                    ; 
                        sta TabPlayerShootSpriteNo  ; 
                        
                        jsr CannonPlayerBullet      ; 
                        jsr PlayerAmmoInc           ; 
                        
.ChkEndOfChapter        lda TabSeaVesselHit         ; 
                        eor #$ff                    ; ########
                        ora TabPlayerVesselActive   ; one bit per ship
                        ora TabBulletActive         ; 
                        ora TabSeaShipMsgDestroy    ; 
                        ora TabSpriteStatus_01      ; 
                        bne .ShipShootOut_Cont      ; continue loop
                        
.ReadyNextChapter       jsr SpritesReset            ; 
                        jsr SeaShipReduceCount      ; 
                        jsr SwitchPlayerAndValues   ; 
                        beq .GoInitBayArea          ; player #1 - prepare next chapter
                        
.GoShipShootOut         jmp Chapter_ShipShootOut    ; player #2 - restart chapter
                        
.GoInitBayArea          jmp MapInitBayAreaToBeach   ; --> BayLevels - Lead to next chapter
                        
.ShipShootOut_Cont      jsr SeaShipCarrierMove      ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr ScreenStatusShowDegree  ; 
                        jsr SeaShipEneBulletSfxIni  ; 
                        jsr SeaShipEneBulletSfxMod  ; 
                        jsr SeaShipStatusShipsOut   ; 
                        jsr CheckGamePause          ; on C= commodore key
                        jsr SeaShipChkDestroyMsg    ; 
                        jsr BulletWaterSplashOff    ; 
                        jsr CheckGameFinished       ; Quit/Idle time/Death - 2 level return to BASIC via GameStart
                        jsr SeaShipSinkAndScore     ; 
                        jsr SeaShipEneExplodeOff    ; 
                        jsr CheckGameIdleTime       ; 
                        jsr SeaShipDemo             ; 
                        
Chapter_ShipShootOutX   jmp .ShipShootOut_Loop      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShipShootOutInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShipShootOutInit        subroutine                  ; 
                        ldx #BH_ChapterShipShootOut ; .hbu013.
                        jsr LoadChapterData         ; .hbu013.
                        
                        lda #$00                    ; 
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
.IniEneFleetDistances   ldx #$01                    ; .hbu021.
.GetOffset              jsr SeaShipVesselDistOff    ; .hbu021. - get an offset from $00-$0f
                        clc                         ; .hbu021. 
                        adc TabVesselBaseDist,x     ; .hbu021. - add to base distance
                        sta TabVesselVaryDist,x     ; .hbu021. - store vessel distance
                        
                        lda TabSeaVesselArmor,x     ; .hbu025.
                        sta TabSeaVesselHits,x      ; .hbu025.

                        inx                         ; .hbu021.
                        cpx #BH_VesselCount + $02   ; .hbu021. - include carrier
                        bne .GetOffset              ; .hbu021.
                        
                        jsr SeaShipShootInit        ; 
                        jsr CannonSpritePosInit     ; 
                        
                        jsr SeaShipGetRndVesselNo   ; .hbu023.
                        stx TabSeaVesselShoots      ; .hbu023.
                        
                        jsr SeaShipCarrierInit      ; 
                        
ShipShootOutInitX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipGetRndVesselNo Does    : Return a random vessel no
;                       Expects : 
;                       Returns : xr=vessel number
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipGetRndVesselNo   subroutine                  ; .hbu023.
                        jsr GetRND                  ; 
                        and #$03                    ; $00-$03
                        tax                         ; 
                        inx                         ; $01-$04 real vessel number
                        ldy #$04                    ; max 4 tries
.ChkNextVessel          lda TabSeaVesselActive,x    ; 
                        bne SeaShipGetRndVesselNoX  ; found an active vessel
                        
                        inx                         ; 
                        cpx #BH_VesselCount + $01   ; inc past max num of vessels
                        bne .ChkNextVessel          ; 
                        
                        ldx #$01                    ; restart at 1st vessel
                        dey                         ; dec noumber of rounds
                        bne .ChkNextVessel          ; 
                        
                        ldx #TabSeaVesselShootsNone ; 
                        
SeaShipGetRndVesselNoX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipShootInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipShootInit        subroutine                  ; 
                        jsr TabSpritesWaitsInits    ;  
                        
                        lda #TabBulletEnemyDistIni  ; was $9c - not full minimum
                        sta TabBulletEnemyDist      ; 
                        
                        lda #SP_Ptr_SeaShip_01      ; cannon shot phase  1 - max
                        sta TabPlrShootSprtBasePtr1 ; 
                        
                        lda #TabPlayerShootsNo      ; 
                        sta TabPlayerShoots         ; 
                        
                        lda #SP_Ptr_SeaShip_0d      ; cannon down  1 - max up
                        sta TabPlrShootSprtBasePtr2 ; 
                        
                        lda #$00                    ; 
                        sta TabBulletActive         ; TabBulletActiveNo
                        sta TabJoysticAction        ; 
.Clear                  jsr SpritesAcToTabActive    ; 
                        
                        lda #TabTargetHitNo         ; 
                        sta TabTargetHit            ; 
                        
                        lda #TabSeaVesselHitNone    ; 
                        sta TabSeaVesselHit         ; hit water
                        
                        lda #$10                    ; 
                        sta TabWaitBulletFlySav     ; 
                        sta TabWaitBulletFly        ; 
                        jsr SpritesReset            ; 
                        
                        lda #$20                    ; ..#.....
                        bit TabPlayerVesselActive   ; one bit per ship
                        beq .GetZero                ; 
                        
.GetOne                 lda #TabFlagCarrierActiveYes; 
                        jmp .SetValue               ; 
                        
.GetZero                lda #TabFlagCarrierActiveNo ; 
                        
.SetValue               sta TabFlagCarrierActive    ; 
                        
                        lda #$0a                    ; 
                        sta TabPlayerAmmo           ; 
                        
                        lda #$0c                    ; 
                        sta TabVoc2AttDec           ; 
                        lda #$08                    ; 
                        sta TabVoc2FreqHi           ; 
                        lda #$f3                    ; 
                        sta RESON                   ; SID($D417) Filter Resonance Ctrl
                        
SeaShipShootInitX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipEnemyBulletInit Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipEnemyBulletInit  subroutine                  ; 
                        lda TabSeaShipMsgDestroy    ; .hbu024. - wait for destroy flicker to end
                        bne .Exit                   ; .hbu024. - TabSeaShipMsgDestroyYes
                        
                        lda TabBulletActive         ; 
                        beq .ChkWait                ; TabBulletActiveNo
                        
.Exit                   rts                         ; 
                        
.ChkWait                lda TabWaitFlagBulletFly    ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        lda #$fb                    ; #####.##
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda TabSeaVesselShoots      ; 
.ChkVessel_01           cmp #$01                    ; shot vessel 1
                        bne .ChkVessel_02           ; .hbu014.
                        
                        if [BH_Vessel1SprtPosX - $05] > $ff ; .hbu014.
                        lda #$04                    ; .hbu014. - .....#..
                        ora MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        endif                       ; .hbu014.
                        
                        lda #<[BH_Vessel1SprtPosX - $05] ; .hbu014. - position to mid of ship
                        jmp .SetNewPosX             ; .hbu014.
                        
.ChkVessel_02           cmp #$02                    ; shot vessel 2
                        bne .ChkVessel_03           ; .hbu014.
                        
                        if [BH_Vessel2SprtPosX - $03] > $ff ; .hbu014.
                        lda #$04                    ; .hbu014. - .....#..
                        ora MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        endif                       ; .hbu014.
                        
                        lda #<[BH_Vessel2SprtPosX - $03] ; .hbu014. - position to mid of ship
                        jmp .SetNewPosX             ; .hbu014.
                        
.ChkVessel_03           cmp #$03                    ; shot vessel 3
                        bne .ChkVessel_04           ; always
                        
                        if [BH_Vessel3SprtPosX - $09] > $ff ; .hbu014.
                        lda #$04                    ; .hbu014. - .....#..
                        ora MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        endif                       ; .hbu014.
                        
                        lda #<[BH_Vessel3SprtPosX - $09] ; .hbu014. - position to mid of ship
                        jmp .SetNewPosX             ; .hbu014.
                        
.ChkVessel_04           cmp #$04                    ; shot vessel 4
                        bne .Exit                   ; 
                        
                        if [BH_Vessel4SprtPosX + $08 - $06] > $ff ; .hbu014.
                        lda #$04                    ; .hbu014. - .....#..
                        ora MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; .hbu014. - VIC($D010) MSB X-Pos Sprites 0-7
                        endif                       ; .hbu014.
                        
                        lda #<[BH_Vessel4SprtPosX + $08 - $06] ; .hbu014. - position to mid of ship
                        
.SetNewPosX             sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$01                    ; 
                        sta TabPlaneDistance        ; 
                        sta TabBulletActive         ; TabBulletActiveYes
                        sta TabSpriteStatus_03      ; TabSpriteStatusUsed
                        
                        lda #$8c                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
                        lda #$10                    ; ...#....
                        bit TabSfxToPlay            ; 
                        bne .SetSpritePtr           ; 
                        
                        jsr ResetVoc1               ; 
                        
                        lda #$9e                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0c                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
.SetSpritePtr           lda #SP_Ptr_SeaShip_1d      ; enemy bullet phase 1 - min
                        sta BH_SpritePointer02_A    ; 
                        
                        lda #BH_SprtColorShipBulletE; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        
                        ldx #$02                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
SeaShipEnemyBulletInitX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipEnemyBullet    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipEnemyBullet      subroutine                  ; 
                        lda TabBulletActive         ; 
                        cmp #TabBulletActiveYes     ; 
                        beq .ChkDistances           ; 
                        
                        rts                         ; 
                        
.ChkDistances           lda TabPlaneDistance        ; 
                        cmp #$01                    ; 
                        beq .Dist_01                ; 
                        
                        cmp #$02                    ; 
                        beq .Dist_02                ; 
                        
                        cmp #$03                    ; 
                        beq .Dist_03                ; 
                        
                        cmp #$04                    ; 
                        bne .Exit                   ; 
                        
                        jmp .Dist_04                ; 
                        
.Exit                   rts                         ; 
                        
.Dist_01                lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        cmp #$18                    ; 
                        bcc .GetDistance_02         ; lower
                        
                        lda TabWaitFlagPlaneFly     ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagPlaneFly     ; TabWaitFlag_Yes
                        
                        lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$02                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
.Dist_01X               rts                         ; 
                        
.Dist_03                lda BH_SpritePointer02_A    ; 
                        cmp #SP_Ptr_SeaShip_2b      ; enemy water splash phase  5
                        beq .SetDistance            ; 
                        
                        lda TabWaitFlagPlaneFly     ; 
                        bne .Dist_03X               ; TabWaitFlag_Yes
                        
                        lda TabWaitFlagBullFlyESav  ; 
                        asl a                       ; 
                        sta TabWaitFlagBullFlyESav  ; 
                        sta TabWaitFlagBullFlyE     ; 
                        
                        inc TabWaitFlagPlaneFly     ; TabWaitFlag_Yes
                        inc BH_SpritePointer02_A    ; 
                        
.Dist_03X               rts                         ; 
                        
.SetDistance            lda #$04                    ; 
                        sta TabPlaneDistance        ; 
                        
                        lda #$0e                    ; 
                        sta TabWaitFlagBullFlyESav  ; 
                        sta TabWaitFlagBullFlyE     ; 
                        
                        rts                         ; 
                        
.GetDistance_02         lda #$02                    ; 
                        sta TabPlaneDistance        ; 
                        
                        lda #$d0                    ; 
                        sta TabWaitFlagBullFlyE     ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagPlaneFly     ; 
                        
                        lda #SP_Ptr_SeaShip_1f      ; enemy bullet phase 3
                        sta BH_SpritePointer02_A    ; 
                        
                        rts                         ; 
                        
.Dist_02                lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        cmp TabBulletEnemyDist      ; 
                        bcs .ChkBulletHit           ; greater/equal
                        
                        lda TabWaitFlagPlaneFly     ; lower
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagPlaneFly     ; TabWaitFlag_Yes
                        
                        lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        clc                         ; 
                        adc #$08                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
.Dist_02X               rts                         ; 
                        
.ChkBulletHit           lda TabBulletEnemyDist      ; 
                        cmp #$b0                    ; 
                        bcc .BulletHitsWater        ; lower
                        
                        jmp .BulletHitsShip         ; 
                        
.BulletHitsWater        lda #$03                    ; 
                        sta TabPlaneDistance        ; 
                        
                        lda #$02                    ; 
                        sta TabWaitFlagBullFlyESav  ; 
                        
                        lda #SP_Ptr_SeaShip_27      ; enemy water splash phase  1 - start
                        sta BH_SpritePointer02_A    ; 
                        
                        lda #$04                    ; 
                        ora YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        
                        lda #WHITE                  ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        
                        lda SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$15                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
                        lda #$cf                    ; ##..####
                        and TabSfxToPlay            ; 
                        sta TabSfxToPlay            ; 
                        
                        jsr ResetVoc3               ; 
                        
                        lda #$24                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$4c                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        
.ExitBulletHitsWater    rts                         ; 
                        
.Dist_04                lda TabWaitFlagPlaneFly     ; 
                        bne .Dist_04X               ; TabWaitFlag_Yes
                        
                        lda BH_SpritePointer02_A    ; 
                        cmp #SP_Ptr_SeaShip_31      ; enemy water splash phase 11 - end
                        beq .ClrBullet              ; 
                        
                        lda TabWaitFlagBullFlyESav  ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        sta TabWaitFlagBullFlyESav  ; 
                        sta TabWaitFlagBullFlyE     ; 
                        
                        inc TabWaitFlagPlaneFly     ; TabWaitFlag_Yes
                        inc BH_SpritePointer02_A    ; 
                        
.Dist_04X               rts                         ; 
                        
.ClrBullet              lda #$00                    ; BLACK/TabPlaneDist_Ini
                        sta TabBulletActive         ; TabBulletActiveNo
                        sta TabPlaneDistance        ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        sta TabSpriteStatus_03      ; TabSpriteStatusFree
                        
                        lda #$01                    ; 
                        sta TabWaitFlagBulletFly    ; TabWaitFlag_Yes
                        sta TabWaitFlagBullFlyESav  ; 
                        sta TabWaitFlagBullFlyE     ; 
                        
                        lda #$fb                    ; #####.##
                        and YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        
                        ldx #$02                    ; ......#.
                        jsr SpritesDisableNoFromXr  ; 
                        
                        lda TabBulletEnemyDist      ; 
                        clc                         ; 
__SeaShipSkillShots     equ * + $01                 ; skill level adaptations
.SetSkill               adc #$04                    ; 
                        sta TabBulletEnemyDist      ; 
                        
.ChkMax                 lda #TabBulletEnemyDistMax  ; 
                        cmp TabBulletEnemyDist      ; 
                        bcs .ExitBulletClr          ; greater/equal
                        
                        sta TabBulletEnemyDist      ; set max
                        
.ExitBulletClr          rts                         ; 
                        
.BulletHitsShip         jsr ResetVoc1               ; 
                        
                        lda #$df                    ; ##.#####
                        and TabSfxToPlay            ; 
                        ora #$10                    ; ...#....
                        sta TabSfxToPlay            ; 
                        
                        lda #$06                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0d                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        jsr ResetVoc3               ; 
                        
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        dec TabPlayerLives          ; 
                        lda TabPlayerLives          ; 
                        bne .Destroyed              ; 
                        
                        jsr ScreenStatusGameOver    ; 
                        
                        lda #TabShowScoresNo        ; 
                        sta TabPlayerShowScores     ; 
                        
                        ldx TabPlayerActive         ; 
                        sta TabPlayerShowScore,x    ; 
                        
                        jsr SwitchPlayerAndValues   ; 
                        beq .DecPlayers             ; player #1
                        
                        dec TabPlayerInGame         ; player #2
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp Chapter_ShipShootOut    ; restart chapter
                        
.DecPlayers             dec TabPlayerInGame         ; 
                        beq .AllPlayersOut          ; 
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp MapInitBayAreaToBeach   ; --> BayLevels - Start next chapter
                        
.AllPlayersOut          jmp GameOver_Rts_Two        ; Game over - back to BASIC via GameStart
                        
.Destroyed              jsr ResetTOD1               ; 
                        
                        lda #TabSeaShipMsgDestroyYes; 
                        sta TabSeaShipMsgDestroy    ; 
                        
;                        lda #TabBulletEnemyDistIni  ; .hbu024.
;                        sta TabBulletEnemyDist      ; .hbu024.
                        
;                        jsr SeaShipGetRndVesselNo   ; .hbu024. - activate next vessel
;                        stx TabSeaVesselShoots      ; .hbu024.
                        
SeaShipEnemyBulletX     jmp .ClrBullet              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselDistOff  Does: Get a distance offset value for vessels and carrier
;                       Expects : 
;                       Returns : ac=offset vessel distance
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselDistOff    subroutine                  ; .hbu021.
                        jsr GetRND                  ; 
.ChkVariation           cmp #$10                    ; vary distance offset between $00-$0f
                        bcc SeaShipVesselDistOffX   ; 
                        
                        sbc #$10                    ; greater/equal
                        jmp .ChkVariation           ; 
                        
SeaShipVesselDistOffX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselSink_1   Does: Flip in 2 sprites to sink vessel / Clear the vessels gfx background image
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselSink_1     subroutine                  ; 1st from left to right
                        ldx #TabSeaVesselHit_01     ; .hbu025.
                        jsr SeaShipVesselExplode    ; .hbu025.
                        
                        lda TabSeaVesselHits_01     ; .hbu025.
                        beq .FlipIn                 ; .hbu025.
                        
                        rts                         ; .hbu025.
                        
.FlipIn                 lda #<BH_Vessel1SprtPosX    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_Vessel1SprtPosY     ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #BH_Vessel1SprtPosY + $10 ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_SeaShip_36      ; vessel 1
                        sta BH_SpritePointer04_A    ; 
                        
.Sink                   ldx #$01                    ; .hbu025.
                        jsr SeaShipVesselDrown      ; .hbu025. - try to sink vessel
                        beq SeaShipVesselSink_1X    ; .hbu025. - still alive
                        
.ClearBackGfx           lda #$73                    ; clear background - sky
                        sta Screen_SeaShips_V_1a + $00 ; .hbu013.
                        sta Screen_SeaShips_V_1b + $00 ; .hbu013.
                        sta Screen_SeaShips_V_1b + $01 ; .hbu013.
                        
                        if BH_Vessel1SprtPosX > $ff ; 
                        lda #$18                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        endif
                        
                        ldx #TabSeaVesselHit_01     ; 
                        stx TabSeaVesselHit         ; 
                        
SeaShipVesselSink_1X    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselSink_2   Does    : Flip in 2 sprites to sink vessel / Clear the vessels gfx background image
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselSink_2     subroutine                  ; 2nd from left to right
                        ldx #TabSeaVesselHit_02     ; .hbu025.
                        jsr SeaShipVesselExplode    ; .hbu025.
                        
                        lda TabSeaVesselHits_02     ; .hbu025.
                        beq .FlipIn                 ; .hbu025.
                        
                        rts                         ; .hbu025.
                        
.FlipIn                 lda #<BH_Vessel2SprtPosX    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_Vessel2SprtPosY     ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #BH_Vessel2SprtPosY +$08 + $01 ; slighly beyond horiizon line
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_SeaShip_37      ; vessel 2
                        sta BH_SpritePointer04_A    ; 
                        
                        ldx #$02                    ; .hbu025.
                        jsr SeaShipVesselDrown      ; .hbu025. - try to sink vessel
                        beq SeaShipVesselSink_2X    ; .hbu025. - still alive
                        
.ClearBackGfx           lda #$73                    ; clear background - sky
                        sta Screen_SeaShips_V_2a + $00 ; .hbu013.
                        sta Screen_SeaShips_V_2a + $01 ; .hbu013.
                        lda #$30                    ; clear background - sea
                        sta Screen_SeaShips_V_2b + $00 ; .hbu013.
                        sta Screen_SeaShips_V_2b + $01 ; .hbu013.
                        sta Screen_SeaShips_V_2b + $02 ; .hbu013.
                        
                        if BH_Vessel2SprtPosX > $ff ; 
                        lda #$18                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        endif
                        
                        ldx #TabSeaVesselHit_02     ; 
                        stx TabSeaVesselHit         ; 
                        
SeaShipVesselSink_2X    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselSink_3   Does    : Flip in 2 sprites to sink vessel / Clear the vessels gfx background image
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselSink_3     subroutine                  ; 3rd from left to right
                        ldx #TabSeaVesselHit_03     ; .hbu025.
                        jsr SeaShipVesselExplode    ; .hbu025.
                        
                        lda TabSeaVesselHits_03     ; .hbu025.
                        beq .FlipIn                 ; .hbu025.
                        
                        rts                         ; .hbu025.
                        
.FlipIn                 lda #<BH_Vessel3SprtPosX    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_Vessel3SprtPosY     ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #BH_Vessel3SprtPosY + $08 ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_SeaShip_38      ; vessel 3
                        sta BH_SpritePointer04_A    ; 
                        
                        ldx #$03                    ; .hbu025.
                        jsr SeaShipVesselDrown      ; .hbu025. - try to sink vessel
                        beq SeaShipVesselSink_3X    ; .hbu025. - still alive
                        
.ClearBackGfx           lda #$73                    ; clear background - sky
                        sta Screen_SeaShips_V_3     ; .hbu013.
                        
                        if BH_Vessel3SprtPosX > $ff ; 
                        lda #$18                    ; ...##...
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        endif                       ; 
                        
                        ldx #TabSeaVesselHit_03     ; 
                        stx TabSeaVesselHit         ; 
                        
SeaShipVesselSink_3X    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselSink_4   Does    : Flip in 2 sprites to sink vessel / Clear the vessels gfx background image
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselSink_4     subroutine                  ; 4th from left to right
                        ldx #TabSeaVesselHit_04     ; .hbu025.
                        jsr SeaShipVesselExplode    ; .hbu025.
                        
                        lda TabSeaVesselHits_04     ; .hbu025.
                        beq .FlipIn                 ; .hbu025.
                        
                        rts                         ; .hbu025.
                        
.FlipIn                 lda #<BH_Vessel4SprtPosX    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        lda #BH_Vessel4SprtPosY     ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        lda #BH_Vessel4SprtPosY + $06 ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_SeaShip_39      ; vessel 4
                        sta BH_SpritePointer04_A    ; 
                        
                        ldx #$04                    ; .hbu025.
                        jsr SeaShipVesselDrown      ; .hbu025. - try to sink vessel
                        beq SeaShipVesselSink_4X    ; .hbu025. - still alive
                        
                        if BH_Vessel4SprtPosX > $ff ; 
                        lda #$18                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        endif
                        
                        lda #$18                    ; 
                        ora XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
.ClearBackGfx           lda #$30                    ; clear background - sea
                        sta Screen_SeaShips_V_4 + $00 ; .hbu013.
                        sta Screen_SeaShips_V_4 + $01 ; .hbu013.
                        sta Screen_SeaShips_V_4 + $02 ; .hbu013.
                        sta Screen_SeaShips_V_4 + $03 ; .hbu013.
                        sta Screen_SeaShips_V_4 + $04 ; .hbu013.
                        
                        ldx #TabSeaVesselHit_04     ; 
                        stx TabSeaVesselHit         ; 
                        
SeaShipVesselSink_4X    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselDrown    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselDrown      subroutine                  ; 
.Sink                   lda #SP_Ptr_SeaShip_35      ; cover block
                        sta BH_SpritePointer03_A    ; 
                        
                        lda #$e7                    ; ###..###
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
.SpriteShip             lda #BH_SprtColorShipEnemy  ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
.SpriteCover            lda BGCOL1                  ; water
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        
                        lda #$e7                    ; ###..###
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$e7                    ; ###..###
                        and XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #$18                    ; ...##...
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$0f                    ; ....####
                        sta TabWaitSinkShipSav      ; 
                        sta TabWaitSinkShip         ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagSinkShip     ; 
                        
SeaShipVesselDrownX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselSinkScore Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselSinkScore  subroutine                  ; 
                        lda TabWaitFlagSinkShip     ; 
                        bne SeaShipVesselSinkScoreX ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagSinkShip     ; TabWaitFlag_Yes
                        
.Sink                   inc SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        cmp SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        bne SeaShipVesselSinkScoreX ; 
                        
.Disable                lda #$e7                    ; ###..###
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
.Score                  jsr AddScore_2000           ; 
                        
                        lda #TabSeaVesselHitNone    ; 
                        sta TabSeaVesselHit         ; 
                        
SeaShipVesselSinkScoreX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipVesselExplode  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipVesselExplode    subroutine                  ; 
                        lda #SP_Ptr_SeaShip_23      ; explosion
                        sta BH_SpritePointer01_A    ; 
                        
                        dec TabSeaVesselHits,x      ; .hbu025.
                        bne .Enable                 ; .hbu025. - still alive
                        
                        lda #TabSeaVesselActiveNo   ; 
                        sta TabSeaVesselActive,x    ; 
                        
                        jsr SetAcToXrTimesMult2     ; 
                        eor #$ff                    ; ########
                        and TabPlayerVesselActive   ; one bit per ship
                        sta TabPlayerVesselActive   ; 
                        
.ChkVesselShot          cpx TabSeaVesselShoots      ; 
                        bne .Enable                 ; 
                        
.SetVesselNext          jsr SeaShipGetRndVesselNo   ; .hbu023.
                        stx TabSeaVesselShoots      ; .hbu023.
                        
                        lda #TabBulletEnemyDistIni  ; 
                        sta TabBulletEnemyDist      ; 
                        
.Enable                 ldx #$01                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$0c                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #TabTargetHitYes        ; 
                        sta TabTargetHit            ; 
                        
                        lda #BH_SprtColorShipExplode; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda #BH_SprtColorShipExplodeBkgr ; 
                        sta TabBackGroundColor      ; flash
                        
                        jsr ResetTOD1               ; 
                        
                        lda #$10                    ; ...#....
                        bit TabSfxToPlay            ; 
                        beq .SfxExplodeInit         ; 
                        
                        rts                         ; 
                        
.SfxExplodeInit         jsr ResetVoc1               ; 
                        
                        lda #$50                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$0d                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        jsr ScreenStatusTextDist    ; .hbu011. - clear status
                        
SeaShipVesselExplodeX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipCarrierInit    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipCarrierInit      subroutine                  ; 
                        lda #BH_CarrierSprtPosX - $20 ; .hbu014.
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$18                    ; 
                        sta SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$18                    ; 
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #BH_CarrierSprtPosY     ; .hbu014.
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        sta SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        ldx #$1f                    ; ...#####
                        txa                         ; 
                        and YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        txa                         ; 
                        and XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        txa                         ; 
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        txa                         ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #BH_SprtColorShipEnemy  ; 
                        sta SP5COL                  ; VIC($D02C) Color Sprite 5
                        sta SP6COL                  ; VIC($D02D) Color Sprite 6
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        
                        ldx #SP_Ptr_SeaShip_32      ; carrier nose
                        stx BH_SpritePointer05_A    ; 
                        inx                         ; carrier mid
                        stx BH_SpritePointer06_A    ; 
                        inx                         ; carrier rear
                        stx BH_SpritePointer07_A    ; 
                        
                        lda #$e0                    ; ###.....
                        ora SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$0f                    ; 
                        sta TabWaitMoveCarrierSav   ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveShip     ; 
                        
SeaShipCarrierInitX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipCarrierMove    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipCarrierMove      subroutine                  ; 
                        lda TabFlagCarrierActive    ; 
                        bne .ChkMove                ; TabFlagCarrierActiveYes
                        
.Exit                   rts                         ; 
                        
.ChkMove                lda TabWaitFlagMoveShip     ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagMoveShip     ; TabWaitFlag_Yes
                        
.ChkNosePosX            lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .ChkMidPosX              ; 
                        
                        dec SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
.ChkMidPosX             lda SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .ChkRearPosX            ; 
                        
                        dec SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
.ChkRearPosX            lda SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .Deactivate             ; 
                        
                        dec SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        rts                         ; 
                        
.Deactivate             lda #$1f                    ; ...#####
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        dec TabFlagCarrierActive    ; TabFlagCarrierActiveNo
                        
                        lda #$df                    ; ##.#####
                        and TabPlayerVesselActive   ; one bit per ship
                        sta TabPlayerVesselActive   ; 
                        
SeaShipCarrierMoveX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipCarrierDrown   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipCarrierDrown     subroutine                  ; 
                        ldx #TabSeaVesselHit_05     ; carrier
                        jsr SeaShipVesselExplode    ; 
                        
                        lda TabSeaVesselHits_05     ; .hbu025.
                        beq .Sink                   ; .hbu025.
                        
                        rts                         ; .hbu025.
                        
.Sink                   dec TabFlagCarrierActive    ; TabFlagCarrierActiveNo
                        
                        lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #BH_CarrierSprtPosY + $12 ; .hbu014. 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda #SP_Ptr_SeaShip_35      ; cover block
                        sta BH_SpritePointer03_A    ; 
                        sta BH_SpritePointer04_A    ; 
                        
                        lda #$e7                    ; ###..###
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda BGCOL1                  ; water
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
                        lda #$e7                    ; ###..###
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$18                    ; 
                        ora XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        ldx #$03                    ; ......##
                        jsr SpritesEnableNoFromXr   ; 
                        
                        ldx #$04                    ; .....#..
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$0f                    ; ....####
                        sta TabWaitSinkShipSav      ; 
                        sta TabWaitSinkShip         ; 
                        
                        lda #TabSeaVesselHit_05     ; 
                        sta TabSeaVesselHit         ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagSinkShip     ; 
SeaShipCarrierDrownX    rts
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipStatusShipsOut Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipStatusShipsOut   subroutine                  ; 
                        jsr ScreenStatusShowShips   ; 
                        
                        lda CHR_LOR                 ; Char ROM($dc00) lower case reversed
                        eor #$ff                    ; 
                        and #$03                    ; ......##
                        bne .ChkSpriteStatus        ; 
                        
                        lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus         ; 
                        
                        lda #$14                    ; 
                        sta TabCountDown1_00        ; 
                        
                        rts                         ; 
                        
.ChkSpriteStatus        lda TabSpriteStatus         ; 
                        bne .ChkWait                ; TabSpriteStatusUsed
                        
                        lda #$04                    ; 
                        sta TabPlaySfxVoc1_06       ; 
                        sta TabPlaySfxVoc2_06       ; 
                        
                        lda #$01                    ; 
                        sta TabSpriteStatus         ; TabSpriteStatusUsed
                        sta TabWaitFlagSfxShot      ; TabWaitFlag_Yes
                        
.Exit                   rts                         ; 
                        
.ChkWait                lda TabWaitFlagSfxShot      ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagSfxShot      ; TabWaitFlag_Yes
                        
                        lda TabCountDown1_00        ; 
                        cmp #$01                    ; 
                        beq .Exit                   ; 
                        
                        dec TabCountDown1_00        ; 
                        
SeaShipStatusShipsOutX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipEnemyGetCollSpBg Does  : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipEnemyGetCollSpBg subroutine                  ; 
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        cmp #$98                    ; 
                        bcc .GoGetColl              ; lower
                        
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        ora TabSprtBackCollReg      ; 
                        sta TabSprtBackCollReg      ; 
                        
                        rts                         ; 
                        
.GoGetColl              jsr SpritesGetBackCollReg   ; sprite/foregr collision
SeaShipEnemyGetCollSpBgX rts                        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipChkDestroyMsg  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipChkDestroyMsg    subroutine                  ; 
                        lda TabSeaShipMsgDestroy    ; 
                        cmp #TabSeaShipMsgDestroyYes; 
                        beq .MsgDestroyOut          ; 
                        
                        rts                         ; 
                        
.MsgDestroyOut          jsr ScreenStatusDestroy     ; 
                        
;                        lda TabSeaShipMsgDestroy    ; 
                        
SeaShipChkDestroyMsgX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipSinkAndScore   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipSinkAndScore     subroutine                  ; 
                        lda TabSeaVesselHit         ; 
                        bpl .ChkCarrier             ; TabSeaVesselHit_05
                        
                        rts                         ; 
                        
.ChkCarrier             cmp #$05                    ; 
                        beq .ChkSinks               ; 
                        
                        tax                         ; 
                        jsr SeaShipVesselSinkScore  ; 
                        rts                         ; 
                        
.ChkSinks               lda TabWaitFlagSinkShip     ; 
                        bne SeaShipSinkAndScoreX    ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagSinkShip     ; TabWaitFlag_Yes
                        
                        inc SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        inc SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        inc SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        lda SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        cmp #$9b                    ; 
                        bne SeaShipSinkAndScoreX    ; 
                        
SeaShipScoreCarrier     subroutine                  ; 
                        lda #$07                    ; .....###
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        jsr AddScore_1000           ; 
                        jsr AddScore_9000           ; 
                        
                        lda #$df                    ; ##.#####
                        and TabPlayerVesselActive   ; one bit per ship
                        sta TabPlayerVesselActive   ; 
                        
                        lda #TabSeaVesselHitNone    ; 
                        sta TabSeaVesselHit         ; 
                        
SeaShipSinkAndScoreX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipEneExplodeOff  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipEneExplodeOff    subroutine                  ; 
                        lda TabTargetHit            ; 
                        bne .ChkTime                ; TabTargetHitYes
                        
                        rts                         ; 
                        
.ChkTime                lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        beq SeaShipEneExplodeOffX   ; 
                        
.ExplodeFlashOff        lda #CYAN                   ; sky
                        sta TabBackGroundColor      ; 
                        
                        lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp #$03                    ; 
                        bne SeaShipEneExplodeOffX   ; 
                        
.SpriteExplosionOff     lda #$fd                    ; ######.#
                        and SPENA                   ; VIC($D015) Sprite Enable Register
.Enab                   sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        dec TabTargetHit            ; TabTargetHitNo
                        
SeaShipEneExplodeOffX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SeaShipDemo           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SeaShipDemo             subroutine                  ; 
                        lda TabGameMode             ; 
                        bne .ChkDemoTime            ; TabGameModeDemo or TabGameModeExit
                        
                        rts                         ; 
                        
.ChkDemoTime            lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #BH_DemoTimeSeaShip     ; 
                        bcc .ContinueDemo           ; 
                        
                        jsr ResetTOD2               ; 
                        
                        lda #TabGameModeDemoToBeach ; fleet moves to beach
                        sta TabGameMode             ; 
                        
                        pla                         ; 
                        pla                         ; 
                        
                        lda #$04                    ; .....#..
                        sta TabPlayerLives          ; 
                        
.Init                   jsr SpritesAcToTabActive    ; 
                        jsr SwitchPlayerAndValues   ; 
                        jmp MapInitBayAreaToBeach   ; --> BayLevels - Start next chapter
                        
.ContinueDemo           lda #$01                    ; .......#
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .ChkCannonPosX          ; 
                        
.GetMovLeft             lda #CIA_Joy_Le             ; 
                        sta TabJoysticAction        ; 
                        jmp .ChkDistShot            ; 
                        
.ChkCannonPosX          lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$63                    ; 
                        beq .ChkDistShot            ; 
                        bcs .GetMovLeft             ; 
                        
.GetMovRight            lda #CIA_Joy_Ri             ; 
                        sta TabJoysticAction        ; 
                        
.ChkDistShot            lda TabCannonShotDist       ; 
                        cmp #$60                    ; 
                        beq .MovFire                ; 
                        bcc .GetMovDown             ; 
                        
.GetMovUp               lda #CIA_Joy_Up             ; 
                        
.SetMovUpDo             ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
.MovFire                lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
.Exit                   rts                         ; 
                        
.GetMovDown             lda #CIA_Joy_Do             ; 
SeaShipDemoX            bne .SetMovUpDo             ; always
; -------------------------------------------------------------------------------------------------------------- ;
; BulletWaterSplash     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BulletWaterSplash       subroutine                  ; 
                        lda TabSeaVesselHit         ; 
                        bmi .ChkPhase               ; TabSeaVesselHitNone
                        
                        rts                         ; 
                        
.ChkPhase               lda TabCannonShotDist       ; 
.ChkPhaseMax            cmp #$41                    ; 
                        bcs .ChkPhaseMid            ; higher/equal
                        
.GetSplashMax           lda #SP_Ptr_SeaShip_26      ; water splash phase 3 - max
                        jmp .SetSplashSpritePtr     ; 
                        
.ChkPhaseMid            cmp #$63                    ; 
                        bcs .GetSplashMin           ; higher/equal
                        
.GetSplashMid           lda #SP_Ptr_SeaShip_25      ; water splash phase 2
                        jmp .SetSplashSpritePtr     ; 
                        
.GetSplashMin           lda #SP_Ptr_SeaShip_24      ; water splash phase 1 - min
                        
.SetSplashSpritePtr     sta BH_SpritePointer03_A    ; 
                        
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda TabCannonShotHeight     ; 
                        sec                         ; 
                        sbc #$0a                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #$02                    ; ......#.
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .SetPosX_Msb            ; 
                        
.ClrPosX_Msb            lda #$f7                    ; ####.###
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .SetSplashColor         ; 
                        
.SetPosX_Msb            lda #$08                    ; ....#...
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.SetSplashColor         lda #BH_SprtColorShipSplash ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        
                        lda #$f7                    ; 
                        and YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        
                        lda #$f7                    ; 
                        and XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #TabBulletWaterSplashYes; 
                        sta TabBulletWaterSplash    ; 
                        
                        lda #$14                    ; 
                        sta TabWaitWaterSplash      ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagAutoAction   ; 
                        
                        ldx #$03                    ; ......##
                        jsr SpritesEnableNoFromXr   ; 
                        
BulletWaterSplashX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BulletWaterSplashOff  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BulletWaterSplashOff    subroutine                  ; 
                        lda TabBulletWaterSplash    ; 
                        bne .ChkWait                ; TabBulletWaterSplashYes
                        
.Exit                   rts                         ; 
                        
.ChkWait                lda TabWaitFlagAutoAction   ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        lda #TabBulletWaterSplashNo ; 
                        sta TabBulletWaterSplash    ; 
                        
                        ldx #$03                    ; ......##
                        jsr SpritesDisableNoFromXr  ; 
BulletWaterSplashOffX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonSpritePosInit   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonSpritePosInit     subroutine                  ; 
                        lda TabPlrShootSprtBasePtr2 ; 
                        clc                         ; 
                        adc #$08                    ; 
                        sta BH_SpritePointer00_A    ; 
                        
                        lda #$60                    ; 
                        sta TabCannonShotDegree     ; 
                        
                        lda #$b5                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #$ac                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$fe                    ; #######.
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$01                    ; 
                        sta TabWaitTimeCanLeRiSav   ; 
                        sta TabWaitTimeCanUpDoSav   ; 
                        
                        ldx #$00                    ; 
                        jsr SpritesEnableNoFromXr   ; 
CannonSpritePosInitX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerMove      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerMove        subroutine                  ; 
.ChkNextMoveLeRi        lda TabWaitFlagMoveLeRi     ; 
                        bne .ChkNextMoveUpDo        ; TabWaitFlag_Yes
                        
.SetWaitLeRi            inc TabWaitFlagMoveLeRi     ; TabWaitFlag_Yes
                        
.Chk_Le                 lda #CIA_Joy_Le             ; .....#..
                        bit TabJoysticAction        ; 
                        beq .Chk_Ri                 ; 
                        
.MovCannonLe            jsr ClearDirInJoyAction     ; 
                        
.ChkMsbPosX             lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; .......#
                        bne .DecPosX                ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
.MinLe                  cmp #$18                    ; 
                        beq .ChkNextMoveUpDo        ; 
                        
.DecPosX                lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$01                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .ChkNextMoveUpDo        ; 
                        
.SetMsbPosX             lda #$01                    ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .ChkNextMoveUpDo        ; 
                        
.Chk_Ri                 lda #CIA_Joy_Ri             ; ....#...
                        bit TabJoysticAction        ; 
                        beq .ChkNextMoveUpDo        ; 
                        
.MovCannonRi            jsr ClearDirInJoyAction     ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$01                    ; 
                        beq .IncPosX                ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
.MaxRi                  cmp #$40                    ; 
                        beq .ChkNextMoveUpDo        ; 
                        
.IncPosX                inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne .ChkNextMoveUpDo        ; 
                        
                        jmp .SetMsbPosX             ; 
                        
.ChkNextMoveUpDo        lda TabWaitFlagMoveUpDo     ; 
                        beq .SetWaitUpDo            ; TabWaitFlag_No
                        
                        rts                         ; 
                        
.SetWaitUpDo            inc TabWaitFlagMoveUpDo     ; TabWaitFlag_Yes
                        
.Chk_Do                 lda #CIA_Joy_Do             ; ......#.
                        bit TabJoysticAction        ; 
                        beq .Chk_Up                 ; 
                        
.MovCannonDo            jsr ClearDirInJoyAction     ; 
                        
                        lda TabCannonShotDegree     ; 
.MinDo                  cmp #$20                    ; 
                        beq .GetSpritePtr           ; 
                        
                        dec TabCannonShotDegree     ; 
                        jmp .GetSpritePtr           ; 
                        
.Chk_Up                 lda #CIA_Joy_Up             ; .......#
                        bit TabJoysticAction        ; 
                        beq .GetSpritePtr           ; 
                        
.MovCannonUp            jsr ClearDirInJoyAction     ; 
                        
                        lda TabCannonShotDegree     ; 
.MaxUp                  cmp #$99                    ; 
                        beq .GetSpritePtr           ; 
                        
                        inc TabCannonShotDegree     ; 
                        
.GetSpritePtr           lda TabCannonShotDegree     ; 
                        sec                         ; 
                        sbc #$20                    ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        clc                         ; 
                        adc TabPlrShootSprtBasePtr2 ;  
                        sta BH_SpritePointer00_A    ; 
                        
CannonPlayerMoveX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerShootInit Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerShootInit   subroutine                  ; 
                        lda #CIA_Joy_Fi             ; ...#....
                        bit TabJoysticAction        ; 
                        bne .ClrFireButton          ; 
                        
.Exit                   rts                         ; 
                        
.ClrFireButton          jsr ClearDirInJoyAction     ; 
                        
                        lda TabPlayerShoots         ; 
                        bne .Exit                   ; TabPlayerShootsYes
                        
                        lda TabPlayerAmmo           ; 
                        beq .Exit                   ; 
                        
                        ldx TabPlayerShootSpriteNo  ; 
                        lda TabSpriteStatus,x       ; 
                        bne .Exit                   ; TabSpriteStatusUsed
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$ba                    ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        sec                         ; 
                        sbc TabCannonShotDegree     ; 
                        sta TabBulletHight,x        ; 
                        
                        lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .ClrMsbPosX             ; 
                        
.SetMsbPosX             jsr SetAcToXrTimesMult2     ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .GetSpritePtrBase       ; 
                        
.ClrMsbPosX             jsr SetAcToXrTimesMult2     ; 
                        eor #$ff                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.GetSpritePtrBase       lda TabPlrShootSprtBasePtr1 ; 
                        sta BH_SpritePointers_A,x   ; 
                        
                        lda #$00                    ; 
                        sta TabSpriteStepCount,x    ; 
                        
                        cpx #$01                    ; 
                        bne .GetSpriteNo_1          ; 
                        
.GetSpriteNo_2          lda #$02                    ; 
                        jmp .SetSpriteNo            ; 
                        
.GetSpriteNo_1          lda #$01                    ; 
                        
.SetSpriteNo            sta TabPlayerShootSpriteNo  ; 
                        
                        lda #TabSpriteStatusUsed    ; 
                        sta TabSpriteStatus,x       ; 
                        jsr SpritesEnableNoFromXr   ; 
                        jsr SetVoc2_Cannon          ; 
                        jsr PlayerAmmoDec           ; 
                        jsr CannonPlayerSetSprtPtr  ; 
                        
                        lda #TabPlayerShootsYes     ; 
                        sta TabPlayerShoots         ; 
                        
                        lda #$00                    ; 
                        sta TabPlayerBulletPhaseNo  ; 
                        
CannonPlayerFireX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerSetSprtPtr Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerSetSprtPtr  subroutine                  ; 
                        lda BH_SpritePointer00_A    ; 
                        clc                         ; 
                        adc #$02                    ; 
                        
                        pha                         ; save
                        sbc #$0f                    ; 
                        cmp TabPlrShootSprtBasePtr2 ; 
                        pla                         ; restore
                        bcs CannonPlayerSetSprtPtrX ; greater/equal
                        
                        sta BH_SpritePointer00_A    ; lower
                        
.SetInitialWait         lda #$0a                    ; 
                        sta TabWaitTimeMoveUpDo     ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveUpDo     ; 
                        
CannonPlayerSetSprtPtrX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerShoot     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerShoot       subroutine                  ; 
                        ldx #$02                    ; 
.GetStatusBullets       lda TabSpriteStatus,x       ; 
                        beq .SetNextBullet          ; TabSpriteStatusFree
                        
                        lda TabWaitFlagMoveLeRi,x   ; 
                        bne .SetNextBullet          ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagMoveLeRi,x   ; TabWaitFlag_Yes
                        inc TabSpriteStepCount,x    ; 
                        
                        lda TabSpriteStepCount,x    ; 
                        cmp #$10                    ; 
                        bne .ChkBullet              ; 
                        
                        lda #TabPlayerShootsNo      ; 
                        sta TabPlayerShoots         ; 
                        
.ChkBullet              lda TabSpriteStepCount,x    ; 
                        cmp #$1e                    ; max
                        beq .ClrBullet              ; 
                        
.SetSpritePtr1          lda TabPlrShootSprtBasePtr1 ; 
                        clc                         ; 
__PlayerShootSprtPtrAdd equ * + $01                 ; 
                        adc #$09                    ; 
                        cmp BH_SpritePointers_A,x   ; 
                        beq .IncBulletFlightHeight  ; 
                        
.SetSpritePtr2          lda TabSpriteStepCount,x    ; 
                        lsr a                       ; 
                        clc                         ; 
                        adc TabPlrShootSprtBasePtr1 ; 
                        sta BH_SpritePointers_A,x   ; 
                        
.IncBulletFlightHeight  lda TabBulletHight,x        ; 
                        lsr a                       ; /2
                        lsr a                       ; /4
                        lsr a                       ; /8
                        sta TabWrkPlayerShot        ; 
                        
                        lda TabBulletHight,x        ; 
                        sec                         ; 
                        sbc TabWrkPlayerShot        ; 
                        sta TabBulletHight,x        ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc TabWrkPlayerShot        ; 
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
.SetNextBullet          dex                         ; 
                        bne .GetStatusBullets       ; 
                        
                        rts                         ; 
                        
.ClrBullet              lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus,x       ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
                        lda #$01                    ; 
                        sta TabPlayerBulletPhaseNo  ; 
CannonPlayerShootX      jmp .SetNextBullet          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonPlayerBullet    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonPlayerBullet      subroutine                  ; 
                        lda TabSpriteStatus_01      ; 
                        bne .ChkBulletPase_00       ; TabSpriteStatusUsed
                        
.ExitNoShot             rts                         ; TabSpriteStatusFree
                        
.ChkBulletPase_00       lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus_02      ; 
                        
                        lda TabPlayerBulletPhaseNo  ; 
                        bne .ChkBulletPase_01       ; 
                        
                        lda #$0b                    ; 
                        sta __PlayerShootSprtPtrAdd ; 
                        
                        lda #BLACK                  ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        jsr CannonPlayerShoot       ; 
                        
                        lda #$09                    ; 
                        sta __PlayerShootSprtPtrAdd ; 
                        
                        lda #TabSpriteStatusUsed    ; 
                        sta TabSpriteStatus_01      ; 
                        
.ExitPase_00            rts                         ; 
                        
.ChkBulletPase_01       cmp #$01                    ; 
                        bne .ChkBulletPase_02       ; 
                        
                        ldx #$01                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$04                    ; 
                        sta TabWaitTimeBullFlyPhSav ; 
                        sta TabWaitTimeBullFlyPh    ; 
                        sta TabWaitFlagBulletFlyPh  ; TabWaitFlag_Yes + extra
                        
                        inc TabPlayerBulletPhaseNo  ; 
                        
                        lda #$b6                    ; 
                        sec                         ; 
                        sbc TabCannonShotDegree     ; 
                        sta TabCannonShotDist       ; 
                        
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        sta TabCannonShotHeight     ; 
                        
                        lda #$a2                    ; 
                        sec                         ; 
                        sbc TabCannonShotHeight     ; 
                        sta TabCannonShotHeight     ; 
                        
                        lda #$84                    ; 
                        sta TabMoveSpriteUpDo_01    ; 
                        
                        lda #TabSpriteActiveYes     ; 
                        sta TabSpriteActive_01      ; bullet p1
                        
                        lda #$00                    ; 
                        sta TabMoveSpriteLeRi_01    ; 
                        sta TabPlaneSpeedAppr_01    ; TabPlaneSpeedApprNone
                        
.ExitPase_01            rts                         ; 
                        
.ChkBulletPase_02       cmp #$02                    ; 
                        bne .ExitPase_01            ; 
                        
                        lda TabWaitFlagBulletFlyPh  ; 
                        bne .ExitPase_01            ; TabWaitFlag_Yes
                        
                        inc TabMoveSpriteUpDo_01    ; 
                        inc TabWaitFlagBulletFlyPh  ; TabWaitFlag_Yes
                        
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        cmp TabCannonShotHeight     ; 
                        bcc .ExitPase_01            ; lower
                        
                        lda #TabSpriteActiveNo      ; 
                        sta TabSpriteActive_01      ; bullet p1
                        
                        ldx #$01                    ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
.ChkCarrActive          lda TabFlagCarrierActive    ; 1st check the carrier
                        beq .ChkVesselMsbPosX       ; TabFlagCarrierActiveNo
                        
                        lda #$02                    ; ......#.
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .ChkVesselMsbPosX       ; 
                        
.ChkCarrNose            lda SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$0c                    ; 
                        bcc .ChkCarrRear            ; lower
                        
                        cmp SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcs .ChkVesselMsbPosX       ; 2nd check vessel 04
                        
.ChkCarrRear            lda SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$08                    ; 
                        cmp SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bcc .ChkVesselMsbPosX       ; lower
                        
                        lda TabCannonShotDist       ; 
                        cmp TabVesselVaryDist_05    ; .hbu021.
                        bne .ChkCarrDistShortLong   ; 
                        
                        jsr SeaShipCarrierDrown     ; 
                        
.ReInitShotAndExit      lda #$00                    ; 
                        sta TabSpriteStatus_01      ; TabSpriteStatusFree
                        sta TabPlayerBulletPhaseNo  ; 
                        
                        rts                         ; 
                        
.ChkCarrDistShortLong   sec                         ; 
                        sbc TabVesselVaryDist_05    ; .hbu021.
                        bcc .MakePositive           ; underflow
                        
                        jsr ScreenStatusTextLong    ; shoot was too long
                        jmp .ReInitShotAndExit      ; 
                        
.MakePositive           eor #$ff                    ; make positive
                        clc                         ; 
                        adc #$01                    ; 
                        jsr ScreenStatusTextShort   ; shoot was too short
                        jsr BulletWaterSplash       ; 
                        jmp .ReInitShotAndExit      ; 
                        
.ChkVesselMsbPosX       lda #$02                    ; ......#.
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .ChkPosVessel_4         ; 
                        
.ChkPosVessel_1         lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$4c                    ; min PosX
                        bcs .ChkPosVessel_2         ; greater/equal
                        
                        lda TabSeaVesselActive_01   ; 
                        beq .GoBulletHitsWater      ; TabSeaVesselActiveNo
                        
                        lda TabCannonShotDist       ; 
                        sec                         ; 
                        sbc TabVesselVaryDist_01    ; .hbu021.
                        bne .ChkVesselDistShortLong ; 
                        
                        lda #$02                    ; ......#.
                        bit TabSprtBackCollReg      ; 
                        beq .GoBulletHitsWater      ; 
                        
                        jsr SeaShipVesselSink_1     ; 1st from left to right
                        jmp .ReInitShotAndExit      ; 
                        
.ChkPosVessel_2         cmp #$84                    ; min PosX
                        bcs .ChkPosVessel_3         ; greater/equal
                        
                        lda TabSeaVesselActive_02   ; 
                        beq .GoBulletHitsWater      ; TabSeaVesselActiveNo
                        
                        lda TabCannonShotDist       ; 
                        sec                         ; 
                        sbc TabVesselVaryDist_02    ; .hbu021.
                        bne .ChkVesselDistShortLong ; 
                        
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        beq .GoBulletHitsWater      ; 
                        
                        jsr SeaShipVesselSink_2     ; 2nd from left to right
                        jmp .ReInitShotAndExit      ; 
                        
.ChkPosVessel_3         lda TabSeaVesselActive_03   ; rest is vessel 03
                        beq .GoBulletHitsWater      ; TabSeaVesselActiveNo
                        
                        lda TabCannonShotDist       ; 
                        sec                         ; 
                        sbc TabVesselVaryDist_03    ; .hbu021.
                        bne .ChkVesselDistShortLong ; 
                        
                        lda #$02                    ; ......#.
                        bit TabSprtBackCollReg      ; 
                        beq .GoBulletHitsWater      ; 
                        
                        jsr SeaShipVesselSink_3     ; 3rd from left to right
                        jmp .ReInitShotAndExit      ; 
                        
.ChkPosVessel_4         lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$0c                    ; min PosX vesssel 04 always gt $ff
                        bcc .ChkPosVessel_3         ; 
                        
                        lda TabSeaVesselActive_04   ; 
                        beq .GoBulletHitsWater      ; TabSeaVesselActiveNo
                        
                        lda TabCannonShotDist       ; 
                        sec                         ; 
                        sbc TabVesselVaryDist_04    ; ,hbu021.
                        bne .ChkVesselDistShortLong ; 
                        
                        lda #$02                    ; 
                        bit TabSprtBackCollReg      ; 
                        beq .GoBulletHitsWater      ; 
                        
                        jsr SeaShipVesselSink_4     ; 4th from left to right
                        jmp .ReInitShotAndExit      ; 
                        
.GoBulletHitsWater      jmp .BulletHitsWater        ; 
                        
.ChkVesselDistShortLong bcc .OutStatusDistTooShort  ; 
                        jsr ScreenStatusTextLong    ; shoot was too long
                        
                        lda #$02                    ; ......#.
                        bit TabSprtBackCollReg      ; 
                        bne .GoInitShotAndExit      ; 
                        
.BulletHitsWater        jsr BulletWaterSplash       ; 
.GoInitShotAndExit      jmp .ReInitShotAndExit      ; 
                        
.OutStatusDistTooShort  eor #$ff                    ; 
                        clc                         ; 
                        adc #$01                    ; 
                        jsr ScreenStatusTextShort   ; shoot was too short
CannonPlayerBulletX     jmp .BulletHitsWater        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MapHitBeachTankHill   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MapHitBeachTankHill     subroutine                  ; 
                        lda TabBayMapSeaChapters    ; 
                        beq .ChkBeachPosX           ; TabBayMapSeaChaptersNo
                        
.Exit                   rts                         ; 
                        
.ChkBeachPosX           lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #BH_BeachMinPosX        ; 
                        bcc .Exit                   ; lower
                        
                        cmp #BH_BeachMaxPosX        ; 
                        bcs .Exit                   ; higher/equal
                        
.ChkBeachPosY           lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #BH_BeachMinPosY        ; 
                        bcc .Exit                   ; lower
                        
                        cmp #BH_BeachMaxPosY        ; 
                        bcs .Exit                   ; higher/equal
                        
.IniShip2TankCount      ldx #$01                    ; max players
.CpyShip2TankCount      lda TabPlayerLivesSav,x     ; 
                        asl a                       ; 
                        sta TabPlayerTanksSav,x     ; 
                        dex                         ; 
                        bpl .CpyShip2TankCount      ; 
                        
                        ldx TabPlayerActive         ; 
                        jsr PlayerValuesRestore     ; 
                        
                        jsr ChapterStartBell        ; 
MapHitBeachTankHillX    jmp Chapter_TanksOnBeach    ; --> BeachLevels - Start next chapter
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter_TanksOnBeach  Does    : Chapter: Tanks on the beach
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_TanksOnBeach    subroutine                  ; 
                        jsr TanksOnBeachInit        ; 
                        
.TanksOnBeach_Loop      jsr TankScrollTerrain       ; scroll terrain forward
                        jsr TankPlayerCheckShoots   ; player: check start shooting
                        jsr SpritesGetSprtCollReg   ; sprite/sprite collision
                        jsr TankPlayerMovTank       ; player: move tank
                        jsr TankCheckPosCannon      ; enemy: cannon
                        jsr TankCheckPosTank        ; enemy: tank
                        jsr TankCheckPosMachGun     ; enemy: machine gun
                        jsr TankCheckPosTurret      ; enemy: turret
                        jsr TankEnemyMovTank        ; enemy: move tank
                        jsr TankEnemyShoot          ; enemy: shoots
                        jsr TankEnemyMovShot        ; enemy: move shot
                        jsr TankPlayerShoot         ; player: shoots
                        jsr TankPlayerMovShot       ; player: move shot
                        jsr TankPlayerHitCheck      ; player: hit check
                        jsr TankEnemyHitCheck       ; enemy: hit check
                        
                        jsr TankPlayerChkCollBack   ; 
                        jsr TankPlayerChkCollSprt   ; 
                        
                        jsr TankEnemyClrHitScore    ; enemy: wipe out hit score 
                        jsr PlayerAmmoInc           ; 
                        jsr TankAdaptSfxWithPosY    ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr ScreenStatusShowTanks   ; 
                        jsr CheckGamePause          ; on C= commodore key
                        jsr CheckGameFinished       ; Quit/Idle time/Death - 2 level return to BASIC via GameStart
                        
.ChkFinish              lda TabScrnTankScrollPos    ; 
StrandTesting           if TANK_TEST = 2            ; .test.
                        cmp #TabScrnTankScrollPosTst; .test - short scrolling
                        endif                       ; .test
.GoStormTheHill         beq .ChkShoreFileMax        ; check end of the beach
                        
                        jsr TankClearSpriteAtMaxX   ; 
                        jsr CheckGameIdleTime       ; 
                        jsr TankDemo                ; 
                        jsr TankAdaptSpritePosX     ; keep PosX despite of beach scrolling
                        
                        jmp .TanksOnBeach_Loop      ; 
                        
.ChkShoreFileMax        lda TabStrandFileNam_1      ; .hbu016.
__BeachLevelSkillNo     equ * + $01                 ; .hbu016. - GR_LevelBeachLevelNo
                        cmp #"0"                    ; .hbu016.
                        beq Chapter_TanksOnBeachX   ; .hbu016. - next chapter: storm the hill
                        
.TanksOnBeach_LoadLevel jsr TanksOnBeachInitShore   ; .hbu016.
                        jmp .TanksOnBeach_Loop      ; .hbu016. - get next shore level file
                        
Chapter_TanksOnBeachX   jmp Chapter_StormTheHill    ; --> BeachLevels - Start next chapter
; -------------------------------------------------------------------------------------------------------------- ;
; TanksOnBeachInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TanksOnBeachInit        subroutine                  ; 
                        jsr ScreenStatusGetReady    ; .hbu013.
                        
                        ldx #BH_ChapterTanksOnBeach ; .hbu013.
.LoadChapter            jsr LoadChapterData         ; .hbu013.
                        
TanksOnBeachInitShore   subroutine                  ; .hbu016.
.Inits                  jsr TabSpritesWaitsInits    ; 
                        jsr TankInitDefaults        ; ammo/shot speeds
                        
.LoadLevel              jsr LoadStrandData          ; .hbu016.
                        
                        jsr TankInitScreenStatus    ; status screen
                        jsr TankInitMyTanks         ; sprites/sound
                        
                        lda #TabScrnTankScrollPosIni; leftmost screen column on starting screen
                        sta TabScrnTankScrollPos    ; 
                        
                        lda #$ff                    ; 
                        sta TabScrnTankBayScrollDec ; 
                        
                        lda #$02                    ; 
                        sta TabWaitTimeBeachLeRiSav ; equalize scroll speed
                        
                        lda #$03                    ; 
                        sta TabWaitTimeBeachUpDoSav ; 
                        sta TabWaitTimeTOD_Sec      ; 
                        
                        jsr ResetTOD1               ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr TankInitSfx             ; 
                        
                        lda #$00                    ; 
                        sta TabJoysticAction        ; 
                        
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        
TanksOnBeachInitX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitDefaults      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitDefaults        subroutine                  ; 
                        lda #$0a                    ; 
                        sta TabPlayerAmmo           ; 
                        jsr SpritesReset            ; 
                        
                        lda #$00                    ; 
                        sta TabTankShotSprtNoSav    ; 
                        sta TabTankScoreSpriteNo    ; 
                        
                        lda #$04                    ; 
                        sta TabTankShotSpeed        ; 
                        
                        lda #$03                    ; 
                        sta TabTankShotSpeedEne     ; 
                        
TankInitDefaultsX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitScreenStatus  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitScreenStatus    subroutine                  ; 
                        lda #VIC_Cols38             ; ####.###
                        and SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #VIC_Sprts_Off          ; and BLACK
                        sta SPENA                   ; VIC($D015) Sprite Enable Register - all off
                        sta BGCOL0                  ; VIC($D021) Background Color 0
                        
                        lda #TabTankScrollAreaTabPtrStart ; screen_00
                        sta TabTankScrollAreaTabPtr ; to TabTankScrollAreaPtrLo/Hi table
                        
                        jsr ScreenStatusShowScore   ; .hbu016.
                        jsr ScreenStatusShowTanks   ; .hbu016.
                        jsr TankScreenShowStart     ; 
                        jsr ScreenStatusShowTanks   ; 
                        
TankInitScreenStatusX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitMyTanks       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitMyTanks         subroutine                  ; 
.GetTankSpritePtr       lda #SP_Ptr_Beach_01        ; my tank move left
                        sta BH_SpritePointers_A     ; .hbu017.
                        sta BH_SpritePointers_B     ; .hbu017.
                        
                        lda #BH_SprtColorBeachTank  ; 
                        sta SP0COL                  ; .hbu017. VIC($D027) Color Sprite 0
                        
                        lda #$dc                    ; 
                        sta SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010) .hbu017.
                        
                        lda #$a3                    ; .hbu017.
                        sta SP0Y                    ; .hbu017. VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
                        lda #WHITE                  ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        
                        lda #BLACK                  ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        
                        lda #VIC_Sprts_YY_Off       ; 
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #VIC_Sprts_MC_On        ; 
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$00                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #VIC_Sprt0_On           ; .hbu017 - my tank
                        sta SPENA                   ; .hbu017
                        
                        lda #$04                    ; 
                        sta TabPlaySfxVoc2_00       ; 
                        sta TabPlaySfxVoc1_00       ; 
                        
                        jsr ResetVoc1               ; 
                        jsr ResetVoc2               ; 
                        
                        lda #$14                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$30                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        lda #$00                    ; 
                        sta FRELO2                  ; SID($D407) Oscillator 2 Freq Ctrl (low byte)
                        lda #$02                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        lda #$50                    ; 
                        sta SUREL2                  ; SID($D40D) Oscillator 2 Sustain/Release
                        lda #$21                    ; 
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        lda #$01                    ; 
                        sta TabPlaySfxVoc1_05       ; 
                        sta TabPlaySfxVoc2_05       ; 
                        
TankInitMyTanksX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerMovTank     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerMovTank       subroutine                  ; 
                        lda TabScrnTankScrollPos    ; .hbu010.
                        cmp #TabScrnTankScrollPosGo ; .hbu010.
                        bcs TankPlayerMovTankX      ; .hbu010. - higher/equal
                        
                        lda TabWaitFlagMoveUpDo     ; 
                        bne .Exit_1                 ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagMoveUpDo     ; TabWaitFlag_Yes
                        
.ChkUp                  lda #CIA_Joy_Up             ; 
                        bit TabJoysticAction        ; 
                        beq .ChkDown                ; 
                        
                        jsr ClearDirInJoyAction     ; 
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$68                    ; 
                        bcc .Exit_1                 ; lower
                        
                        dec SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
.MyTankMoveUp           lda #SP_Ptr_Beach_02        ; my tank move up
                        sta BH_SpritePointer00_A    ; 
                        sta BH_SpritePointer00_B    ; 
                        
.Exit_1                 rts                         ; 
                        
.ChkDown                lda #CIA_Joy_Do             ; 
                        bit TabJoysticAction        ; 
                        beq .MyTankMoveLe           ; 
                        
                        jsr ClearDirInJoyAction     ; 
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$b8                    ; .hbu005. - interrupt timing problems if greater $b8
                        bcs .MyTankMoveLe           ; .hbu005. - force left if max PosY reached - greater/equal
                        
                        inc SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
.MyTankMoveDo           lda #SP_Ptr_Beach_03        ; my tank move down
                        sta BH_SpritePointer00_A    ; 
                        sta BH_SpritePointer00_B    ; 
                        
                        rts                         ; 
                        
.MyTankMoveLe           lda #SP_Ptr_Beach_01        ; my tank move left
                        sta BH_SpritePointer00_A    ; 
                        sta BH_SpritePointer00_B    ; 
                        
TankPlayerMovTankX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScrollTerrain     Does    : Scroll tank screen
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScrollTerrain       subroutine                  ; 
                        lda TabScrnTankBayScrollFin ; 
                        bne TankScrollTerrainX      ; TabScrnTankBayScrollFinNo   
                        
                        lda TabWaitFlagMoveLeRi     ; 
                        bne TankScrollTerrainX      ; TabWaitFlag_Yes
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveLeRi     ; 
                        
                        jsr TankScrollStrandSoft    ; 
                        
                        ldy #$07                    ; 
                        cpy TabTankScrollSoftPosX   ; 
                        bcs .SetVicScrollX          ; greater/equal
                        
                        jsr TankScrollStrandHard    ; 
                        
                        dec TabScrnTankScrollPos    ; 
                        dec TabScrnTankBayScrollDec ; 
                        dec TabScrnTankBayCharNext  ; 
                        bpl .NextScrollPosX         ; 
                        
                        ldx #TabScrnTankBayCharNextIni ; 
                        stx TabScrnTankBayCharNext  ; 
                        
.NextScrollPosX         lda TabTankScrollSoftPosX   ; 
                        sec                         ; 
                        sbc #$08                    ; 
                        sta TabTankScrollSoftPosX   ; 
                        
.SetVicScrollX          lda TabTankScrollSoftPosX   ; 
                        sta TabVicScrollSoftPosX    ; 
                        
                        lda #TabScrnTankBayScrollFinNo ; 
                        sta TabScrnTankBayScrollFin ; 
                        
TankScrollTerrainX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScrollStrandHard  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScrollStrandHard    subroutine                  ; 
                        ldx TabScrnTankScrollPos    ; 
                        jsr TankStrandAreaSetPtr    ; and work fields
                        
                        lda #TabScrnTankPosYSky     ; 
                        sta TabScrnTankPosY         ; 
                        
.SetNextScreenPtrs      ldx TabScrnTankPosY         ; 
                        jsr TankObstIniScrnInPtr    ; 
                        
                        ldx TabScrnTankPosY         ; 
                        jsr TankObstIniScrnOutPtr   ; 
                        
                        inc BLZ_ScrnRowPtrGfxOutLo  ; 
                        inc BLZ_ScrnRowPtrColoRamOutLo ; 
                        
                        ldy #TabScrnTankPosXMax     ; 38 = gfx screen max width
.ScrollGfxColoRam       lda (BLZ_ScrnRowPtrGfxIn),y ; 
                        sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
                        lda (BLZ_ScrnRowPtrColoRamIn),y ; 
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
                        dey                         ; 
                        bpl .ScrollGfxColoRam       ; 
                        
                        lda TabScrnTankBayCharNext  ; 
                        sta TabScrnTankBayCharPtr   ; 
                        
                        lda #$00                    ; 
                        sta TabScrnTankPosX         ; 
                        
                        dec BLZ_ScrnRowPtrGfxOutLo  ; 
                        dec BLZ_ScrnRowPtrColoRamOutLo ; 
                        jsr TankObstPaint           ; 
                        
                        inc TabScrnTankPosY         ; 
                        
                        lda #TabScrnTankPosYMax     ; gfx screen max height
                        cmp TabScrnTankPosY         ; 
                        bne .SetNextScreenPtrs      ; 
                        
                        jsr TankScreenFlipFlop      ; 
TankScrollStrandHardX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankObstIniScrnInPtr  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankObstIniScrnInPtr    subroutine                  ; 
                        lda TabScrnRowPtrLo,x       ; 
                        sta BLZ_ScrnRowPtrGfxInLo   ; 
                        sta BLZ_ScrnRowPtrColoRamInLo ; 
                        
                        lda TabTankActiveScreen     ; 
                        beq .ScreenB                ; screen B
                        
.ScreenA                lda TabScrnRowPtrGfxAHi,x   ; 
                        sta BLZ_ScrnRowPtrGfxInHi   ; 
                        
                        lda TabScrnRowPtrColoRamHi,x ; 
                        sta BLZ_ScrnRowPtrColoRamInHi ; 
                        
                        rts                         ; 
                        
.ScreenB                lda TabScrnRowPtrGfxBHi,x   ; 
                        sta BLZ_ScrnRowPtrGfxInHi   ; 
                        
                        lda TabScrnRowPtrColoRamHi,x ; 
                        sta BLZ_ScrnRowPtrColoRamInHi ; 
                        
TankObstIniScrnInPtrX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankObstIniScrnOutPtr Does    : 
;                       Expects : xr=TabScrnTankPosY        
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankObstIniScrnOutPtr   subroutine                  ; 
                        lda TabScrnRowPtrLo,x       ; 
                        sta BLZ_ScrnRowPtrGfxOutLo  ; 
                        sta BLZ_ScrnRowPtrColoRamOutLo ; 
                        
                        lda TabTankActiveScreen     ; 
                        beq .ScreenA                ; 
                        
.ScreenB                lda TabScrnRowPtrGfxBHi,x   ; 
                        sta BLZ_ScrnRowPtrGfxOutHi  ; 
                        
                        lda TabScrnRowPtrSaveHi,x   ; 
                        sta BLZ_ScrnRowPtrColoRamOutHi ; 
                        
.Exit                   rts                         ; 
                        
.ScreenA                lda TabScrnRowPtrGfxAHi,x   ; 
                        sta BLZ_ScrnRowPtrGfxOutHi  ; 
                        
                        lda TabScrnRowPtrSaveHi,x   ; 
                        sta BLZ_ScrnRowPtrColoRamOutHi ; 
                        
TankObstIniScrnOutPtrX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScreenFlipFlop    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScreenFlipFlop      subroutine                  ; 
                        sei                         ; 
                        
                        lda TabTankActiveScreen     ; 
                        beq .SetScreenA             ; 
                        
.SetScreenB             lda TabVicMemControlSetB    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$00                    ; 
                        bpl .SetActiveScreenFlag    ; 
                        
.SetScreenA             lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$01                    ; 
.SetActiveScreenFlag    sta TabTankActiveScreen     ; 
                        
                        lda #TabScreenTankColorYes  ; 
                        sta TabScreenTankColorFlag  ; 
                        
                        cli                         ; 
TankScreenFlipFlopX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankScrollStrandSoft  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankScrollStrandSoft    subroutine                  ; 
                        ldy #$06                    ; 
                        ldx #$01                    ; 
                        lda TabTankSprtScrollSpeed  ; speed
.FillTabSpriteAdapt     sta TabTankAdaptPosX,x      ; 
                        
                        inx                         ; 
                        dey                         ; 
                        bpl .FillTabSpriteAdapt     ; 
                        
                        lda TabTankScrollSoftPosX   ; 
                        clc                         ; 
                        adc TabTankSprtScrollSpeed  ; speed
                        sta TabTankScrollSoftPosX   ; 
                        
TankScrollStrandSoftX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankStrandAreaSetPtr  Does    : Init obstacle data area pointer and work fields
;                       Expects : xr=offset to data pointers
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankStrandAreaSetPtr    subroutine                  ; 
                        lda TabTankScrollAreaPtrHi,x; 
                        bne .SetDataPtr             ; 
                        
.ClrDataPtr             sta BLZ_TankObstDataPtrHi   ; $00
                        
                        rts                         ; 
                        
.SetDataPtr             sta BLZ_TankObstDataPtrHi   ; 
                        
                        lda TabTankScrollAreaPtrLo,x; 
                        sta BLZ_TankObstDataPtrLo   ; 
                        
                        ldy #$00                    ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta TabTankObstPosY         ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta TabTankObstChrNum       ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta TabTankObstColor        ; 
                        sty TabTankObstOffNext      ; point to next data pointers
                        
TankStrandAreaSetPtrX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankObstPaint         Does    : 
;                       Expects : xr=TabScrnTankPosY        
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankObstPaint           subroutine                  ; 
                        lda BLZ_TankObstDataPtrHi   ; 
                        beq .ChkSkyMax              ; 
                        
                        cpx TabTankObstPosY         ; 
                        bne .ChkSkyMax              ; 
                        
                        ldy TabScrnTankPosX         ; 
                        lda TabTankObstChrNum       ; 
.Obstacle               sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
                        lda TabTankObstColor        ; 
.ObstacleColor          sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        
.ChkEndOfData           and #$80                    ; #....... - flag: end of data
                        beq .GetNextDataAreaSet     ; not set
                        
                        lda #$00                    ; done
                        sta TabTankObstPosY         ; 
                        
                        rts                         ; 
                        
.GetNextDataAreaSet     ldy TabTankObstOffNext      ; point to next data pointers
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta TabTankObstPosY         ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta TabTankObstChrNum       ; 
                        
                        iny                         ; 
                        lda (BLZ_TankObstDataPtr),y ; 
                        sta TabTankObstColor        ; 
                        
                        sty TabTankObstOffNext      ; point to next data pointers
                        
                        rts                         ; 
                        
.ChkSkyMax              cpx #TabScrnTankPosYTreeTop ; 
                        bcs .ChkTreeTop             ; greater/equal
                        
.SetSky                 lda #$01                    ; lower is sky
                        pha                         ; 
                        lda #CYAN                   ; 
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeTop             bne .ChkTreeLeaf            ; greater
                        
.SetTreeTop             lda TabScrnTankBayCharPtr   ; equal is tree top
                        clc                         ; 
                        adc #$02                    ; 
                        pha                         ; 
                        lda #[COLORAM_MCM_On | CYAN]; ....#.## - sky over tree tops
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeLeaf            cpx #TabScrnTankPosYTreeLeaf;
                        bne .ChkTreeTwigs           ; 
                        
.SetTreeLeaf            lda #$01                    ; BayShoreChar01
                        pha                         ; 
                        lda #GREEN                  ; 
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeTwigs           cpx #TabScrnTankPosYTreeTwig;
                        bne .ChkTreeTrunk           ; 
                        
.SetTreeTwigs           lda TabTankScrollAreaTabPtr ; 
                        cmp #$f7                    ; 
                        bcc .GetBayCharPtrTwig      ; 
                        
                        lda #$00                    ; strand
                        jmp .SetBayCharPtr          ; 
                        
.GetBayCharPtrTwig      lda TabScrnTankBayCharPtr   ; 
                        clc                         ; 
                        adc #$0b                    ; 
.SetBayCharPtr          pha                         ; 
                        lda #[COLORAM_MCM_On | BLACK] ; ....#... - tree trunks
                        pha                         ; 
                        jmp .PaintObjWithColor      ; 
                        
.ChkTreeTrunk           cpx #TabScrnTankPosYTreeTrunk ; 
                        bne .SetStrand              ; 
                        
.SetTreeTrunk           lda TabTankScrollAreaTabPtr ; 
                        cmp #$f7                    ; 
                        bcc .GetBayCharPtrTrunk     ; lower
                        
                        lda #$00                    ; 
                        jmp .SetBayCharPtr          ; 
                        
.GetBayCharPtrTrunk     lda TabScrnTankBayCharPtr   ; 
                        clc                         ; 
                        adc #$14                    ; 
                        jmp .SetBayCharPtr          ; 
                        
.SetStrand              lda #$00                    ; strand
                        pha                         ; 
                        lda #GREEN                  ; 
                        pha                         ; 
                        
.PaintObjWithColor      ldy TabScrnTankPosX         ; 
                        pla                         ; 
                        sta (BLZ_ScrnRowPtrColoRamOut),y ; 
                        pla                         ; 
                        sta (BLZ_ScrnRowPtrGfxOut),y; 
                        
TankObstPaintX          rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
TankScreenShowStart     subroutine                  ; 
                        lda #$00                    ; 
                        sta TabScrnTankPosX         ; 
                        sta TabScrnTankBayCharPtr   ; 
                        
.IniActualPosY          lda #TabScrnTankPosYSky     ; 
                        sta TabScrnTankPosY         ; 
                        
                        ldx TabTankScrollAreaTabPtr ; 
                        jsr TankStrandAreaSetPtr    ; and work fields
                        
.PaintScrnPartAtPosY    ldx TabScrnTankPosY         ; 
                        jsr TankObstIniScrnOutPtr   ; 
                        jsr TankObstPaint           ; 
                        
                        inc TabScrnTankPosY         ; 
                        
                        lda #TabScrnTankPosYMax     ; 
                        cmp TabScrnTankPosY         ; 
                        bne .PaintScrnPartAtPosY    ; 
                        
                        inc TabScrnTankBayCharPtr   ; 
                        
                        lda #$09                    ; 
                        cmp TabScrnTankBayCharPtr   ; 
                        bne .SetNextAreaPosX        ; 
                        
                        lda #$00                    ; 
                        sta TabScrnTankBayCharPtr   ; 
                        
.SetNextAreaPosX        inc TabTankScrollAreaTabPtr ; 
                        inc TabScrnTankPosX         ; 
                        
                        lda #TabScrnGfxActualMaxX   ; 
                        cmp TabScrnTankPosX         ; 
                        bne .IniActualPosY          ; 
                        
                        jsr TankScreenFlipFlop      ; 
                        
TankScreenShowStartX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankAdaptSfxWithPosY  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankAdaptSfxWithPosY    subroutine                  ; 
                        lda TabWaitFlagSfx          ; 
                        beq .Adapt                  ; TabWaitFlag_No
                        
                        rts                         ; 
                        
.Adapt                  inc TabWaitFlagSfx          ; TabWaitFlag_Yes
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc #$68                    ; 
                        asl a                       ; 
                        sta FRELO2                  ; SID($D407) Oscillator 2 Freq Ctrl (low byte)
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        
TankAdaptSfxWithPosYX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankSfxShot           Does    :  
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankSfxShot             subroutine                  ; 
                        lda TabWaitFlagSfxShot      ; 
                        beq .Shot                   ; TabWaitFlag_No
                        
                        rts                         ; 
                        
.Shot                   jsr ResetVoc3               ; 
                        
                        lda #$0a                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$14                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        lda #$0a                    ; 
                        sta TabPlaySfxVoc1_06       ; 
                        
                        inc TabWaitFlagSfxShot      ; TabWaitFlag_Yes
                        
TankSfxShotX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankSfxHit            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankSfxHit              subroutine                  ; 
                        jsr ResetVoc3               ; 
                        
                        lda #$0c                    ; 
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        lda #$0a                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        lda #$81                    ; 
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        lda #$3c                    ; 
                        sta TabPlaySfxVoc1_06       ; 
                        
                        inc TabWaitFlagSfxShot      ; TabWaitFlag_Yes
                        
TankSfxHitX             rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosCannon    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosCannon      subroutine                  ; 
                        ldx #$00                    ; 
.GetNextCannonPos       lda TabBeachPosCannon,x     ; enemy: cannon
                        bne .ChkScrollPos           ; 
                        
.EndOfTable             rts                         ; $00
                        
.ChkScrollPos           cmp TabScrnTankScrollPos    ; 
                        beq .IniCannon              ; 
                        
.SetNextPair            inx                         ; 
                        inx                         ; 
                        jmp .GetNextCannonPos       ; 
                        
.IniCannon              inx                         ; point to PosY
                        lda TabBeachPosCannon,x     ; enemy:  cannon
                        ldy #BH_SprtColorBeachCannon;         color
                        ldx #BH_BeachSprtNoCannon   ;         sprite number
                        jsr TankInitEnemies         ; 
                        
TankCheckPosCannonX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosTank      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosTank        subroutine                  ; 
                        ldx #$00                    ; 
.GetNextEneTankPos      lda TabBeachPosTank,x       ; enemy: tank
                        bne .ChkScrollPos           ; 
                        
.EndOfTable             rts                         ; $00
                        
.ChkScrollPos           cmp TabScrnTankScrollPos    ; 
                        beq .IniEneTank             ; 
                        
.SetNextPair            inx                         ; check next pair
                        inx                         ; 
                        jmp .GetNextEneTankPos      ; 
                        
.IniEneTank             inx                         ; point to PosY
                        lda TabBeachPosTank,x       ; enemy:  tank
                        ldy #BH_SprtColorBeachTankE ;         color
                        ldx #BH_BeachSprtNoTank     ;         sprite number
                        jsr TankInitEnemies         ; 
                        
TankCheckPosTankX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosMachGun   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosMachGun     subroutine                  ; 
                        ldx #$00                    ; 
.GetNextMacGunPosY      lda TabBeachPosGunner,x     ; enemy: machine gun
                        bne .ChkScrollPos           ; 
                        
.EndOfTable             rts                         ; $00
                        
.ChkScrollPos           cmp TabScrnTankScrollPos    ; 
                        beq .IniMaxGun              ; 
                        
.SetNextPair            inx                         ; 
                        inx                         ; 
                        jmp .GetNextMacGunPosY      ; 
                        
.IniMaxGun              inx                         ; point to PosY
                        lda TabBeachPosGunner,x     ; enemy:  machine gun
                        ldy #BH_SprtColorBeachMacGun;         color
                        ldx #BH_BeachSprtNoMacGun   ;         sprite number
                        jsr TankInitEnemies         ; 
                        
TankCheckPosMachGunX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankCheckPosTurret    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankCheckPosTurret      subroutine                  ; 
                        ldx #$00                    ; 
.GetNextTurretPosY      lda TabBeachPosTurret,x     ; enemy: turret
                        bne .ChkScrollPos           ; 
                        
.EndOfTable             rts                         ; $00
                        
.ChkScrollPos           cmp TabScrnTankScrollPos    ; 
                        beq .IniTurret              ; 
                        
.SetNextPair            inx                         ; 
                        inx                         ; 
                        jmp .GetNextTurretPosY      ; 
                        
.IniTurret              inx                         ; point to PosY
                        lda TabBeachPosTurret,x     ; enemy:  turret
                        ldy #BH_SprtColorBeachTurret;         color
                        ldx #BH_BeachSprtNoTurret   ;         sprite number
                        jsr TankInitEnemies         ; 
                        
TankCheckPosTurretX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitEnemies       Does    : 
;                       Expects : enemy sprite values: ac=PosY xr=sprt_no yr=sprt_color
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitEnemies         subroutine                  ; 
                        pha                         ; save PosY
                        
                        lda TabWaitFlagUpDo         ; 
                        beq .SetWaitFlag            ; TabWaitFlag_No
                        
.Exit                   pla                         ; remove PosY
                        rts                         ; 
                        
.SetWaitFlag            inc TabWaitFlagUpDo         ; TabWaitFlag_Yes
                        
.SetColor               tya                         ; arise oh spirit
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
.SetPosY                pla                         ; restore PosY
                        sta SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        
.IniPosX                lda #$00                    ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        txa                         ; 
                        clc                         ; 
                        adc #SP_Ptr_Beach_03        ; my tank move down
                        sta BH_SpritePointers_A,x   ; 
                        sta BH_SpritePointers_B,x   ; 
                        
                        jsr SetAcToXrTimesMult2     ; 
                        ora SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        jsr SetAcToXrTimesMult2     ; 
                        eor #$ff                    ; ########
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #TabSpriteStatusUsed    ; 
                        sta TabSpriteStatus,x       ; 
                        
                        jsr SpritesEnableNoFromXr   ; 
TankInitEnemiesX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyMovTank      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyMovTank        subroutine                  ; 
                        lda TabSpriteStatus_04      ; 
                        bne .CopyPlayerPosY         ; 
                        
                        rts                         ; 
                        
.CopyPlayerPosY         lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
TankEnemyMovTankX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerCheckShoots Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerCheckShoots   subroutine                  ; 
                        lda #$01                    ; .......#
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .ChkMinPosX             ; 
                        
.ChkWaitTime            lda TabWaitFlagLeRi         ; 
                        beq .SetWaitTime            ; TabWaitFlag_No
                        
.Exit                   rts                         ; 
                        
.SetWaitTime            inc TabWaitFlagLeRi         ; TabWaitFlag_Yes
                        inc SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        bne .Exit                   ; 
                        
                        lda #$01                    ; .......#
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        rts                         ; 
                        
.ChkMinPosX             lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$20                    ; 
                        bcc .ChkWaitTime            ; lower
                        
TankPlayerCheckShootsX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyShoot        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyShoot          subroutine                  ; 
                        lda TabWaitTankEneShoot     ; 
                        beq .ChkActiveShot          ; TabWaitTankEneShootNo
                        
                        rts                         ; 
                        
.ChkActiveShot          lda TabTankShotSprtNoSav    ; 
                        beq .IniNextSprite          ; inactive
                        
                        tax                         ; active
                        jmp .IniEneTankShot         ; 
                        
.IniNextSprite          ldx #$03                    ; 
.GetNextSprite          lda TabSpriteStatus,x       ; 
                        beq .SetNextSprite          ; 
                        
                        jsr SetAcToXrTimesMult2     ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .SetNextSprite          ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
.GetPosY                lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
__BeachTankSkillShoot   equ * + $01                 ; skill level adaptations
.ChkSkill               cmp #$40                    ; min
                        bcc .SetNextSprite          ; lower
                        
                        cmp #$d8                    ; max
                        bcc .IniEneTankShot         ; lower
                        
.SetNextSprite          inx                         ; 
                        cpx #$07                    ; 
                        bne .GetNextSprite          ; 
                        
                        rts                         ; 
                        
.IniEneTankShot         lda #SP_Ptr_Beach_05        ; enemy tank
                        sta BH_SpritePointer02_A    ; 
                        sta BH_SpritePointer02_B    ; 
                        
                        lda #$fb                    ; #####.##
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$fb                    ; #####.##
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #BH_SprtColorBeachTankShotE ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc #$06                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
                        lda #TabSpriteStatusUsed    ; 
                        sta TabSpriteStatus_02      ; 
                        sta TabWaitTankEneShoot     ; TabWaitTankEneShootYes
                        
.SetActiveShot          stx TabTankShotSprtNoSav    ; 
                        
                        ldx #$02                    ; ......#.
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$01                    ; 
                        sta TabWaitTimeHillShotSavE ; 
                        sta TabWaitTimeHillShotE    ; 
                        
                        jsr TankSfxShot             ; 
TankEnemyShootX         rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyMovShot      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyMovShot        subroutine                  ; 
                        lda TabSpriteStatus_02      ; 
                        bne .ChkWaitTime            ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkWaitTime            lda TabWaitFlagAutoAction   ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagAutoAction   ; 
                        
                        lda #$04                    ; .....#..
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .AdaptShotPosX          ; 
                        
                        lda SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$58                    ; 
                        bcc .AdaptShotPosX          ; 
                        
.ClrShot                lda #$00                    ; 
                        sta TabSpriteStatus_02      ; TabSpriteStatusFree
                        sta TabWaitTankEneShoot     ; TabWaitTankEneShootNo
                        
                        ldx #$02                    ; ......#.
                        jsr SpritesDisableNoFromXr  ; 
                        
                        rts                         ; 
                        
.AdaptShotPosX          lda TabTankAdaptPosX_02     ; 
                        clc                         ; 
                        adc TabTankShotSpeedEne     ; 
                        sta TabTankAdaptPosX_02     ; 
                        
TankEnemyMovShotX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerShoot       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerShoot         subroutine                  ; 
                        lda #CIA_Joy_Fi             ; 
                        bit TabJoysticAction        ; 
                        bne .ClrShot                ; 
                        
.Exit                   rts                         ; 

.ClrShot                jsr ClearDirInJoyAction     ; 
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$20                    ; 
                        bne .Exit                   ; 
                        
.ChkShotStatus          lda TabSpriteStatus_01      ; 
                        bne .Exit                   ; TabSpriteStatusUsed
                        
                        lda #SP_Ptr_Beach_04        ; shot left
                        sta BH_SpritePointer01_A    ; 
                        sta BH_SpritePointer01_B    ; 
                        
                        lda #$fd                    ; ######.#
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #BH_SprtColorBeachTankShot ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sec                         ; 
                        sbc #$06                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #$02                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        ldx #$01                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$01                    ; 
                        sta TabWaitTimeTankShotSav  ; 
                        sta TabWaitTimeTankShot     ; 
                        sta TabSpriteStatus_01      ; TabSpriteStatusUsed
                        
                        jsr TankSfxShot             ; 
                        jsr PlayerAmmoDec           ; 
                        
TankPlayerShootX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerMovShot     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerMovShot       subroutine                  ; 
                        lda TabSpriteStatus_01      ; 
                        bne .ChkWaitTime            ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkWaitTime            lda TabWaitFlagMoveEnemy    ; 
                        bne .Exit                   ; 
                        
                        inc TabWaitFlagMoveEnemy    ; TabWaitFlag_Yes
                        
                        lda #$02                    ; ......#.
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        bne .MoveShotForward        ; 
                        
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
.MaxRange               cmp #$50                    ; .hbu007. - was $30
                        bcs .MoveShotForward        ; 
                        
                        lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus_01      ; 
                        
                        ldx #$01                    ; 
                        jsr SpritesDisableNoFromXr  ; 
                        
                        rts                         ; 
                        
.MoveShotForward        lda TabTankAdaptPosX_01     ; 
                        sec                         ; 
                        sbc TabTankShotSpeed        ; 
                        sta TabTankAdaptPosX_01     ; 
                        
TankPlayerMovShotX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerHitCheck    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerHitCheck      subroutine                  ; 
                        lda TabSpriteStatus_02      ; 
                        bne .ChkHit                 ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkHit                 lda #$05                    ; .....#.#
                        and TabSprtSprtCollReg      ; 
                        cmp #$05                    ; 
                        bne .Exit                   ; 
                        
                        ldx #$02                    ; ......#.
                        jsr SpritesDisableNoFromXr  ; 
; ------------------------------------------------- ;
TankPlayerHit           subroutine                  ; 
                        jsr TankSfxHit              ; 
                        jsr TankPlayerExplode       ; 
; ------------------------------------------------- ;
TankCheckLives          subroutine                  ; 
                        dec TabPlayerTanksLeft      ; 
                        beq .StatusGameOverPlayer_  ; 
                        
                        lda TabGameMode             ; 
                        bne .WasDemo                ; TabGameModeDemo or TabGameModeExit
                        
                        jsr SwitchPlayerAndValues   ; 
                        
                        lda #$01                    ; 
                        sta TabWaitTimeBeachLeRiSav ; 
                        
                        lda #"0"                    ; .hbu016. - restart beach levels at strand
                        sta TabStrandFileNam_1      ; .hbu016.
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp Chapter_TanksOnBeach    ; --> BeachLevels - Restart chapter
                        
.WasDemo                jsr ResetTOD2               ; 
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp Chapter_StormTheHill    ; --> BeachLevels - Start next demo chapter
                        
.StatusGameOverPlayer_  jsr ScreenStatusGameOver    ; 
                        
                        lda #TabShowScoresNo        ; 
; ------------------------------------------------- ;
TankCheckGameOver       subroutine                  ; 
                        lda #$01                    ; 
                        sta TabPlayerShowScores     ; 
                        
                        ldx TabPlayerActive         ; 
                        lda #$00                    ; 
                        sta TabPlayerShowScore,x    ; 
                        jsr SwitchPlayerAndValues   ; 
                        
                        dec TabPlayerInGame         ; 
.GameOver               beq TankPlayerHitCheckX     ; 
                        
.Continue               pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp Chapter_TanksOnBeach    ; --> BeachLevels - Restart chapter
                        
TankPlayerHitCheckX     jmp GameOver_Rts_Two        ; Game over - back to BASIC via GameStart
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerExplode     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerExplode       subroutine                  ; 
                        lda #$fe                    ; #######.
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #BH_SprtColorTankExplode; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #WHITE                  ; .hbu004.
                        sta TabBackGroundColor      ; .hbu004.
                        
                        ldx #$08                    ; .hbu004.
.FlashIni               ldy #$60                    ; .hbu004.
.Flash                  dey                         ; .hbu004.
                        bne .Flash                  ; .hbu004.
                        
                        dex                         ; .hbu004.
                        bne .FlashIni               ; .hbu004.
                        
;.Flash                  lda BGCOL0                  ; .hbu004. - VIC($D021) Background Color 0
;                        and #$0f                    ; .hbu004 - .....####
;                        cmp #LT_GREY                ; .hbu004.
;                        beq .Flash                  ; .hbu004. - still LT_GREY
                        
                        lda #YELLOW ; LT_GREY       ; .hbu004.
                        sta TabBackGroundColor      ; .hbu004.
                        
                        lda #$02                    ; .hbu004.
                        sta TabWaitTimeTOD_10th     ; .hbu004.

                        lda #SP_Ptr_Beach_00        ; .hbu004. - explosion phase 1
                        sta BH_SpritePointer00_A    ; .hbu004.
                        sta BH_SpritePointer00_B    ; .hbu004.
                        
                        jsr WaitTOD1_10th           ; .hbu004.
                        
                        lda #SP_Ptr_Beach_0f        ; .hbu004. - explosion phase 2
                        sta BH_SpritePointer00_A    ; .hbu004.
                        sta BH_SpritePointer00_B    ; .hbu004.
                        
                        jsr WaitTOD1_10th           ; .hbu004.
                        
                        lda #SP_Ptr_Beach_10        ; .hbu004. - explosion phase 3
                        sta BH_SpritePointer00_A    ; .hbu004.
                        sta BH_SpritePointer00_B    ; .hbu004.
                        
                        jsr WaitTOD1_10th           ; .hbu004.
                        
                        ldx #$00                    ; .hbu004.
                        jsr SpritesDisableNoFromXr  ; .hbu004.
                        
                        lda #$09                    ; .hbu004.
                        sta TabWaitTimeTOD_10th     ; .hbu004.
                        jsr WaitTOD1_10th           ; .hbu004.
                        
TankPlayerExplodeX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyHitCheck     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyHitCheck       subroutine                  ; 
                        lda TabSpriteStatus_01      ; 
                        bne .ChkHit                 ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkHit                 lda #$02                    ; ......#.
                        bit TabSprtSprtCollReg      ; 
                        beq .Exit                   ; 
                        
                        lda TabTankScoreSpriteNo    ; .hbu006. - score only once
                        bne .Exit                   ; .hbu006.
                        
                        ldx #$03                    ; 
.GetNextSpriteOff       jsr SetAcToXrTimesMult2     ; 
                        bit TabSprtSprtCollReg      ; 
                        bne .ShotStatusReset        ; 
                        
                        inx                         ; 
                        cpx #$07                    ; 
                        bne .GetNextSpriteOff       ; 
                        
                        rts                         ; 
                        
.ShotStatusReset        dec TabSpriteStatus_01      ; TabSpriteStatusFree
                        
                        jsr TankSfxHit              ; 
                        
.ShotOff                lda #$fd                    ; ######.#
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        cpx TabTankShotSprtNoSav    ; 
                        bne .GetSpriteOff           ; 
                        
                        lda #$00                    ; 
                        sta TabTankShotSprtNoSav    ; 
                        
.GetSpriteOff           jsr SetAcToXrTimesMult2     ; 
                        eor #$ff                    ; ########
                        and SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$00                    ; BLACK/TabSpriteStatusFree
                        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        sta TabSpriteStatus,x       ; 
                        
                        lda #$3c                    ; 
                        sta TabWaitTimeBellsSav     ; 
                        sta TabWaitTimeBells        ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagPing         ; 
                        
.ScoreHits              stx TabTankScoreSpriteNo    ; 
                        
.ChkSpriteCannon        cpx #$03                    ; 
                        bne .ChkSpriteEneTank       ; 
                        
.ScoreSpriteCannon      jsr AddScore_800            ; 
                        lda #SP_Ptr_Beach_0d        ; score  800
                        jmp .SetScoreSpritePtrs     ; 
                        
.ChkSpriteEneTank       cpx #$04                    ; 
                        bne .ChkSpriteMacGun        ; 
                        
.ScoreSpriteEneTank     jsr AddScore_1000           ; 
                        lda #SP_Ptr_Beach_0e        ; score 1000
                        jmp .SetScoreSpritePtrs     ; 
                        
.ChkSpriteMacGun        cpx #$05                    ; 
                        bne .ScoreSpriteTurret      ; 
                        
.ScoreSpriteMacGun      jsr AddScore_400            ; 
                        lda #SP_Ptr_Beach_0b        ; score  400
                        jmp .SetScoreSpritePtrs     ; 
                        
.ScoreSpriteTurret      jsr AddScore_600            ; 
                        lda #SP_Ptr_Beach_0c        ; score  600
                        
.SetScoreSpritePtrs     sta BH_SpritePointers_A,x   ; 
                        sta BH_SpritePointers_B,x   ; 
                        
TankEnemyHitCheckX      rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankEnemyClrHitScore  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankEnemyClrHitScore    subroutine                  ; 
                        lda TabTankScoreSpriteNo    ; 
                        bne .ChkWait                ; 
                        
.Exit                   rts                         ; 
                        
.ChkWait                lda TabWaitFlagPing         ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        ldx TabTankScoreSpriteNo    ; 
                        
                        lda #$00                    ; 
                        sta TabTankScoreSpriteNo    ; 
                        
                        jsr SpritesDisableNoFromXr  ; 
TankEnemyClrHitScoreX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankAdaptSpritePosX   Does : Keep PosX despite beach scrolling
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankAdaptSpritePosX     subroutine                  ; 
                        ldx #$07                    ; 
.GetNextSprite          jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda TabTankAdaptPosX,x      ; 
                        bmi .Negative               ; 
                        
.Positive               lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc TabTankAdaptPosX,x      ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$00                    ; 
                        sta TabTankAdaptPosX,x      ; 
                        bcc .SetNextSprite          ; 
                        
.SetNewPosX_Msb         jsr SetAcToXrTimesMult2     ; 
                        eor MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        jmp .SetNextSprite          ; 
                        
.Negative               lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        clc                         ; 
                        adc TabTankAdaptPosX,x      ; 
                        sta SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$00                    ; 
                        sta TabTankAdaptPosX,x      ; 
                        bcc .SetNewPosX_Msb         ; 
                        
.SetNextSprite          dex                         ; 
                        bne .GetNextSprite          ; 
                        
TankAdaptSpritePosXX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankClearSpriteAtMaxX Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankClearSpriteAtMaxX   subroutine                  ; 
                        ldx #$06                    ; 
.ChkSpritePosX          jsr SetAcToXrTimesMult2     ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .MaxPosX                ; 
                        
                        jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
.MaxPosX_Msb            cmp #$58                    ; 
                        bcc .SetNextSpriteNo        ; 
                        
.ClrSprite              lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus,x       ; 
                        jsr SetAcToXrTimesMult2     ; 
                        
                        eor #$ff                    ; 
                        and SPENA                   ; VIC($D015) Sprite Enable Register
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        jmp .SetNextSpriteNo        ; 
                        
.MaxPosX                jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0X,y                  ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp #$e0                    ; 
                        bcc .SetNextSpriteNo        ; 
                        
                        cpx TabTankShotSprtNoSav    ; 
                        bne .SetNextSpriteNo        ; 
                        
                        lda #$00                    ; 
                        sta TabTankShotSprtNoSav    ; 
                        
.SetNextSpriteNo        dex                         ; 
                        cpx #$02                    ; 
                        bne .ChkSpritePosX          ; 
                        
TankClearSpriteAtMaxXX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankInitSfx           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankInitSfx             subroutine                  ; 
                        lda #$1e                    ; 
                        sta TabPlaySfxVoc2_01       ; 
                        
.GoAdaptSfx             jsr TankAdaptSfxWithPosY    ; 
                        
                        lda #$01                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        
                        lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        ldx TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp TabWaitTimeTOD_Sec      ; 
                        bne .GoAdaptSfx             ; 
                        
                        lda #$02                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        
TankInitSfxX            rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerChkCollBack Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerChkCollBack   subroutine                  ; 
                        lda SPBGCL                  ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        and #$01                    ; .......#
                        bne TankPlayerChkCollBackX  ; 
                        
                        rts                         ; 
                        
TankPlayerChkCollBackX  jmp TankPlayerHit           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankPlayerChkCollSprt Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankPlayerChkCollSprt   subroutine                  ; 
                        lda #$01                    ; 
                        bit TabSprtSprtCollReg      ; 
                        bne .IniNextSpriteGet       ; 
                        
                        rts                         ; 
                        
.IniNextSpriteGet       ldx #$03                    ; ......##
.GetNextSpriteOff       jsr SetAcToXrTimesMult2     ; 
                        bit TabSprtSprtCollReg      ; 
                        bne TankPlayerChkCollSprtX  ; collision
                        
                        inx                         ; 
                        cpx #$07                    ; 
                        bne .GetNextSpriteOff       ; 
                        
                        rts                         ; 
                        
TankPlayerChkCollSprtX  jmp TankPlayerHit           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TankDemo              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TankDemo                subroutine                  ; 
                        lda TabGameMode             ; 
                        bne .ChkDemoTime            ; TabGameModeDemo or TabGameModeExit
                        
                        rts                         ; 
                        
.ChkDemoTime            lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #BH_DemoTimeBeach       ; 
                        bcc .ChkDemoTimeMov_Do      ; 
                        
                        jsr ResetTOD2               ; 
                        
                        pla                         ; remove subroutines return address
                        pla                         ; 
                        jmp Chapter_StormTheHill    ; --> BeachLevels - Start next chapter
                        
.ChkDemoTimeMov_Do      cmp #$10                    ; 
                        bne .ChkDemoTimeMov_Up      ; 
                        
                        lda #CIA_Joy_Do             ; 
                        sta TabJoysticAction        ; 
                        jmp .ChkDemoTimeMov_Fi      ; 
                        
.ChkDemoTimeMov_Up      cmp #$18                    ; 
                        bne .ChkDemoTimeMov_Fi      ; 
                        
                        lda #CIA_Joy_Up             ; 
                        sta TabJoysticAction        ; 
                        
.ChkDemoTimeMov_Fi      lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$02                    ; 
                        bcc TankDemoX               ; lower
                        
                        lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
TankDemoX               rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Chapter_StormTheHill  Does    : Chapter: Storm the hill
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Chapter_StormTheHill    subroutine                  ; 
                        jsr ScreenStatusGetReady    ; .hbu013.
                        jsr StormTheHillInit        ; 
                        
.StormTheHill_Loop      jsr SpritesGetSprtCollReg   ; sprite/sprite collision
                        jsr SpritesGetBackCollReg   ; sprite/foregr collision
                        jsr HillCannonAutoTarget    ; target hill cannon to player
                        jsr HillCannonAutoFire      ; fire   hill cannon
                        jsr CannonPlayerMove        ; move player cannon
                        jsr HillCannonPlayerFire    ; fire player cannon
                        jsr HillCannonPlayerShotFly ; 
                        jsr HillCannonCheckHits     ; check target hits
                        jsr HillCannonPlayerShotExp ; target hit explode
                        jsr PlayerAmmoInc           ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr ScreenStatusShowDegree  ; 
                        jsr ScreenStatusShowTanks   ; 
                        jsr HillCannonPlayerExpClr  ; 
                        jsr CheckGamePause          ; on C= commodore key
                        jsr CheckGameFinished       ; Quit/Idle time/Death - 2 level return to BASIC via GameStart
                        jsr CheckGameIdleTime       ; 
                        jsr HillDemo                ; 
                        
Chapter_StormTheHillX   jmp .StormTheHill_Loop      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; StormTheHillInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
StormTheHillInit        subroutine                  ; 
                        jsr TabSpritesWaitsInits    ; 
                        
                        ldx #BH_ChapterStormTheHill ; .hbu013.
                        jsr LoadChapterData         ; .hbu013.
                        
                        lda #VIC_Cols40             ; ....#...
                        ora SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        sta SCROLX                  ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #$00                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #SP_Ptr_SeaShip_01      ; cannon shot phase  1 - max
                        sta TabPlrShootSprtBasePtr2 ; 
                        
                        lda #BLACK                  ; 
                        sta SP0COL                  ; VIC($D027) Color Sprite 0
                        
                        lda #$01                    ; .......#
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda TabVicMemControlSetA    ; 
                        sta TabVicMemControl        ; 
                        
                        lda #$01                    ; screen A
                        sta TabTankActiveScreen     ; 
                        
                        jsr HillCannonAutoPaint     ; paint hill cannon
                        jsr CannonSpritePosInit     ; 
                        
                        lda #$b5                    ; 
                        sta SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        jsr HillCannonNextTarget    ; set next hill target
                        
StormTheHillInitX       rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonAutoPaint   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonAutoPaint     subroutine                  ; 
                        lda #SP_Ptr_Hill_11         ; enemy cannon right step  1 - max left
                        sta BH_SpritePointer03_A    ; 
                        
                        lda #$90                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$42                    ; 
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda #$08                    ; 
                        ora XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        
                        lda #$00                    ; 
                        sta SP3COL                  ; VIC($D02A) Color Sprite 3
                        
                        lda #$10                    ; 
                        sta TabWaitBulletFlySav     ; 
                        
__HillCannonSkillWait   equ * + $01                 ; skill level adaptations
.GetSkill               lda #$ff                    ; 
.SetSkill               sta TabWaitBulletFly        ; 
                        
                        lda #TabPlaneDist_Ini       ; 
                        sta TabPlaneDistance        ; 
                        
                        lda #$01                    ; 
                        sta TabSpriteStatus_03      ; TabSpriteStatusUsed
                        sta TabWaitFlagBulletFly    ; TabWaitFlag_Yes
                        
                        ldx #$03                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
                        jsr ResetVoc1               ; 
                        lda #$02                    ; 
                        sta PWHI1                   ; SID($D403) Oscillator 1 Pulse Waveform Width (high nybble)
                        lda #$40                    ; 
                        sta SUREL1                  ; SID($D406) Oscillator 1 Sustain/Release
                        lda #$41                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
HillCannonAutoPaintX    rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonNextTarget  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonNextTarget    subroutine                  ; 
                        ldx TabPlayerHillTargsToHit ; 
                        dex                         ; 
                        
                        lda TabHillTargetsPosX,x    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda TabHillTargetsPosY,x    ; 
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda #$01                    ; 
                        sta SP4COL                  ; VIC($D02B) Color Sprite 4
                        
                        lda #SP_Ptr_Hill_27         ; hill target
                        sta BH_SpritePointer04_A    ; 
                        
                        ldx #$04                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
HillCannonNextTargetX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonAutoTarget  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonAutoTarget    subroutine                  ; 
                        lda TabSpriteStatus_03      ; 
                        bne .ChkBulletWaitTime      ; 
                        
.Exit                   rts                         ; 
                        
.ChkBulletWaitTime      lda TabWaitFlagBulletFly    ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagBulletFly    ; TabWaitFlag_Yes
                        
                        lda #$c8                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        lda #$02                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        
                        inc BH_SpritePointer03_A    ; 
                        
                        lda BH_SpritePointer03_A    ; 
                        cmp #SP_Ptr_Hill_1e         ; enemy cannon down step 1 - up max
                        bne .ChkHillTarget          ; 
                        
                        lda TabPlaneDistance        ; 
                        bne .Exit                   ; 
                        
                        inc TabPlaneDistance        ; 
                        dec BH_SpritePointer03_A    ; 
                        
                        lda #$00                    ; 
                        sta FRELO1                  ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        
                        lda #$28                    ; 
                        sta TabWaitBulletFly        ; 
                        
                        rts                         ; 
                        
.ChkHillTarget          cmp #SP_Ptr_Hill_27         ; hill target
                        bne .Exit                   ; 
                        
                        dec BH_SpritePointer03_A    ; 
                        
                        lda #$b0                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$43                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        
                        lda #BLACK                  ; 
                        sta SP2COL                  ; VIC($D029) Color Sprite 2
                        
                        lda #TabSpriteStatusFree    ; 
                        sta TabSpriteStatus_03      ; 
                        
                        lda #$01                    ; 
                        sta TabSpriteStatus_02      ; TabSpriteStatusUsed
                        sta TabWaitFlagAutoAction   ; TabWaitFlag_Yes
                        
                        lda #$02                    ; 
                        sta TabWaitHillCannonAimSav ; 
                        sta TabWaitHillCannonAim    ; 
                        
                        jsr ResetVoc1               ; 
                        jsr ResetVoc3               ; 
                        
                        lda TabFilterCutHi          ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        
                        lda #$06                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        
                        lda #$0d                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        
                        lda #SP_Ptr_Hill_45         ; enemy bullet phase 1 - min
                        sta BH_SpritePointer02_A    ; 
                        
                        ldx #$02                    ; 
                        jsr SpritesEnableNoFromXr   ; 
HillCannonAutoTargetX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonAutoFire    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonAutoFire      subroutine                  ; 
                        lda TabSpriteStatus_02      ; 
                        bne .ChkWaitAutoAction      ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkWaitAutoAction      lda TabWaitFlagAutoAction   ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        inc TabWaitFlagAutoAction   ; TabWaitFlag_Yes
                        
                        lda BH_SpritePointer02_A    ; 
                        cmp #SP_Ptr_Hill_4d         ; enemy bullet phase 9 - max
                        beq .HillTankHit            ; 
                        
                        inc BH_SpritePointer02_A    ; 
                        
                        rts                         ; 
                        
.HillTankHit            lda #VIC_Sprts_Off          ; and BLACK
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
.LightsOut              sta BGCOL0                  ; VIC($D021) Background Color 0
                        
                        jsr ClearGfxScreen          ; 
                        
.ShowTime               lda #$02                    ; 
                        sta TabWaitTimeTOD_Sec      ; 
                        jsr WaitTOD1_Sec            ; 
                        
.NextTank               pla                         ; remove subroutines return address
                        pla                         ; 
HillCannonAutoFireX     jsr TankCheckLives          ; never come back
;HillCannonAutoFireX     jmp TankInitDefaults        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonPlayerFire  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonPlayerFire    subroutine                  ; 
                        lda #CIA_Joy_Fi             ; 
                        bit TabJoysticAction        ; 
                        bne .ClrJoyStickAction      ; 
                        
.Exit                   rts                         ; 
                        
.ClrJoyStickAction      jsr ClearDirInJoyAction     ; 
                        
                        lda TabSpriteStatus_01      ; 
                        bne .Exit                   ; TabSpriteStatusUsed
                        
                        lda #SP_Ptr_Hill_55         ; my bullet phase 8 - max
                        sta BH_SpritePointer01_A    ; 
                        
                        lda #BH_SprtColorHillMyShot ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP0Y                    ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        sec                         ; 
                        sbc TabCannonShotDegree     ; 
                        sta TabBulletHight          ; 
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$fd                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        lda #$01                    ; 
                        and MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        asl a                       ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        inc TabSpriteStatus_01      ; TabSpriteStatusUsed
                        
                        ldx #$01                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        jsr SetVoc2_Cannon          ; 
                        jsr PlayerAmmoDec           ; 
                        
                        lda #$01                    ; 
                        sta TabWaitTimeHillShotSav  ; 
                        sta TabWaitTimeHillShot     ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveEnemy    ; 
                        
                        lda #$00                    ; 
                        sta TabSpriteStepCount      ; 
                        
HillCannonPlayerFireX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonPlayerShotFly Does  : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonPlayerShotFly subroutine                  ; 
                        lda TabSpriteStatus_01      ; 
                        bne .ChkWaitMove            ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkWaitMove            lda TabWaitFlagMoveEnemy    ; 
                        bne .Exit                   ; 
                        
                        inc TabWaitFlagMoveEnemy    ; TabWaitFlag_Yes
                        inc TabSpriteStepCount      ; 
                        
                        lda TabSpriteStepCount      ; 
                        cmp #$2e                    ; 
                        bne .BulletSprtPtr          ; 
                        
                        ldx #$01                    ; .......#
                        jsr SpritesDisableNoFromXr  ; 
                        
                        dec TabSpriteStatus_01      ; TabSpriteStatusFree
                        rts                         ; 
                        
.BulletSprtPtr          lda BH_SpritePointer01_A    ; 
                        cmp #SP_Ptr_Hill_4e         ; my bullet phase 1 - min
                        beq .BulletFly              ; 
                        
                        lda TabSpriteStepCount      ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        sta TabTempStore            ; 
                        
                        lda #SP_Ptr_Hill_55         ; my bullet phase 8 - max
                        sec                         ; 
                        sbc TabTempStore            ; 
                        sta BH_SpritePointer01_A    ; 
                        
.BulletFly              lda TabBulletHight          ; 
                        lsr a                       ; 
                        lsr a                       ; 
                        sta TabWrkPlayerShot        ; 
                        
                        lda TabBulletHight          ; 
                        sec                         ; 
                        sbc TabWrkPlayerShot        ; 
                        sta TabBulletHight          ; 
                        
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sec                         ; 
                        sbc TabWrkPlayerShot        ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
HillCannonPlayerShotFlyX rts                        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonCheckHits   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonCheckHits     subroutine                  ; 
                        lda TabSpriteStatus_01      ; 
                        bne .ChkSprtSprtColl        ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkSprtSprtColl        lda #$02                    ; ......#.
                        bit TabSprtSprtCollReg      ; 
                        beq .Exit                   ; 
                        
                        lda #$10                    ; ...#....
                        bit TabSprtSprtCollReg      ; 
                        beq .Exit                   ; 
                        
                        lda TabSpriteStepCount      ; 
                        cmp #$19                    ; 
                        bcc .Exit                   ; 
                        
                        ldx #$01                    ; .......#
                        jsr SpritesDisableNoFromXr  ; 
                        
                        dec TabSpriteStatus_01      ; TabSpriteStatusFree
                        
.Score                  jsr AddScore_2000           ; 
                        
                        dec TabPlayerHillTargsToHit ; 
                        beq .GetAmount              ; victory
                        
                        jsr SetVoc3_Cannon          ; 
                        jsr HillCannonNextTarget    ; set next hill target
                        rts                         ; 
                        
.GetAmount              ldx TabPlayerSkillLevel     ; bonus depends on skill level
.ScoreLoop              jsr AddScore_9000           ; 
                        jsr AddScore_1000           ; 
                        
                        dex                         ; 
                        bpl .ScoreLoop              ; 
                        
                        jsr ScreenStatusShowScore   ; 
                        jsr HillCannonCapExplode    ; 
                        jsr HillCannonWaveFlag      ; 
                        jsr HillCannonReduceCount   ; .hbu026. - bonus
                        
HillCannonCheckHitsX    jmp TankCheckGameOver       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonPlayerShotExp Does  : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonPlayerShotExp subroutine                  ; 
                        lda TabSpriteStatus_01      ; 
                        bne .ChkFlyDist             ; TabSpriteStatusUsed
                        
.Exit                   rts                         ; 
                        
.ChkFlyDist             lda TabSpriteStepCount      ; 
                        cmp #$1e                    ; 
                        bcc .Exit                   ; 
                        
                        lda #SP_Ptr_Hill_28         ; explosion hill target hit
                        sta BH_SpritePointer07_A    ; 
                        
                        lda #BH_SprtColorHillHitExplode ; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        
                        lda SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        lda MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        and #$7f                    ; 
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
                        and #$01                    ; 
                        beq .SfxExplode             ; 
                        
                        lda #$80                    ; 
                        ora MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.SfxExplode             jsr SetVoc3_Cannon          ; 
                        
                        lda #$01                    ; 
                        sta TabTargetHit            ; TabTargetHitYes
                        sta TabWaitFlagTargetHit    ; 
                        
                        ldx #$07                    ; .....###
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #$10                    ; 
                        sta TabWaitHillExplode      ; 
                        
                        dec TabSpriteStatus_01      ; TabSpriteStatusFree
                        
                        ldx #$01                    ; .......#
                        jsr SpritesDisableNoFromXr  ; 
HillCannonPlayerShotExpX rts                        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonPlayerExpClr Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonPlayerExpClr  subroutine                  ; 
                        lda TabTargetHit            ; 
                        bne .ChkWaitHit             ; TabTargetHitYes
                        
.Exit                   rts                         ; 
                        
.ChkWaitHit             lda TabWaitFlagTargetHit    ; 
                        bne .Exit                   ; TabWaitFlag_Yes
                        
                        dec TabTargetHit            ; TabTargetHitNo
                        
                        ldx #$07                    ; .....###
                        jsr SpritesDisableNoFromXr  ; 
HillCannonPlayerExpClrX rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonReduceCount Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonReduceCount   subroutine                  ; .hbu026.
.DecTanks               dec TabPlayerTanksLeft      ; 
                        bmi HillCannonReduceCountX  ; 
                        
                        jsr ScreenStatusShowTanks   ; 
                        
                        lda #$14                    ; 
                        sta TabTempStore            ; 
                        
.GoResetTOD1            jsr ResetTOD1               ; 
                        
.GetTOD1_10th           lda TODTEN                  ; CIA1($DC08) Time of Day Clock Tenths
                        cmp #$01                    ; 
                        bcc .GetTOD1_10th           ; lower
                        
                        jsr AddScore_100            ; 
                        jsr ScreenStatusShowScore   ; 
                        jsr ResetVoc1               ; 
                        jsr ResetVoc2               ; 
                        jsr ResetVoc3               ; 
                        
                        lda #$ff                    ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        lda #$3a                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$07                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        
                        dec TabTempStore            ; 
                        bne .GoResetTOD1            ; 
                        beq .DecTanks               ; 
                        
HillCannonReduceCountX  rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonCapExplode  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonCapExplode    subroutine                  ; 
                        lda #$00                    ; 
                        sta XXPAND                  ; VIC($D01D) Sprite Double Height
                        sta YXPAND                  ; VIC($D017) Sprite Scale Double Width
                        sta MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        ldx #$02                    ; 
.CreSpritePtrs          txa                         ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        asl a                       ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #SP_Ptr_Hill_2a         ; explosion hill cap piece  1
                        sta BH_SpritePointers_A,x   ; 
                        inx                         ; 
                        cpx #$07                    ; 
                        bne .CreSpritePtrs          ; 
                        
                        lda #SP_Ptr_Hill_29         ; explosion hill cap 1
                        sta BH_SpritePointer07_A    ; 
                        
                        lda #$42                    ; 
                        sta SP2Y                    ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sta SP3Y                    ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        sta SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        lda #$4a                    ; 
                        sta SP5Y                    ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        sta SP6Y                    ; VIC($D00D) Sprite 6 Y-Pos (Bits 0-7)
                        
                        lda #$a8                    ; 
                        sta SP2X                    ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP5X                    ; VIC($D00A) Sprite 5 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$b0                    ; 
                        sta SP3X                    ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP7X                    ; VIC($D00E) Sprite 7 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda #$b8                    ; 
                        sta SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP6X                    ; VIC($D00C) Sprite 6 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        ldx #$02                    ; 
                        lda #BH_SprtColorHillCapPieces ; 
.SetSpriteColors        sta SP0COL,x                ; VIC($D027) Color Sprite 0
                        inx                         ; 
                        cpx #$07                    ; 
                        bne .SetSpriteColors        ; 
                        
                        lda #$01                    ; 
                        sta SPMC0                   ; VIC($D025) Sprite Multicolor Register 0
                        
                        lda #$00                    ; 
                        sta SPMC1                   ; VIC($D026) Sprite Multicolor Register 1
                        
                        lda #BH_SprtColorHillCapExplode ; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        
                        lda #$7c                    ; 
                        sta SPMC                    ; VIC($D01C) Sprite Multicolor
                        
                        lda #$30                    ; 
                        sta TabMoveSpriteUpDo_03    ; 
                        
                        lda #$28                    ; 
                        sta TabMoveSpriteUpDo_02    ; 
                        sta TabMoveSpriteUpDo_04    ; 
                        
                        lda #$14                    ; 
                        sta TabMoveSpriteLeRi_04    ; 
                        
                        ora #$80                    ; 
                        sta TabMoveSpriteLeRi_02    ; 
                        
                        lda #$3b                    ; 
                        sta TabMoveSpriteLeRi_06    ; 
                        
                        ora #$80                    ; 
                        sta TabMoveSpriteLeRi_05    ; 
                        
                        lda #$00                    ; 
                        sta TabMoveSpriteUpDo_05    ; 
                        sta TabMoveSpriteUpDo_06    ; 
                        
                        lda #$45                    ; 
                        sta SP7Y                    ; VIC($D00F) Sprite 7 Y-Pos (Bits 0-7)
                        
                        lda #$04                    ; 
                        sta TabWaitTimeCapExplSav   ; 
                        sta TabWaitTimeCapExpl      ; 
                        
                        lda #$3c                    ; 
                        sta TabWaitHillExplode      ; 
                        
                        lda #$02                    ; 
                        sta TabWaitTimeExplCapSav   ; 
                        sta TabWaitTimeExplCap      ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagExplodeCap   ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveEnemy    ; 
                        sta TabWaitFlagTargetHit    ; 
                        
                        lda #$fd                    ; ######.#
                        sta SPENA                   ; VIC($D015) Sprite Enable Register
                        
                        lda #$5c                    ; 
                        sta Screen_Hill_CapTop + $00; .hbu013.
                        sta Screen_Hill_CapTop + $01; .hbu013.
                        sta Screen_Hill_CapTop + $02; .hbu013.
                        sta Screen_Hill_CapTop + $03; .hbu013.
                        
                        sta Screen_Hill_CapBot + $00; .hbu013.
                        sta Screen_Hill_CapBot + $01; .hbu013.
                        sta Screen_Hill_CapBot + $02; .hbu013.
                        sta Screen_Hill_CapBot + $03; .hbu013.
                        sta Screen_Hill_CapBot + $04; .hbu013.
                        
                        lda #[COLORAM_MCM_On | CYAN]; color sky behind cap ruin
                        sta Colors_Hill_CapBot + $01; .hbu013.
                        sta Colors_Hill_CapBot + $02; .hbu013.
                        sta Colors_Hill_CapBot + $03; .hbu013.
                        
                        jsr ResetVoc1               ; 
                        jsr ResetVoc2               ; 
                        jsr ResetVoc3               ; 
                        
                        lda TabFilterCutHi          ; 
                        sta CUTHI                   ; SID($D416) Filter Cutoff Frequency (high byte)
                        
                        lda #$08                    ; 
                        sta FREHI1                  ; SID($D401) Oscillator 1 Freq Ctrl (high byte)
                        lda #$07                    ; 
                        sta FREHI2                  ; SID($D408) Oscillator 2 Freq Ctrl (high byte)
                        lda #$09                    ; 
                        sta FREHI3                  ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        
                        lda #$0e                    ; 
                        sta ATDCY1                  ; SID($D405) Oscillator 1 Attack/Decay2
                        sta ATDCY2                  ; SID($D40C) Oscillator 2 Attack/Decay
                        sta ATDCY3                  ; SID($D413) Oscillator 3 Attack/Decay
                        
                        lda #$81                    ; 
                        sta VCREG1                  ; SID($D404) Oscillator 1 Control
                        sta VCREG2                  ; SID($D40B) Oscillator 2 Control
                        sta VCREG3                  ; SID($D412) Oscillator 3 Control
                        
                        lda #$7c                    ; .#####..
.Init                   jsr SpritesAcToTabActive    ; 
                        
.HillCapExplode_Loop    jsr HillCapPiecesMoveUpDo   ; 
                        jsr HillCapSetSprtPtrs      ; 
                        jsr HillCapPiecesChkMaxY    ; -> with a return 
                        jsr HillCapSetBlack         ; 
                        
HillCannonCapExplodeX   jmp .HillCapExplode_Loop    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCapPiecesMoveUpDo Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCapPiecesMoveUpDo   subroutine                  ; 
                        lda TabWaitFlagExplodeCap   ; 
                        beq .SetCapExplodeWaitFlag  ; TabWaitFlag_No
                        
.Exit                   rts                         ; 
                        
.SetCapExplodeWaitFlag  inc TabWaitFlagExplodeCap   ; TabWaitFlag_Yes
                        
                        ldx #$02                    ; 
.GetNextMoveUpDo        lda TabMoveSpriteUpDo,x     ; 
                        bmi .ChkMoveDoMax           ; TabMoveSprite_Do
                        beq .SetMoveDo              ; TabMoveSpriteUpDo_None = no value
                        
                        dec TabMoveSpriteUpDo,x     ; TabMoveSprite_Up
                        
.SetNextMoveUpDo        inx                         ; 
                        cpx #$07                    ; 
                        bne .GetNextMoveUpDo        ; 
                        
.Exit_1                 rts                         ; 
                        
.SetMoveDo              ora #TabMoveSprite_Do       ; 
                        sta TabMoveSpriteUpDo,x     ; 
                        jmp .SetNextMoveUpDo        ; 
                        
.ChkMoveDoMax           cmp #$bb                    ; 
                        beq .SetNextMoveUpDo        ; 
                        
                        inc TabMoveSpriteUpDo,x     ; 
HillCapPiecesMoveUpDoX  jmp .SetNextMoveUpDo        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCapSetSprtPtrs    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCapSetSprtPtrs      subroutine                  ; 
                        lda TabWaitFlagMoveEnemy    ; 
                        beq .SetMoveWaitFlag        ; 
                        
                        rts                         ; 
                        
.SetMoveWaitFlag        inc TabWaitFlagMoveEnemy    ; TabWaitFlag_Yes
                        
                        ldx #$02                    ; 
.GetNextPieceSprite     lda TabSpriteActive,x       ; 
                        beq .SetNextPieceSprite     ; 
                        
                        lda BH_SpritePointer03_A    ; 
                        cmp #SP_Ptr_Hill_31         ; explosion hill cap piece  8
                        beq .SetNextPieceSpritePtr  ; 
                        
                        inc BH_SpritePointers_A,x   ; 
                        jmp .SetNextPieceSprite     ; 
                        
.SetNextPieceSpritePtr  txa                         ; 
                        sec                         ; 
                        sbc #$02                    ; 
                        asl a                       ; 
                        asl a                       ; 
                        clc                         ; 
                        adc #SP_Ptr_Hill_2a         ; explosion hill cap piece  1
                        sta BH_SpritePointers_A,x   ; 
                        
.SetNextPieceSprite     inx                         ; 
                        cpx #$07                    ; 
                        bne .GetNextPieceSprite     ; 
                        
HillCapSetSprtPtrsX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCapPiecesChkMaxY  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCapPiecesChkMaxY    subroutine                  ; 
                        lda #$00                    ; 
                        sta TabTankObstOffNext      ; 
                        
                        ldx #$02                    ; 
.GetNextPiesSpriteOff   jsr SpritesGetVicOffFromXr  ; yr = xr * 2
                        lda SP0Y,y                  ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp TabCapPiecesMaxPosY,x   ; 
                        bcc .IncOff                 ; lower
                        
                        lda #$00                    ; 
                        sta TabSpriteActive,x       ; 
                        jmp .SetNextPiesSpriteOff   ; 
                        
.IncOff                 inc TabTankObstOffNext      ; 
                        
.SetNextPiesSpriteOff   inx                         ; 
                        cpx #$07                    ; 
                        bne .GetNextPiesSpriteOff   ; 
                        
                        lda TabTankObstOffNext      ; 
                        bne HillCapPiecesChkMaxYX   ; 
                        
                        pla                         ; 
                        pla                         ; 
HillCapPiecesChkMaxYX   rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCapSetBlack       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCapSetBlack         subroutine                  ; 
                        lda TabWaitFlagTargetHit    ; 
                        beq .ColorCap               ; TabWaitFlag_No
                        
                        rts                         ; 
                        
.ColorCap               lda #BH_SprtColorHillCapRuin; 
                        sta SP7COL                  ; VIC($D02E) Color Sprite 7
                        
HillCapSetBlackX        rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillCannonWaveFlag    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillCannonWaveFlag      subroutine                  ; 
                        ldx #$02                    ; 
.ChkWaveTime            lda TabMoveSpriteLeRiTime,x ; 
                        beq .SetNextFlagPos         ; 
                        
                        rts                         ; 
                        
.SetNextFlagPos         inx                         ; 
                        cpx #$07                    ; no flags + $01
                        bne .ChkWaveTime            ; 
                        
                        lda #SP_Ptr_Hill_3e         ; wave white flag right step 1 - max left
                        sta BH_SpritePointer01_A    ; 
                        
                        lda #$0a                    ; 
                        sta TabWaitTimeHillFlagSav  ; 
                        sta TabWaitTimeHillFlag     ; 
                        
                        lda #BH_SprtColorHillResignFlag ; 
                        sta SP1COL                  ; VIC($D028) Color Sprite 1
                        
                        lda #$44                    ; 
                        sta SP1Y                    ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        lda #$b0                    ; 
                        sta SP1X                    ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        ldx #$01                    ; 
                        jsr SpritesEnableNoFromXr   ; 
                        
                        lda #TabWaitFlag_Yes        ; 
                        sta TabWaitFlagMoveEnemy    ; 
                        jsr ResetTOD1               ; 
                        
.Wave                   lda TabWaitFlagMoveEnemy    ; 
                        bne .Wave                   ; 
                        
                        inc TabWaitFlagMoveEnemy    ; TabWaitFlag_Yes
                        
                        lda BH_SpritePointer01_A    ; 
                        cmp #SP_Ptr_Hill_43         ; wave white flag left step 3
                        beq .GetMaxWaveLeft         ; 
                        
                        inc BH_SpritePointer01_A    ; 
                        jmp .ChkTimer               ; 
                        
.GetMaxWaveLeft         lda #SP_Ptr_Hill_3e         ; wave white flag right step 1 - max left
                        sta BH_SpritePointer01_A    ; 
                        
.ChkTimer               lda TODSEC                  ; CIA1($DC09) Time of Day Clock Seconds
                        cmp #$10                    ; 
                        bcc .Wave                   ; 
                        
                        sta TODHRS                  ; CIA1($DC0B) Time of Day Clock Hours
HillCannonWaveFlagX     rts                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HillDemo              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HillDemo                subroutine                  ; 
                        lda TabGameMode             ; 
                        bne .ChkDemoTime            ; TabGameModeDemo or TabGameModeExit
                        
                        rts                         ; 
                        
.ChkDemoTime            lda TO2SEC                  ; CIA2($DD09) Time of Day Clock Seconds
                        cmp #$10                    ; 
                        bne .ChkCannonPosX_Msb      ; 
                        
                        jsr ResetTOD2               ; 
                        
                        pla                         ; level1
                        pla                         ; 
                        
                        pla                         ; level2
                        pla                         ; 
                        
                        lda #TabShowScoresDemo      ; no HiScore entry
                        sta TabPlayerShowScores     ; 
                        
                        rts                         ; 
                        
.ChkCannonPosX_Msb      lda #$01                    ; 
                        bit MSIGX                   ; VIC($D010) MSB X-Pos Sprites 0-7
                        beq .ChkTargPosX            ; 
                        
.SetCannonMov_Le        lda #CIA_Joy_Le             ; 
                        sta TabJoysticAction        ; 
                        
                        jmp .ChkTargPosY            ; 
                        
.ChkTargPosX            lda SP0X                    ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        cmp SP4X                    ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        beq .ChkTargPosY            ; 
                        bcs .SetCannonMov_Le        ; 
                        
                        lda #CIA_Joy_Ri             ; 
                        sta TabJoysticAction        ; 
                        
.ChkTargPosY            lda TabCannonShotDegree     ; 
                        clc                         ; 
                        adc #$04                    ; 
                        cmp SP4Y                    ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        beq .SetCannonMov_Fi        ; target fully aimed
                        bcs .GetCannonMov_Do        ; 
                        
.GetCannonMov_Up        lda #CIA_Joy_Up             ; 
                        
.SetCannonMov_UpDo      ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
.SetCannonMov_Fi        lda #CIA_Joy_Fi             ; 
                        ora TabJoysticAction        ; 
                        sta TabJoysticAction        ; 
                        
                        rts                         ; 
                        
.GetCannonMov_Do        lda #CIA_Joy_Do             ; 
HillDemoX               jmp .SetCannonMov_UpDo      ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $9600                 ; Beach Head - HICODE.prg Tables
; -------------------------------------------------------------------------------------------------------------- ;
; Player Working Values
; -------------------------------------------------------------------------------------------------------------- ;
TabPlayerSkillLevel     dc.b $01 ; .hbu001. - peeked from BASIC line 120
TabPlayerInGame         dc.b $01 ; .hbu001. - peeked from BASIC line 120
TabStatusScrnTextColor  dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Player Working Values
; -------------------------------------------------------------------------------------------------------------- ;
TabPlayerShowScore      dc.b $01 ; player1
                        dc.b $00 ; player2
TabPlayerActive         dc.b $00 ; 
TabPlayerScoreLo        dc.b $20 ; 
TabPlayerScoreHi        dc.b $01 ; 
TabPlayerShowScores     dc.b $02 ; .hbu001. - peeked from BASIC line 216
TabShowScoresNo            = $00 ; 
TabShowScoresYes           = $01 ; 
TabShowScoresDemo          = $02 ; no HiScore entry
TabPlayerCavePassed     dc.b $81 ; 
TabCavePassedIni           = $00 ; 
TabCavePassedYesGame       = $01 ; entered bay via cave
TabCavePassedNo            = $80 ; entered bay directly
TabCavePassedYesChase      = $81 ; entered bay via cave
TabPlayerLives          dc.b $02 ; 
TabPlayerTanksLeft      dc.b $00 ; 
TabPlayerHillTargsToHit dc.b $0a ; 
TabPlayerShips          dc.b $02 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabMyFleetPosX          dc.b $85 ; 
TabMyFleetPosY          dc.b $ad ; 
TabMyFleetMsbPosX       dc.b $00 ; 
TabPlanes2Start         dc.b $0a ; 
TabBayMapSeaChapters    dc.b $01 ; 
TabBayMapSeaChaptersNo    = $00  ; storm the hill chapters
TabBayMapSeaChaptersYes   = $01  ; bay shoot outs
TabCaveShipSpeed        dc.b $07 ; 
TabCaveShipSpeedMin       = $00  ; 
TabCaveShipSpeedMax       = $07  ; 
TabCaveShipSpeedInit      = TabCaveShipSpeedMin ; 
TabCaveShipExits        dc.b $00 ; 
TabCaveShipExitsNo        = $00  ; 
TabCaveShipExitsYes       = $01  ; 
TabSprtSprtCollReg      dc.b $00 ; 
TabSprtBackCollReg      dc.b $00 ; 
TabWaitTimeTOD_Sec      dc.b $05 ; 
TabWaitTimeTOD_10th     dc.b $09 ; 
TabPlayerVesselActive   dc.b $3e ; ..#####. - one bit per ship
                        
TabPlrShootSprtBasePtr1 dc.b $41 ; 
TabPlrShootSprtBasePtr2 dc.b $4d ; 
                        
TabCannonShotDegree     dc.b $60 ; 
TabCannonShotHeight     dc.b $9c ; 
TabCannonShotDist       dc.b $60 ; 
                        
TabPlayerShoots         dc.b $00 ; 
TabPlayerShootsNo         = $00  ; 
TabPlayerShootsYes        = $01  ; 
                        
TabPlayerShootSpriteNo  dc.b $01 ; 
                        
TabBulletHight          dc.b $00 ; 
                        dc.b $00 ; bullet1
                        dc.b $00 ; bullet2
                        dc.b $00 ; 
                        
TabDemoPlaneMyPosX      dc.b $00 ; cannon
TabDemoPlaneMyPosX_MSB  dc.b $00 ; 
TabDemoPlanePosX        dc.b $00 ; plane
TabDemoPlanePosX_MSB    dc.b $00 ; 
                        
TabIRQScreenPartFlag    dc.b $00 ; 
TabIRQScreenPartGfx        = $01 ; 
TabIRQScreenPartStatus     = $00 ; 
TabTankActiveScreen     dc.b $01 ; screen A
TabVicMemControl        dc.b $20 ; 
TabVicMemControlSetA    dc.b BH_MemScreenValA ; $20 ; ..#. ... o - Scrn_adr=$0800-$0be7($02) Chars=$0000-$07ff
TabVicMemControlSetB    dc.b BH_MemScreenValB ; $30 ; ..## ... o - Scrn_adr=$0c00-$0fe7($03) Chars=$0000-$07ff
TabBackGroundColor      dc.b YELLOW ; 
TabBackGroundColorStat  dc.b BLACK ; 
TabVicScrollSoftPosY    dc.b $03 ; 
TabTankScrollSoftPosY   dc.b $00 ; 
TabVicScrollSoftPosX    dc.b $00 ; 
TabTankScrollSoftPosX   dc.b $03 ; 
TabScreenTankColorFlag  dc.b $00 ; 
TabScreenTankColorNo       = $00 ; 
TabScreenTankColorYes      = $ff ; 
TabScrnTankPosY         dc.b $14 ; 
TabScrnTankPosYSky         = $00 ; 
TabScrnTankPosYTreeTop     = $05 ; 
TabScrnTankPosYTreeLeaf    = $06 ; 
TabScrnTankPosYTreeTwig    = $07 ; 
TabScrnTankPosYTreeTrunk   = $08 ; 
TabScrnTankPosYMax         = $14 ; 
TabTankObstPosY         dc.b $00 ; 
TabTankObstChrNum       dc.b $00 ; 
TabTankObstColor        dc.b $06 ; 
TabSaveCharDataByte     equ  *   ; 
TabSaveSpriteDataCopyXR equ  *   ; 
TabTankObstOffNext      dc.b $00 ; 
TabScrnTankPosX         dc.b $00 ; 
TabScrnTankPosXMax         = $26 ; 
TabScrnTankBayCharPtr   dc.b $04 ; 
TabScrnGfxActualMaxX       = BH_Scrn_RowLen ; 
TabScrnTankBayCharNext  dc.b $03 ; 
TabScrnTankBayCharNextIni  = $08 ; 
TabScrnTankScrollPos    dc.b $ae ; 
TabScrnTankScrollPosIni    = $d8 ; column count down
TabScrnTankScrollPosOff    = $ca ; 
TabScrnTankScrollPosGo     = $d2 ; .hbu010.
TabScrnTankScrollPosTst    = $b0 ; for strand testing
TabScrnTankBayScrollDec dc.b $d5 ; 
TabTankScrollAreaTabPtr dc.b $00 ; 
TabTankScrollAreaTabPtrStart= $d8; 
TabTankScrollAreaTabPtrEnd  = $00; 
TabPlayerBulletPhaseNo  dc.b $00 ; 
TabScrnTankBayScrollFin dc.b $00 ; 
TabScrnTankBayScrollFinNo  = $ff ; 
TabScrnTankBayScrollFinYes = $00 ; 
TabCharDataPtrOutLo     dc.b $38 ; 
TabCharDataPtrOutHi     dc.b $04 ; 
TabTankSprtScrollSpeed  dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
TabJoysticAction        dc.b $00 ; 
TabUserAction           dc.b $01 ; 
TabUserActionNo           = $00  ; 
TabUserActionYes          = $01  ; 

TabGameMode             dc.b $00 ; .hbu001. - peeked from BASIC lines 85/105/216
TabGameModeGame           = $00  ; 
TabGameModeDemoToCave     = $01  ; fleet moves to cave
TabGameModeDemoInBay      = $02  ; fleet encounters enemy fleet
TabGameModeDemoToBeach    = $03  ; fleet moves to beach
TabGameModeExit           = $ff  ; 

TabPlaneDirReLi         dc.b $00 ; 
TabPlaneDirReLiStop       = $00  ;
TabPlaneDirReLiCont       = $01  ;
TabPlaneDirReLi_2         = $02  ;
TabPlaneDirReLi_3         = $03  ;
TabPlaneDirReLi_4         = $04  ;
TabPlaneDirReLi_5         = $05  ;
TabPlaneDirReLi_01      dc.b $00 ; 
TabPlaneDirReLi_02      dc.b $00 ; 
TabPlaneDirReLi_03      dc.b $00 ; 
TabPlaneDirReLi_04      dc.b $00 ; 
TabPlaneDirReLi_05      dc.b $00 ; 
TabPlaneDirReLi_06      dc.b $00 ; 
TabPlaneDirReLi_07      dc.b $00 ; 

TabPlaneDirUpDo         dc.b $00 ; 
TabPlaneDirUpDo_0         = $00  ; 
TabPlaneDirUpDo_1         = $01  ; 
TabPlaneDirUpDo_2         = $02  ; 
TabPlaneDirUpDo_01      dc.b $00 ; 
TabPlaneDirUpDo_02      dc.b $00 ; 
TabPlaneDirUpDo_03      dc.b $00 ; 
TabPlaneDirUpDo_04      dc.b $00 ; 
TabPlaneDirUpDo_05      dc.b $00 ; 
TabPlaneDirUpDo_06      dc.b $00 ; 
TabPlaneDirUpDo_07      dc.b $00 ; 

TabPlaneFlies           dc.b $00 ; 
TabPlaneFliesNo           = $00  ; 
TabPlaneFliesYes          = $01  ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabMoveSpriteLeRiTime   dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabMoveSpriteUpDoTime   dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabSpriteStepCount      dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
TabBulletStepCount      equ  *   ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Wait Times: Start  of Wait Time Blocks
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlag_No            = $00  ; std global wait flag values
TabWaitFlag_Yes           = $01  ;
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block01    equ  *   ; IRQ_Exec_Waits: times block 01
TabWaitTimes            equ  *   ;                         
TabWaitTimePause        equ  *   ; 
TabWaitTimeExplTank     dc.b $01 ; 
TabWaitTimeHillFlag     equ  *   ; 
TabWaitTimeTankShot     equ  *   ; 
TabWaitTimeHillShot     equ  *   ; 
TabWaitTimeCapExpl      dc.b $01 ; 
TabWaitTimeHillShotE    equ  *   ; 
TabWaitWaterSplash      equ  *   ; 
TabWaitHillCannonAim    dc.b $01 ; 
TabWaitBulletFly        dc.b $01 ; 
TabWaitSinkShip         dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
TabWaitHillExplode      dc.b $01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block02    equ  *   ; IRQ_Exec_Waits: times block 02
                        dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
                        dc.b $06 ;
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block03    equ  *   ; IRQ_Exec_Waits: times block 03
TabWaitTimeMoveUpDo     dc.b $01 ; 
TabWaitTimeBullFlyPh    dc.b $01 ; 
TabWaitTimeBells        dc.b $01 ; 
TabWaitFlagBullFlyE     dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block04    equ  *   ; IRQ_Exec_Waits: times block 04
TabWaitTimePlaneFly     equ  *   ; 
TabWaitTimeExplCap      dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block05    equ  *   ; IRQ_Exec_Waits: times block 05
TabPlaySfxVoc1_00       dc.b $01 ; 
TabPlaySfxVoc1_01       dc.b $01 ; 
                        dc.b $01 ; 
TabPlaySfxVoc1_03       dc.b $01 ; 
TabPlaySfxVoc1_04       dc.b $01 ; 
TabPlaySfxVoc1_05       dc.b $01 ; 
TabPlaySfxVoc1_06       dc.b $01 ; 
                        dc.b $20 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Wait Times: Flags
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlags            equ  *   ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlags_Block01    equ  *   ; IRQ_Exec_Waits: flags block 01
TabWaitFlagPause        equ  *   ; 
TabWaitFlagExplTank     equ  *   ; 
TabWaitFlagMoveLeRi     dc.b $00 ; $01
TabWaitFlagMoveEnemy    dc.b $00 ; $02
TabWaitFlagAutoAction   dc.b $00 ; $03
TabWaitFlagBulletFly    dc.b $00 ; $04
TabWaitFlagSinkShip     dc.b $00 ; $05
TabWaitFlagMoveShip     dc.b $00 ; $06
                        dc.b $00 ; 
TabWaitFlagTargetHit    dc.b $00 ; $08
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlags_Block02    equ  *   ; IRQ_Exec_Waits: flags block 02
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlags_Block03    equ  *   ; IRQ_Exec_Waits: flags block 03
TabWaitFlagMoveUpDo     dc.b $00 ; $01
TabWaitFlagBulletFlyPh  dc.b $00 ; $02
TabWaitFlagPing         dc.b $00 ; $03
TabWaitFlagPlaneFly     dc.b $00 ; $04
                        dc.b $00 ; $05
                        dc.b $00 ; $06
                        dc.b $00 ; $07
                        dc.b $00 ; $08
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlags_Block04    equ  *   ; IRQ_Exec_Waits: flags block 04
TabWaitFlagExplodeCap   dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitFlags_Block05    equ  *   ; IRQ_Exec_Waits: flags block 05
TabWaitFlagLeRi         dc.b $00 ; $01
TabWaitFlagUpDo         dc.b $00 ; $02
                        dc.b $00 ; $03
TabWaitFlagExplode      dc.b $00 ; $04
TabWaitFlagSfxShotPlane dc.b $00 ; $05
TabWaitFlagSfx          dc.b $00 ; $06
TabWaitFlagSfxShot      dc.b $00 ; $07
TabWaitFlagAmmoInc      dc.b $00 ; $08
; -------------------------------------------------------------------------------------------------------------- ;
; Wait Times Save Values for Restore: default=$01
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimesSav         equ  *   ; saved values for restore after waitime has run out
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block01Sav equ  *   ; IRQ_Exec_Waits: saves block 01
TabWaitTimeExplTankSav  equ  *   ; 
TabWaitTimeBayLeRiSav   equ  *   ; 
TabWaitTimeCanLeRiSav   equ  *   ; 
TabWaitTimeBeachLeRiSav dc.b $01 ; 
TabWaitTimeBayLeRiSavE  equ  *   ; 
TabWaitTimeHillFlagSav  equ  *   ; 
TabWaitTimeTankShotSav  equ  *   ; 
TabWaitTimeHillShotSav  equ  *   ; 
TabWaitTimeCapExplSav   dc.b $01 ; 
TabWaitTimeHillShotSavE equ  *   ; 
TabWaitTimeBayBlinkSav  equ  *   ; 
TabWaitHillCannonAimSav dc.b $01 ; 
TabWaitBulletFlySav     dc.b $01 ; 
TabWaitSinkShipSav      dc.b $01 ; 
TabWaitMoveCarrierSav   dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block02Sav equ  *   ; IRQ_Exec_Waits: saves block 02
TabWaitTimePlaneFlyLe   dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
                        dc.b $06 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block03Sav equ  *   ; IRQ_Exec_Waits: saves block 03
TabWaitTimeBayUpDoSav   equ  *   ; 
TabWaitTimeCanUpDoSav   equ  *   ; 
TabWaitTimeBeachUpDoSav equ  *   ; 
TabCountDown1_00        dc.b $01 ; 
TabWaitTimeBayUpDoSavE  equ  *   ; 
TabWaitTimeBullFlyPhSav dc.b $01 ; 
TabWaitTimeBellsSav     dc.b $01 ; 
TabWaitFlagBullFlyESav  dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block04Sav equ  *   ; IRQ_Exec_Waits: saves block 04
TabWaitTimePlaneFlySav  equ  *   ; 
TabWaitTimeExplCapSav   dc.b $02 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
                        dc.b $1e ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWaitTimes_Block05Sav equ  *   ; IRQ_Exec_Waits: saves block 05
TabPlaySfxVoc2          equ  *   ; 
TabPlaySfxVoc2_00       dc.b $01 ; 
TabPlaySfxVoc2_01       dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
TabPlaySfxVoc2_05       dc.b $01 ; 
TabPlaySfxVoc2_06       dc.b $01 ; 
TabPlaySfxVoc2_07       dc.b $20 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Wait Times: End of Wait Time Blocks
; -------------------------------------------------------------------------------------------------------------- ;
TabMoveSpriteLeRi       dc.b $00 ; cave and planes
TabMoveSprite_Le          = $80  ; bit7:flag: move left
TabMoveSprite_Ri          = $00  ; bit7:flag: move right
TabMoveSpriteLeRi_01    dc.b $00 ; 
TabMoveSpriteLeRi_02    dc.b $00 ; 
TabMoveSpriteLeRi_03    dc.b $00 ; 
TabMoveSpriteLeRi_04    dc.b $00 ; 
TabMoveTranspLeRi       equ  *   ; 
TabMoveSpriteLeRi_05    dc.b $00 ; 
TabMoveSpriteLeRi_06    dc.b $00 ; 
TabMoveSpriteLeRi_07    dc.b $00 ; 
                        
TabMoveSpriteUpDo       dc.b $00 ; cave and planes
TabMoveSprite_Up          = $00  ; bit7:flag: move right
TabMoveSprite_Do          = $80  ; bit7:flag: move left
TabMoveSpriteUpDo_01    dc.b $00 ; 
TabMoveSpriteUpDo_02    dc.b $00 ; 
TabMoveSpriteUpDo_03    dc.b $00 ; 
TabMoveSpriteUpDo_04    dc.b $00 ; 
TabMoveSpriteUpDo_05    dc.b $00 ; 
TabMoveSpriteUpDo_06    dc.b $00 ; 
TabMoveSpriteUpDo_07    dc.b $00 ; 

TabPlaneSpeedAppr       dc.b $00 ; 
TabPlaneSpeedApprNone     = $00  ;
TabPlaneSpeedApprSlow     = $02  ;
TabPlaneSpeedApprFast     = $03  ;
TabPlaneSpeedAppr_01    dc.b $00 ; 
TabPlaneSpeedAppr_02    dc.b $00 ; 
TabPlaneSpeedAppr_03    dc.b $00 ; 
TabPlaneSpeedAppr_04    dc.b $00 ; 
TabPlaneSpeedAppr_05    dc.b $00 ; 
TabPlaneSpeedAppr_06    dc.b $00 ; 
TabPlaneSpeedAppr_07    dc.b $00 ; 
                        
TabSpriteStatus         dc.b $00 ; 
TabSpriteStatusFree       = $00  ; 
TabSpriteStatusUsed       = $01  ; 
TabSpriteStatusExpl       = $ff  ; 
TabSpriteStatus_01      dc.b $00 ; 
TabSpriteStatus_02      dc.b $00 ; 
TabSpriteStatus_03      dc.b $00 ; enemy plane shot
TabSpriteStatus_04      dc.b $00 ; 
TabSpriteStatus_05      dc.b $00 ; 
TabSpriteStatus_06      dc.b $00 ; player shot
TabSpriteStatus_07      dc.b $00 ; 

TabPlaneDistance        dc.b $00 ; 
TabPlaneDist_Ini          = $00  ; 
TabPlaneDist_Explode      = $ff  ; 
TabPlaneDist_Start        = $01  ; 
TabPlaneDist_Turn         = $02  ; 
TabPlaneDist_Approach1    = $03  ; 
TabPlaneDist_Approach2    = $04  ; 
TabPlaneDist_Approach3    = $05  ; 
TabPlaneDist_Leave        = $06  ; 
TabPlaneDistance_01     dc.b $00 ; 
TabPlaneDistance_02     dc.b $00 ; 
TabPlaneDistance_03     dc.b $00 ; 
TabPlaneDistance_04     dc.b $00 ; 
TabPlaneDistance_05     dc.b $00 ; 
TabPlaneDistance_06     dc.b $00 ; 
TabPlaneDistance_07     dc.b $00 ; 
                        
TabSeaShipMsgDestroy    dc.b $00 ; 
TabSeaShipMsgDestroyNo    = $00  ; 
TabSeaShipMsgDestroyYes   = $01  ; 
TabWrkPlayerShot        dc.b $00 ; 

TabPlayerAmmo           dc.b $0a ; 

TabTargetHit            dc.b $00 ; 
TabTargetHitNo            = $00  ; 
TabTargetHitYes           = $01  ; 

TabBulletActive         dc.b $01 ; 
TabBulletActiveNo         = $00  ; 
TabBulletActiveYes        = $01  ; 
TabBulletDamage         dc.b $14 ; 
                        
TabSeaVesselShoots      dc.b $03 ; 
TabSeaVesselShoots_01     = $01  ; vessel 01
TabSeaVesselShoots_02     = $02  ; vessel 02
TabSeaVesselShoots_03     = $03  ; vessel 03
TabSeaVesselShoots_04     = $04  ; vessel 04
TabSeaVesselShootsNone    = $ff  ; 
TabBulletEnemyDist      dc.b $a0 ; 
TabBulletEnemyDistIni     = $94  ; 
TabBulletEnemyDistMax     = $b0  ; 

TabSeaVesselActive      dc.b $01 ; not used - count starts at $01
TabSeaVesselActiveNo      = $00  ; 
TabSeaVesselActiveYes     = $01  ; 
TabSeaVesselActive_01   dc.b $01 ; 
TabSeaVesselActive_02   dc.b $01 ; 
TabSeaVesselActive_03   dc.b $01 ; 
TabSeaVesselActive_04   dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        dc.b $01 ; 
                        
TabFlagCarrierActive    dc.b $01 ; 
TabFlagCarrierActiveNo    = $00  ; 
TabFlagCarrierActiveYes   = $01  ; 

TabBulletWaterSplash    dc.b $00 ; 
TabBulletWaterSplashNo    = $00  ; 
TabBulletWaterSplashYes   = $01  ; 

TabBeachLevelNo         dc.b $05 ; .hbu016.
TabBeachLevelNoWait     dc.b $02 ; .hbu016. - used to display a subset of sprites if not $00
TabWaitTankEneShoot     dc.b $00 ; 
TabWaitTankEneShootNo     = $00  ; 
TabWaitTankEneShootYes    = $01  ; 
TabTankShotSprtNoSav    dc.b $00 ; 
TabTankShotSpeedEne     dc.b $03 ; 
TabTankScoreSpriteNo    dc.b $00 ; 

TabPlaneNoToExplode     equ  *   ; 
TabTempStore            dc.b $07 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWrkRnd               dc.b $a8 ; 
TabWrkXtraLoops         dc.b $00 ; .hbu018.
TabWrkMakeDecimal       dc.b $02 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Player Game Variables Save Area
; -------------------------------------------------------------------------------------------------------------- ;
TabPlayersSaveArea      equ  *   ; 
TabPlayerLivesSav       dc.b $02 ; p1
                        dc.b $00 ; p2
                        
TabPlayerShowScoresSav  dc.b $00 ; p1
                        dc.b $00 ; p2
                        
TabPlayerScoreLoSav     dc.b $20 ; .hbu001. - p1 - peeked from BASIC line 820
                        dc.b $30 ; .hbu001. - p2 - peeked from BASIC line 820
                        
TabPlayerScoreHiSav     dc.b $01 ; .hbu001. - p1 - peeked from BASIC line 820
                        dc.b $00 ; .hbu001. - p2 - peeked from BASIC line 820
                        
TabPlayerCavePassSav    dc.b $81 ; p1
                        dc.b $01 ; 
                        
TabPlayerShipsSav       dc.b $02 ; p1
                        dc.b $01 ; p2
                        
TabPlayerVesselActSav   dc.b $3e ; ..#####. - one bit per ship
                        dc.b $3e ; ..#####. - one bit per ship
                        
TabPlayerBeachLvlSav    dc.b $05 ; .hbu016. - player 1
                        dc.b $05 ; .hbu016. - player 2
                        
TabPlayerTanksSav       dc.b $00 ; p1
                        dc.b $00 ; p2
                        
TabPlayerHillTargsSav   dc.b $0a ; 
                        dc.b $0a ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabPlayerNoUseSav1      dc.b $00 ; unused
                        dc.b $00 ; 
                        
TabPlayerNoUseSav2      dc.b $a8 ; unused
                        dc.b $a8 ; 
                        
TabPlayerNoUseSav3      dc.b $dd ; unused
                        dc.b $60 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabCaveShipDir          dc.b $55 ; 
TabCaveShipDirMin         = $00
TabCaveShipDirMax         = $04
TabCaveShipDirInit        = $01

TabTankShotSpeed        dc.b $04 ; 

TabTankAdaptPosX        equ  *   ; 
TabTankAdaptPosX_00     dc.b $dd ; 
TabTankAdaptPosX_01     dc.b $00 ; 
TabTankAdaptPosX_02     dc.b $00 ; 
TabTankAdaptPosX_03     dc.b $00 ; 
TabTankAdaptPosX_04     dc.b $00 ; 
TabTankAdaptPosX_05     dc.b $00 ; 
TabTankAdaptPosX_06     dc.b $00 ; 
TabTankAdaptPosX_07     dc.b $00 ; 
                        
TabSpriteActive         dc.b $00 ; 
TabSpriteActiveNo         = $00  ;
TabSpriteActiveYes        = $01  ;
TabSpriteActive_01      dc.b $00 ; 
TabSpriteActive_02      dc.b $00 ; 
TabSpriteActive_03      dc.b $00 ; 
TabSpriteActive_04      dc.b $00 ; 
TabTranspActive         equ  *   ; 
TabSpriteActive_05      dc.b $00 ; 
TabSpriteActive_06      dc.b $00 ; 
TabSpriteActive_07      dc.b $00 ; 
                        
TabSpriteWaitHori       dc.b $0a ; 
                        dc.b $1f ; 
                        dc.b $3b ; 
                        dc.b $03 ; 
                        dc.b $06 ; 
                        dc.b $0d ; 
                        dc.b $2d ; 
                        dc.b $07 ; 
                        
TabSpriteWaitVert       dc.b $2c ; 
                        dc.b $39 ; 
                        dc.b $0f ; 
                        dc.b $0b ; 
                        dc.b $36 ; 
                        dc.b $14 ; 
                        dc.b $05 ; 
                        dc.b $2b ; 
                        
TabPlaneWaitAppr        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $16 ; 
                        dc.b $32 ; 
                        dc.b $16 ; 
                        dc.b $21 ; 

TabMoveSpritesStep      dc.b $00 ; 
TabMoveSpritesStepTime    = $3c  ; 
                        
TabPlaneFreeSprite      dc.b $05 ; 
TabPlaneTranspWait      dc.b $03 ; 
                        
TabPlaneTranspStatus    dc.b $00 ; 
TabPlaneTranspStatusFree  = $00  ; 
TabPlaneTranspStatusUsed  = $01  ; 
                        
TabPlaneTranspWasHit    dc.b $00 ; 
TabPlaneTranspWasHitNo    = $00  ; 
TabPlaneTranspWasHitYes   = $01  ; 
TabPlaneTranspWasHitEnd   = $ff  ; 
                        
TabRndSeed              dc.b $aa ; 
                        
TabPlaneTurn            dc.b $02 ; 
TabPlaneTurnUpLe          = $01  ; 
TabPlaneTurnUp            = $02  ; 
TabPlaneTurnUpRi          = $03  ; 
                        
TabSeaVesselHit         dc.b $ff ; 
TabSeaVesselHit_01        = $01  ; vessel 01
TabSeaVesselHit_02        = $02  ; vessel 02
TabSeaVesselHit_03        = $03  ; vessel 03
TabSeaVesselHit_04        = $04  ; vessel 04
TabSeaVesselHit_05        = $05  ; carrier
TabSeaVesselHitNone       = $ff  ; 
                        
TabSeaVesselHits        dc.b $00 ; .hbu025. - unused
TabSeaVesselHits_01     dc.b $00 ; .hbu025.
TabSeaVesselHits_02     dc.b $00 ; .hbu025.
TabSeaVesselHits_03     dc.b $00 ; .hbu025.
TabSeaVesselHits_04     dc.b $00 ; .hbu025.
TabSeaVesselHits_05     dc.b $00 ; .hbu025.
                        
TabVesselVaryDist       dc.b $60 ; .hbu021. - cannon start value
TabVesselVaryDist_01    dc.b $80 ; .hbu021. - vessel 01
TabVesselVaryDist_02    dc.b $70 ; .hbu021. - vessel 02
TabVesselVaryDist_03    dc.b $8c ; .hbu021. - vessel 03
TabVesselVaryDist_04    dc.b $28 ; .hbu021. - vessel 04
TabVesselVaryDist_05    dc.b $60 ; .hbu021. - carrier
; -------------------------------------------------------------------------------------------------------------- ;
TabSfxToPlay            dc.b $20 ; 
TabVoc1FreqLo           dc.b $a0 ; 
TabVoc3FreqHi           dc.b $bd ; 
TabVoc2AttDec           dc.b $0c ; 
TabVoc2FreqHi           dc.b $08 ; 
TabFilterCutHi          dc.b $5a ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSetFilterCutHi       dc.b $00 ; 
                        dc.b $ff ; 
                        dc.b $80 ; 
                        dc.b $70 ; 
                        dc.b $60 ; 
                        dc.b $70 ; 
                        dc.b $70 ; 
TabSetFilterCutHi_5a    dc.b $5a ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDiskFileEndAdrHi     dc.b $00 ; 
TabDiskFileEndAdrLo     dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabChapterFileName      equ *                       ; .hbu013.
TabFileNam_Intro        dc  "CHA00.INTRO"           ; 
TabFileNam_BayMap       dc  "CHA01.BAYMAP"          ; 
TabFileNam_Cave         dc  "CHA02.CAVE"            ; 
TabFileNam_SeaPlane     dc  "CHA03.SEAPLANE"        ; 
TabFileNam_SeaShips     dc  "CHA04.SEASHIPS"        ; 
TabFileNam_Beach        dc  "CHA05.BAYSHORE"        ; 
TabFileNam_Hill         dc  "CHA06.HILL"            ; 
TabChapterFileNameX     equ *                       ; 
                        
TabChapterFileLen       equ *                       ; 
TabFileLen_Intro        dc.b TabFileNam_BayMap   - TabFileNam_Intro    ; 
TabFileLen_BayMap       dc.b TabFileNam_Cave     - TabFileNam_BayMap   ; 
TabFileLen_Cave         dc.b TabFileNam_SeaPlane - TabFileNam_Cave     ; 
TabFileLen_SeaPlane     dc.b TabFileNam_SeaShips - TabFileNam_SeaPlane ; 
TabFileLen_SeaShips     dc.b TabFileNam_Beach    - TabFileNam_SeaShips ; 
TabFileLen_Beach        dc.b TabFileNam_Hill     - TabFileNam_Beach    ; 
TabFileLen_Hill         dc.b TabChapterFileNameX - TabFileNam_Hill     ; 
                        
TabChapterFileAdrLo     equ *                       ; 
TabFileALo_Intro        dc.b <TabFileNam_Intro      ; 
TabFileALo_BayMap       dc.b <TabFileNam_BayMap     ; 
TabFileALo_Cave         dc.b <TabFileNam_Cave       ; 
TabFileALo_SeaPlane     dc.b <TabFileNam_SeaPlane   ; 
TabFileALo_SeaShips     dc.b <TabFileNam_SeaShips   ; 
TabFileALo_Beach        dc.b <TabFileNam_Beach      ; 
TabFileALo_Hill         dc.b <TabFileNam_Hill       ; 
                        
TabChapterFileAdrHi     equ *                       ; 
TabFileAHi_Intro        dc.b >TabFileNam_Intro      ; 
TabFileAHi_BayMap       dc.b >TabFileNam_BayMap     ; 
TabFileAHi_Cave         dc.b >TabFileNam_Cave       ; 
TabFileAHi_SeaPlane     dc.b >TabFileNam_SeaPlane   ; 
TabFileAHi_SeaShips     dc.b >TabFileNam_SeaShips   ; 
TabFileAHi_Beach        dc.b >TabFileNam_Beach      ; 
TabFileAHi_Hill         dc.b >TabFileNam_Hill       ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabStrandFileName       equ *                       ; .hbu016.
TabStrandFileNam_Level  dc  "SHORE"                 ; 
TabStrandFileNam_10     dc  "0"                     ; 
TabStrandFileNam_1      dc  "0"                     ; 
TabStrandFileNameX      equ *                       ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabControlRaster        dc.b TabControlRasterLand   ; .hbu013.
TabControlRasterLand      = $cd                     ; chapters 1, 2, 5
TabControlRasterCannon    = $c6                     ; chapters 3, 4, 6
; -------------------------------------------------------------------------------------------------------------- ;
Seg_HILL                seg.u   STRAND              ; 
                        include asm\Shore00.asm     ; Strand Scroll Data
; -------------------------------------------------------------------------------------------------------------- ;
